/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MoonPhaseManager {
    private final EasySleep plugin;
    private final Map<String, MoonPhase> worldMoonPhases;
    private final Map<String, Long> lastPhaseCheck;

    public MoonPhaseManager(EasySleep plugin) {
        this.plugin = plugin;
        this.worldMoonPhases = new HashMap<String, MoonPhase>();
        this.lastPhaseCheck = new HashMap<String, Long>();
        this.startMoonPhaseTracking();
    }

    private void startMoonPhaseTracking() {
        new BukkitRunnable(){

            public void run() {
                for (World world : MoonPhaseManager.this.plugin.getServer().getWorlds()) {
                    MoonPhaseManager.this.updateMoonPhase(world);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1200L);
    }

    private void updateMoonPhase(World world) {
        long lastCheck;
        String worldName = world.getName();
        long currentDay = world.getFullTime() / 24000L;
        if (currentDay != (lastCheck = this.lastPhaseCheck.getOrDefault(worldName, -1L).longValue())) {
            MoonPhase oldPhase = this.worldMoonPhases.get(worldName);
            MoonPhase newPhase = this.calculateMoonPhase(currentDay);
            this.worldMoonPhases.put(worldName, newPhase);
            this.lastPhaseCheck.put(worldName, currentDay);
            if (oldPhase != newPhase) {
                this.announceMoonPhaseChange(world, newPhase);
                this.createMoonPhaseEffects(world, newPhase);
            }
        }
    }

    private MoonPhase calculateMoonPhase(long day) {
        int cycle = (int)(day % 8L);
        return MoonPhase.values()[cycle];
    }

    private void announceMoonPhaseChange(World world, MoonPhase moonPhase) {
        if (world.getTime() < 12000L) {
            return;
        }
        MessageUtils.broadcastToWorld(world, "");
        MessageUtils.broadcastToWorld(world, "&8\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        MessageUtils.broadcastToWorld(world, "&f\ud83c\udf19 &f&lLUNAR PHASE TRANSITION &f\ud83c\udf19");
        MessageUtils.broadcastToWorld(world, "&7\u2728 &fCurrent Phase: " + moonPhase.getSymbol() + " &e" + moonPhase.getName());
        MessageUtils.broadcastToWorld(world, "&7\ud83c\udf1f &fSleep Bonus: &a+" + (int)((moonPhase.getSleepBonus() - 1.0) * 100.0) + "%");
        MessageUtils.broadcastToWorld(world, "&7\ud83d\udcab &fLunar Energy: &b" + moonPhase.getDescription());
        MessageUtils.broadcastToWorld(world, "&8\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        MessageUtils.broadcastToWorld(world, "");
    }

    private void createMoonPhaseEffects(World world, MoonPhase moonPhase) {
        Location center = world.getSpawnLocation().add(0.0, 50.0, 0.0);
        switch (moonPhase.ordinal()) {
            case 0: {
                this.createNewMoonEffects(world, center);
                break;
            }
            case 1: {
                this.createWaxingCrescentEffects(world, center);
                break;
            }
            case 2: {
                this.createFirstQuarterEffects(world, center);
                break;
            }
            case 3: {
                this.createWaxingGibbousEffects(world, center);
                break;
            }
            case 4: {
                this.createFullMoonEffects(world, center);
                break;
            }
            case 5: {
                this.createWaningGibbousEffects(world, center);
                break;
            }
            case 6: {
                this.createLastQuarterEffects(world, center);
                break;
            }
            case 7: {
                this.createWaningCrescentEffects(world, center);
            }
        }
        world.playSound(center, Sound.BLOCK_BEACON_POWER_SELECT, 0.3f, this.getMoonPhasePitch(moonPhase));
    }

    private void createNewMoonEffects(World world, Location center) {
        for (int i = 0; i < 20; ++i) {
            double angle = i * 18;
            double radius = 8.0;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            Location effectLoc = center.clone().add(x, 0.0, z);
            world.spawnParticle(Particle.SMOKE_LARGE, effectLoc, 2, 0.5, 0.5, 0.5, 0.02);
        }
    }

    private void createWaxingCrescentEffects(World world, Location center) {
        for (int i = 0; i < 15; ++i) {
            double angle = i * 24;
            double radius = 6.0;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            Location effectLoc = center.clone().add(x, 0.0, z);
            world.spawnParticle(Particle.END_ROD, effectLoc, 1, 0.2, 0.2, 0.2, 0.01);
        }
    }

    private void createFirstQuarterEffects(World world, Location center) {
        for (int i = 0; i < 16; ++i) {
            double angle = (double)i * 22.5;
            double radius = 7.0;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            Location effectLoc = center.clone().add(x, 0.0, z);
            Particle particle = i % 2 == 0 ? Particle.SOUL_FIRE_FLAME : Particle.SMOKE_NORMAL;
            world.spawnParticle(particle, effectLoc, 1, 0.3, 0.3, 0.3, 0.02);
        }
    }

    private void createWaxingGibbousEffects(World world, Location center) {
        for (int i = 0; i < 25; ++i) {
            double angle = (double)i * 14.4;
            double radius = 9.0;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            Location effectLoc = center.clone().add(x, 0.0, z);
            world.spawnParticle(Particle.ENCHANTMENT_TABLE, effectLoc, 2, 0.4, 0.4, 0.4, 0.03);
        }
    }

    private void createFullMoonEffects(World world, Location center) {
        for (int i = 0; i < 40; ++i) {
            double angle = i * 9;
            double radius = 12.0;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.sin(Math.toRadians(angle * 2.0)) * 2.0;
            Location effectLoc = center.clone().add(x, y, z);
            world.spawnParticle(Particle.TOTEM, effectLoc, 3, 0.5, 0.5, 0.5, 0.05);
        }
        world.spawnParticle(Particle.SOUL_FIRE_FLAME, center, 20, 3.0, 3.0, 3.0, 0.1);
        world.strikeLightningEffect(center);
    }

    private void createWaningGibbousEffects(World world, Location center) {
        for (int i = 0; i < 22; ++i) {
            double angle = (double)i * 16.4;
            double radius = 8.5;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            Location effectLoc = center.clone().add(x, 0.0, z);
            world.spawnParticle(Particle.SOUL, effectLoc, 1, 0.3, 0.3, 0.3, 0.02);
        }
    }

    private void createLastQuarterEffects(World world, Location center) {
        for (int i = 0; i < 18; ++i) {
            double angle = i * 20;
            double radius = 7.5;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            Location effectLoc = center.clone().add(x, 0.0, z);
            world.spawnParticle(Particle.CLOUD, effectLoc, 2, 0.4, 0.4, 0.4, 0.03);
        }
    }

    private void createWaningCrescentEffects(World world, Location center) {
        for (int i = 0; i < 12; ++i) {
            double angle = i * 30;
            double radius = 5.5;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            Location effectLoc = center.clone().add(x, 0.0, z);
            world.spawnParticle(Particle.PORTAL, effectLoc, 1, 0.2, 0.2, 0.2, 0.01);
        }
    }

    private float getMoonPhasePitch(MoonPhase moonPhase) {
        switch (moonPhase.ordinal()) {
            case 0: {
                return 0.8f;
            }
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 1.2f;
            }
            case 3: {
                return 1.4f;
            }
            case 4: {
                return 2.0f;
            }
            case 5: {
                return 1.4f;
            }
            case 6: {
                return 1.2f;
            }
            case 7: {
                return 1.0f;
            }
        }
        return 1.0f;
    }

    public void applyMoonPhaseBonus(Player player) {
        World world = player.getWorld();
        MoonPhase moonPhase = this.getCurrentMoonPhase(world);
        if (moonPhase != null && moonPhase.getSleepBonus() > 1.0) {
            MessageUtils.sendMessage((CommandSender)player, "");
            MessageUtils.sendMessage((CommandSender)player, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
            MessageUtils.sendMessage((CommandSender)player, "&f\ud83c\udf19 &f&lLUNAR BLESSING RECEIVED &f\ud83c\udf19");
            MessageUtils.sendMessage((CommandSender)player, "&7\u2728 &fMoon Phase: " + moonPhase.getSymbol() + " &e" + moonPhase.getName());
            MessageUtils.sendMessage((CommandSender)player, "&7\ud83c\udf1f &fSleep Bonus: &a+" + (int)((moonPhase.getSleepBonus() - 1.0) * 100.0) + "% &feffectiveness");
            MessageUtils.sendMessage((CommandSender)player, "&7\ud83d\udcab &b" + moonPhase.getDescription());
            MessageUtils.sendMessage((CommandSender)player, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
            MessageUtils.sendMessage((CommandSender)player, "");
            Location loc = player.getLocation().add(0.0, 1.5, 0.0);
            player.getWorld().spawnParticle(Particle.TOTEM, loc, 5, 0.5, 0.5, 0.5, 0.1);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 0.3f, 1.8f);
        }
    }

    public MoonPhase getCurrentMoonPhase(World world) {
        return this.worldMoonPhases.get(world.getName());
    }

    public String getMoonPhaseInfo(World world) {
        MoonPhase moonPhase = this.getCurrentMoonPhase(world);
        if (moonPhase != null) {
            return moonPhase.getSymbol() + " " + moonPhase.getName() + " (+" + (int)((moonPhase.getSleepBonus() - 1.0) * 100.0) + "%)";
        }
        return "\ud83c\udf19 Unknown Phase";
    }

    public void cleanup() {
        this.worldMoonPhases.clear();
        this.lastPhaseCheck.clear();
    }

    public static enum MoonPhase {
        NEW_MOON("New Moon", "\ud83c\udf11", 0.8, "Shadow dreams and deep rest"),
        WAXING_CRESCENT("Waxing Crescent", "\ud83c\udf12", 1.0, "Growing energy and hope"),
        FIRST_QUARTER("First Quarter", "\ud83c\udf13", 1.2, "Balance and harmony"),
        WAXING_GIBBOUS("Waxing Gibbous", "\ud83c\udf14", 1.4, "Increasing power and clarity"),
        FULL_MOON("Full Moon", "\ud83c\udf15", 2.0, "Maximum lunar energy and magic"),
        WANING_GIBBOUS("Waning Gibbous", "\ud83c\udf16", 1.4, "Wisdom and reflection"),
        LAST_QUARTER("Last Quarter", "\ud83c\udf17", 1.2, "Release and letting go"),
        WANING_CRESCENT("Waning Crescent", "\ud83c\udf18", 1.0, "Preparation and renewal");

        private final String name;
        private final String symbol;
        private final double sleepBonus;
        private final String description;

        private MoonPhase(String name, String symbol, double sleepBonus, String description) {
            this.name = name;
            this.symbol = symbol;
            this.sleepBonus = sleepBonus;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public double getSleepBonus() {
            return this.sleepBonus;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

