/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker {
    private final EasySleep plugin;
    private final int resourceId = 127995;
    private String latestVersion;
    private boolean updateAvailable = false;

    public UpdateChecker(EasySleep plugin) {
        this.plugin = plugin;
    }

    public void checkForUpdates() {
        new BukkitRunnable(){

            public void run() {
                try {
                    UpdateChecker.this.getVersion(version -> {
                        UpdateChecker.this.latestVersion = version;
                        String currentVersion = UpdateChecker.this.plugin.getDescription().getVersion();
                        if (!currentVersion.equals(version)) {
                            UpdateChecker.this.updateAvailable = true;
                            UpdateChecker.this.plugin.getLogger().info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                            UpdateChecker.this.plugin.getLogger().info("\u2551        \ud83d\udd04 UPDATE AVAILABLE! \ud83d\udd04            \u2551");
                            UpdateChecker.this.plugin.getLogger().info("\u2551                                           \u2551");
                            UpdateChecker.this.plugin.getLogger().info("\u2551 Current Version: " + String.format("%-20s", currentVersion) + "\u2551");
                            UpdateChecker.this.plugin.getLogger().info("\u2551 Latest Version:  " + String.format("%-20s", version) + "\u2551");
                            UpdateChecker.this.plugin.getLogger().info("\u2551                                           \u2551");
                            UpdateChecker.this.plugin.getLogger().info("\u2551 Download: spigotmc.org/resources/127995   \u2551");
                            UpdateChecker.this.plugin.getLogger().info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                            Bukkit.getScheduler().runTask((Plugin)UpdateChecker.this.plugin, () -> {
                                for (Player player : Bukkit.getOnlinePlayers()) {
                                    if (!player.hasPermission("easysleep.admin")) continue;
                                    player.sendMessage("\u00a76\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                                    player.sendMessage("\u00a76\u2551 \u00a7b\ud83d\udd04 \u00a7f\u00a7lEASYSLEEP UPDATE AVAILABLE \u00a7b\ud83d\udd04 \u00a76\u2551");
                                    player.sendMessage("\u00a76\u2551 \u00a7fCurrent: \u00a7e" + currentVersion + " \u00a77\u2192 \u00a7fLatest: \u00a7a" + version + " \u00a76\u2551");
                                    player.sendMessage("\u00a76\u2551 \u00a77Download: \u00a7espigotmc.org/resources/127995 \u00a76\u2551");
                                    player.sendMessage("\u00a76\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                                }
                            });
                        } else {
                            UpdateChecker.this.plugin.getLogger().info("\u2713 EasySleep is up to date! (v" + currentVersion + ")");
                        }
                    });
                }
                catch (Exception e) {
                    UpdateChecker.this.plugin.getLogger().warning("Could not check for updates: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void getVersion(Consumer<String> consumer) {
        try {
            InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=127995").openStream();
            Scanner scanner = new Scanner(inputStream);
            if (scanner.hasNext()) {
                consumer.accept(scanner.next());
            }
            scanner.close();
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Cannot look for updates: " + e.getMessage());
        }
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void startPeriodicCheck() {
        new BukkitRunnable(){

            public void run() {
                UpdateChecker.this.checkForUpdates();
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 432000L);
    }
}

