/*
 * Decompiled with CFR 0.152.
 */
package fractum.api.events;

import fractum.api.events.EntityWalkThroughEvent;
import fractum.wgen.FractumBiomes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralFanBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;

@EventBusSubscriber(modid="fractum")
public class EntityWalkThroughHandler {
    @SubscribeEvent
    public static void onEntityWalk(LivingBreatheEvent event) {
        boolean brambleZero;
        LivingEntity entity = event.getEntity();
        BlockPos pos = entity.blockPosition();
        Level level = entity.level();
        BlockState block = entity.level().getBlockState(pos);
        if (block.equals((Object)Blocks.AIR.defaultBlockState())) {
            return;
        }
        boolean bloodBlocks = block == Blocks.WATER.defaultBlockState() || block == Blocks.FIRE_CORAL_FAN.defaultBlockState().setValue((Property)CoralFanBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        boolean bloodWater = level.getBiome(pos).is(FractumBiomes.BLOOD_HEATHLAND) && bloodBlocks;
        boolean brambleBiomes = level.getBiome(pos).is(FractumBiomes.BRAMBLE) || level.getBiome(pos).is(Biomes.TAIGA) || level.getBiome(pos).is(Biomes.OLD_GROWTH_PINE_TAIGA) || level.getBiome(pos).is(Biomes.OLD_GROWTH_SPRUCE_TAIGA);
        boolean bl = brambleZero = RandomSource.create().nextInt(42) == 0 && brambleBiomes && !entity.getDeltaMovement().equals((Object)Vec3.ZERO) && block == Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(0));
        if (!bloodWater && !brambleZero) {
            return;
        }
        NeoForge.EVENT_BUS.post((Event)new EntityWalkThroughEvent(entity, level, block));
    }
}

