/*
 * Decompiled with CFR 0.152.
 */
package fractum.api.events;

import fractum.api.events.VampireDamageEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="fractum")
public class VampireDamageHandler {
    @SubscribeEvent
    public static void onVampireDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof PiglinBrute)) {
            return;
        }
        PiglinBrute vampire = (PiglinBrute)livingEntity;
        if (!vampire.getTags().contains("vampire")) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity entity2 = event.getSource().getDirectEntity();
        if (!(entity2 instanceof SpectralArrow)) {
            return;
        }
        SpectralArrow arrow = (SpectralArrow)entity2;
        vampire.addTag("burned");
        DamageSource fireDamage = player.damageSources().onFire();
        event.setNewDamage(64.0f);
        NeoForge.EVENT_BUS.post((Event)new VampireDamageEvent(vampire, player, fireDamage));
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.GENERIC_BURN, SoundSource.HOSTILE, 64.0f, 0.81f);
    }
}

