/*
 * Decompiled with CFR 0.152.
 */
package fractum.api.events;

import fractum.api.events.VampireUpdateEvent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="fractum")
public class VampireUpdateHandler {
    @SubscribeEvent
    public static void onBatDamage(LivingDamageEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Bat)) {
            return;
        }
        Bat bat = (Bat)livingEntity;
        Level level = bat.level();
        BlockPos pos = bat.blockPosition();
        if (!bat.getTags().contains("vampire")) {
            return;
        }
        BlockPos belowPos = pos.below(3);
        if (level.getBlockState(belowPos).isAir() || level.getBlockState(belowPos).getBlock() == Blocks.LAVA) {
            return;
        }
        if (!(event.getSource().getEntity() instanceof Player)) {
            return;
        }
        NeoForge.EVENT_BUS.post((Event)new VampireUpdateEvent(bat, pos));
        VampireUpdateHandler.BatTransition(bat);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBatTick(LivingBreatheEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Bat)) {
            return;
        }
        Bat bat = (Bat)livingEntity;
        Level level = bat.level();
        BlockPos pos = bat.blockPosition();
        if (!bat.getTags().contains("vampire")) {
            return;
        }
        BlockPos belowPos = pos.below(3);
        if (level.getBlockState(belowPos).isAir() || level.getBlockState(belowPos).getBlock() == Blocks.LAVA) {
            return;
        }
        boolean hasFlownEnough = bat.flyDist >= 64.0f;
        List nearbyPlayers = level.getEntitiesOfClass(Player.class, bat.getBoundingBox().inflate(11.0));
        if (hasFlownEnough && !nearbyPlayers.isEmpty()) {
            NeoForge.EVENT_BUS.post((Event)new VampireUpdateEvent(bat, pos));
            VampireUpdateHandler.BatTransition(bat);
        }
    }

    private static void BatTransition(Bat entity) {
        BlockPos belowPos = entity.blockPosition().below(3);
        BlockState blockState = entity.level().getBlockState(belowPos);
        if (blockState.isValidSpawn((BlockGetter)entity.level(), belowPos, EntityType.PIGLIN_BRUTE) && !blockState.isAir() && !blockState.is(Blocks.WATER) && !blockState.is(Blocks.LAVA)) {
            PiglinBrute piglinBrute = (PiglinBrute)EntityType.PIGLIN_BRUTE.create(entity.level(), EntitySpawnReason.CONVERSION);
            if (piglinBrute != null) {
                piglinBrute.addTag("vampire");
                piglinBrute.setPos(entity.getX(), entity.getY(), entity.getZ());
                entity.level().addFreshEntity((Entity)piglinBrute);
            }
            if (entity.level() instanceof ServerLevel) {
                ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, entity.getX(), entity.getY() + 0.3, entity.getZ(), 90, 0.42, 0.52, 0.42, 0.032);
                entity.level().playSound(null, entity.blockPosition(), SoundEvents.BAT_TAKEOFF, SoundSource.HOSTILE, 10.0f, 0.52f);
            }
            entity.setSilent(true);
            entity.remove(Entity.RemovalReason.KILLED);
        }
    }
}

