/*
 * Decompiled with CFR 0.152.
 */
package fractum.api.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fractum.wgen.FractumBiomes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AzaleaBirchModifier
extends LootModifier {
    public static final MapCodec<AzaleaBirchModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("remove_item1").forGetter(m -> m.removeItem1), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("add_item1").forGetter(m -> m.addItem1), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("remove_item2").forGetter(m -> m.removeItem2), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("add_item2").forGetter(m -> m.addItem2), (App)Codec.FLOAT.fieldOf("add_chance").forGetter(m -> Float.valueOf(m.addChance)))).apply((Applicative)inst, AzaleaBirchModifier::new));
    private final Item removeItem1;
    private final Item addItem1;
    private final Item removeItem2;
    private final Item addItem2;
    private final float addChance;

    protected AzaleaBirchModifier(LootItemCondition[] conditions, Item removeItem1, Item addItem1, Item removeItem2, Item addItem2, Float addChance) {
        super(conditions);
        this.removeItem1 = removeItem1;
        this.addItem1 = addItem1;
        this.removeItem2 = removeItem2;
        this.addItem2 = addItem2;
        this.addChance = addChance.floatValue();
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        boolean plusLight;
        ServerLevel level = context.getLevel();
        BlockPos pos = BlockPos.containing((Position)((Position)context.getParameter(LootContextParams.ORIGIN)));
        Holder biome = level.getBiome(pos);
        ItemStack oldStack1 = new ItemStack((ItemLike)this.removeItem1, this.removeItem1.getDefaultInstance().getCount());
        ItemStack newStack1 = new ItemStack((ItemLike)this.addItem1, this.removeItem1.getDefaultInstance().getCount());
        if (biome.is(FractumBiomes.BIRCH_LANDSCAPE)) {
            generatedLoot.forEach(stack -> {
                if (stack.is(this.removeItem1)) {
                    generatedLoot.add((Object)newStack1);
                }
            });
            generatedLoot.removeIf(stack -> stack.is(this.removeItem1));
        } else {
            generatedLoot.forEach(stack -> {
                if (stack.is(this.addItem1)) {
                    generatedLoot.add((Object)oldStack1);
                }
            });
        }
        ItemStack oldStack2 = new ItemStack((ItemLike)this.removeItem1, this.removeItem1.getDefaultInstance().getCount());
        ItemStack newStack2 = new ItemStack((ItemLike)this.addItem1, this.removeItem1.getDefaultInstance().getCount());
        BlockState lightZero = (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(0));
        boolean bl = plusLight = level.getBlockState(pos.above()).equals((Object)lightZero) || level.getBlockState(pos.below()).equals((Object)lightZero) || level.getBlockState(pos.east()).equals((Object)lightZero) || level.getBlockState(pos.west()).equals((Object)lightZero) || level.getBlockState(pos.north()).equals((Object)lightZero) || level.getBlockState(pos.south()).equals((Object)lightZero);
        if (plusLight) {
            generatedLoot.forEach(stack -> {
                if (context.getRandom().nextFloat() <= this.addChance && stack.is(this.removeItem2)) {
                    generatedLoot.add((Object)newStack2);
                }
            });
            generatedLoot.removeIf(stack -> stack.is(this.removeItem2));
        } else {
            generatedLoot.forEach(stack -> {
                if (stack.is(this.addItem2)) {
                    generatedLoot.add((Object)oldStack2);
                }
            });
        }
        return generatedLoot;
    }
}

