/*
 * Decompiled with CFR 0.152.
 */
package fractum.api.spawn;

import fractum.wgen.FractumBiomes;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;

public class Placements {
    public static boolean checkDrownedSpawnRules(EntityType<Drowned> pDrowned, ServerLevelAccessor pServerLevel, EntitySpawnReason pMobSpawnType, BlockPos pPos, RandomSource pRandom) {
        if (pServerLevel.getBiome(pPos).is(FractumBiomes.MARSHLAND)) {
            return Zombie.checkMonsterSpawnRules(pDrowned, (ServerLevelAccessor)pServerLevel, (EntitySpawnReason)pMobSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
        }
        return Drowned.checkDrownedSpawnRules(pDrowned, (ServerLevelAccessor)pServerLevel, (EntitySpawnReason)pMobSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkStraySpawnRules(EntityType<Stray> pStray, ServerLevelAccessor pServerLevel, EntitySpawnReason pMobSpawnType, BlockPos pPos, RandomSource pRandom) {
        if (pServerLevel.getBiome(pPos).is(FractumBiomes.LAST_CIRCLE)) {
            return Skeleton.checkMonsterSpawnRules(pStray, (ServerLevelAccessor)pServerLevel, (EntitySpawnReason)pMobSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
        }
        return Stray.checkStraySpawnRules(pStray, (ServerLevelAccessor)pServerLevel, (EntitySpawnReason)pMobSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkFrogSpawnRules(EntityType<Frog> pFrog, ServerLevelAccessor pServerLevel, EntitySpawnReason pMobSpawnType, BlockPos pPos, RandomSource pRandom) {
        if (pServerLevel.getBiome(pPos).is(FractumBiomes.HOT_SPRINGS)) {
            return pServerLevel.getBlockState(pPos.below()).is(BlockTags.FROGS_SPAWNABLE_ON) && pServerLevel.getBrightness(LightLayer.BLOCK, pPos) > 11;
        }
        return Frog.checkFrogSpawnRules(pFrog, (LevelAccessor)pServerLevel, (EntitySpawnReason)pMobSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkVexSpawnRules(EntityType<Vex> pVex, ServerLevelAccessor pServerLevel, EntitySpawnReason pMobSpawnType, BlockPos pPos, RandomSource pRandom) {
        if (pServerLevel.getLevel().dimension() == Level.OVERWORLD) {
            return pServerLevel.getDifficulty() != Difficulty.PEACEFUL && pPos.getY() >= 64 && pServerLevel.isEmptyBlock(pPos);
        }
        return Vex.checkMonsterSpawnRules(pVex, (ServerLevelAccessor)pServerLevel, (EntitySpawnReason)pMobSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkPhantomSpawnRules(EntityType<Phantom> pPhantom, ServerLevelAccessor pServerLevel, EntitySpawnReason pMobSpawnType, BlockPos pPos, RandomSource pRandom) {
        if (pServerLevel.getBiome(pPos).is(FractumBiomes.SKY_RUINS)) {
            if (pServerLevel.getLevel().getDayTime() > 12000L && pServerLevel.getLevel().getDayTime() < 24000L) {
                return pServerLevel.getDifficulty() != Difficulty.PEACEFUL && pPos.getY() >= 140 && pServerLevel.getBrightness(LightLayer.BLOCK, pPos) < 12;
            }
            if (pServerLevel.getLevel().getDayTime() > 0L && pServerLevel.getLevel().getDayTime() < 12000L) {
                return pServerLevel.getDifficulty() != Difficulty.PEACEFUL && pPos.getY() >= 140 && pServerLevel.getBrightness(LightLayer.SKY, pPos) >= 12;
            }
            return pServerLevel.getDifficulty() != Difficulty.PEACEFUL;
        }
        return pServerLevel.getDifficulty() != Difficulty.PEACEFUL;
    }
}

