/*
 * Decompiled with CFR 0.152.
 */
package fractum.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fractum.api.events.VariantJoinEvent;
import fractum.api.events.VariantJoinStructureEvent;
import fractum.wgen.FractumBiomes;
import fractum.wgen.FractumStructures;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class NetherVariantsListener {
    @SubscribeEvent
    public static void onBlazeHotSprings(VariantJoinEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof Blaze && world.getBiome(entity.getOnPos()).is(FractumBiomes.HOT_SPRINGS)) {
            Blaze blaze = (Blaze)event.getEntity();
            blaze.addTag("spa");
            Objects.requireNonNull(blaze.getAttribute(Attributes.FOLLOW_RANGE)).setBaseValue(8.0);
        }
    }

    @SubscribeEvent
    public static void onVexLastCircle(VariantJoinEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof Vex && (world.getBiome(entity.getOnPos()).is(FractumBiomes.LAST_CIRCLE) || world.getBiome(entity.getOnPos()).is(Biomes.SOUL_SAND_VALLEY))) {
            Vex vex = (Vex)event.getEntity();
            vex.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            vex.addTag("angel");
        }
    }

    @SubscribeEvent
    public static void onMushroomCowBlood(VariantJoinEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof MushroomCow && world.getBiome(entity.getOnPos()).is(FractumBiomes.BLOOD_HEATHLAND)) {
            MushroomCow mushroomCow = (MushroomCow)event.getEntity();
            mushroomCow.setVariant(MushroomCow.Variant.BROWN);
        }
    }

    @SubscribeEvent
    public static void onVampireBlood(VariantJoinEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof Bat && world.getBiome(entity.getOnPos()).is(FractumBiomes.BLOOD_HEATHLAND)) {
            Bat bat = (Bat)event.getEntity();
            Objects.requireNonNull(bat.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(25.0);
            bat.setHealth(25.0f);
            bat.addTag("vampire");
        } else if (entity instanceof PiglinBrute && (entity.getTags().contains("vampire") || world.getBiome(entity.getOnPos()).is(FractumBiomes.BLOOD_HEATHLAND))) {
            PiglinBrute brute = (PiglinBrute)event.getEntity();
            ItemStack customHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            String base64Texture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjgzYjQ1NWFlZDRkNWE3MzI2MDQzYmU0MzQ0YWE3Y2U2MzgxMTI3OGU2NTQxZGI4ZmE3MmZiYjk1MWIyNDhiMiJ9fX0=";
            HashMultimap mapping = HashMultimap.create();
            mapping.put((Object)"textures", (Object)new Property("textures", base64Texture));
            PropertyMap propertyMap = new PropertyMap((Multimap)mapping);
            GameProfile profile = new GameProfile(UUID.randomUUID(), "QuiteTheFrenzy", propertyMap);
            customHead.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Beast Soul Head"));
            customHead.set(DataComponents.PROFILE, (Object)ResolvableProfile.createResolved((GameProfile)profile));
            brute.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            brute.setItemSlot(EquipmentSlot.HEAD, customHead);
            Objects.requireNonNull(brute.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue(0.6);
            Objects.requireNonNull(brute.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(4.0);
            if (!entity.getTags().contains("vampire")) {
                // empty if block
            }
            brute.addTag("vampire");
        }
    }

    @SubscribeEvent
    public static void onVampireCastle(VariantJoinStructureEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        ServerLevel world = event.getServerLevel();
        StructureStart structureStart = world.structureManager().getStructureWithPieceAt(entity.getOnPos(), FractumStructures.getStructure(FractumStructures.BLOOD_CASTLE, world.registryAccess()));
        if (entity instanceof PiglinBrute && world.structureManager().structureHasPieceAt(entity.getOnPos(), structureStart)) {
            PiglinBrute brute = (PiglinBrute)event.getEntity();
            ItemStack customHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
            String base64Texture = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjgzYjQ1NWFlZDRkNWE3MzI2MDQzYmU0MzQ0YWE3Y2U2MzgxMTI3OGU2NTQxZGI4ZmE3MmZiYjk1MWIyNDhiMiJ9fX0=";
            HashMultimap mapping = HashMultimap.create();
            mapping.put((Object)"textures", (Object)new Property("textures", base64Texture));
            PropertyMap propertyMap = new PropertyMap((Multimap)mapping);
            GameProfile profile = new GameProfile(UUID.randomUUID(), "QuiteTheFrenzy", propertyMap);
            customHead.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Beast Soul Head"));
            customHead.set(DataComponents.PROFILE, (Object)ResolvableProfile.createResolved((GameProfile)profile));
            brute.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            brute.setItemSlot(EquipmentSlot.HEAD, customHead);
            Objects.requireNonNull(brute.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue(0.6);
            Objects.requireNonNull(brute.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(4.0);
            brute.addTag("vampire");
        }
    }

    @SubscribeEvent
    public static void onSkeletonCastle(VariantJoinStructureEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        ServerLevel world = event.getServerLevel();
        StructureStart structureStart = world.structureManager().getStructureWithPieceAt(entity.getOnPos(), FractumStructures.getStructure(FractumStructures.BLOOD_CASTLE, world.registryAccess()));
        if (entity instanceof Skeleton && world.structureManager().structureHasPieceAt(entity.getOnPos(), structureStart)) {
            Skeleton skeleton = (Skeleton)event.getEntity();
            RandomSource random = RandomSource.create();
            skeleton.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW, 1));
            skeleton.setItemSlot(EquipmentSlot.OFFHAND, NetherVariantsListener.createCustomArrow());
            skeleton.setDropChance(EquipmentSlot.OFFHAND, 0.07f);
            if (random.nextInt(100) <= 14) {
                skeleton.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL, 1));
                skeleton.setDropChance(EquipmentSlot.HEAD, 0.03f);
            }
            skeleton.addTag("dark");
        }
    }

    public static ItemStack createCustomArrow() {
        RandomSource random = RandomSource.create();
        ItemStack arrowStack = new ItemStack((ItemLike)Items.TIPPED_ARROW, random.nextInt(2));
        PotionContents whiterEffect = new PotionContents(Optional.empty(), Optional.of(0x1D1D21), List.of(new MobEffectInstance(MobEffects.WITHER, 600, 1)), Optional.empty());
        arrowStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"wither arrow"));
        arrowStack.set(DataComponents.POTION_CONTENTS, (Object)whiterEffect);
        return arrowStack;
    }
}

