/*
 * Decompiled with CFR 0.152.
 */
package fractum.event;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fractum.api.events.VariantJoinEvent;
import fractum.wgen.FractumBiomes;
import java.util.Objects;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class OverworldVariantsListener {
    @SubscribeEvent
    public static void onDrownedMarshland(VariantJoinEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof Drowned && world.getBiome(entity.getOnPos()).is(FractumBiomes.MARSHLAND)) {
            Drowned drowned = (Drowned)event.getEntity();
            Objects.requireNonNull(drowned.getAttribute(Attributes.MOVEMENT_SPEED)).setBaseValue(0.3);
        }
    }

    @SubscribeEvent
    public static void onSkeletonFirePlains(VariantJoinEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof Skeleton && world.getBiome(entity.getOnPos()).is(FractumBiomes.FIRE_PLAINS)) {
            Skeleton skeleton = (Skeleton)event.getEntity();
            skeleton.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
        }
    }

    @SubscribeEvent
    public static void onParrotSkyRuins(VariantJoinEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        int random = new Random().nextInt(100);
        if (entity instanceof Parrot && world.getBiome(entity.getOnPos()).is(FractumBiomes.SKY_RUINS)) {
            Parrot parrot = (Parrot)event.getEntity();
            if (random <= 70) {
                parrot.setVariant(Parrot.Variant.byId((int)4));
            } else if (random <= 95) {
                parrot.setVariant(Parrot.Variant.byId((int)2));
            } else {
                parrot.setVariant(Parrot.Variant.byId((int)3));
            }
        }
    }

    @SubscribeEvent
    public static void onPhantomSkyRuins(VariantJoinEvent event) throws CommandSyntaxException {
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof Phantom && world.getBiome(entity.getOnPos()).is(FractumBiomes.SKY_RUINS)) {
            Phantom phantom = (Phantom)event.getEntity();
            phantom.addTag("sky");
        }
    }
}

