/*
 * Decompiled with CFR 0.152.
 */
package fractum.event;

import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class PlayerEventsListener {
    @SubscribeEvent
    public static void onVexInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof Vex && entity.getTags().contains("ignus") && !entity.getTags().contains("jeck") && player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == Items.LANTERN) {
            entity.getTags().add("jeck");
            player.getItemInHand(InteractionHand.MAIN_HAND).shrink(1);
            ItemStack soulLantern = new ItemStack((ItemLike)Items.SOUL_LANTERN);
            soulLantern.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            if (player.getInventory().getFreeSlot() != -1) {
                player.getInventory().add(soulLantern);
            } else {
                player.drop(soulLantern, false);
            }
            event.getLevel().playSound((Entity)player, player.getOnPos(), SoundEvents.GHAST_SHOOT, SoundSource.HOSTILE, 0.09f, 2.0f);
            event.getLevel().playSound((Entity)player, player.getOnPos(), (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.AMBIENT, 10.0f, 1.8f);
            Level level = entity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                entity.kill(serverLevel);
            }
        }
    }
}

