/*
 * Decompiled with CFR 0.152.
 */
package fractum.event;

import fractum.wgen.FractumBiomes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;

@EventBusSubscriber
public class TreeGrowth {
    public static final ResourceKey<ConfiguredFeature<?, ?>> birchTreeKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"birch/birch_tall"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> bloodWillowKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"blood/willow"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> brambleVinesKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"bramble/vines_placer"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> brambleBushesKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"bramble/bushes_placer"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> crystalFancyKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"crystal/fancy"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> crystalSpruceKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"crystal/spruce"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> crystalMegaKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"crystal/mega_spruce"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> fireTreeKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"fire/tree"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> savageTreeKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"savage/tree_rs"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> marshWillowKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fractum", (String)"marshland/willow"));

    @SubscribeEvent
    public static void onBirchGrowth(BlockGrowFeatureEvent event) {
        LevelAccessor world = event.getLevel();
        Holder feature = event.getFeature();
        if (feature != null && world.getBiome(event.getPos()).is(FractumBiomes.BIRCH_LANDSCAPE) && (feature.is(TreeFeatures.BIRCH) || feature.is(TreeFeatures.BIRCH_BEES_005))) {
            event.setFeature(birchTreeKey);
        }
    }

    @SubscribeEvent
    public static void onBloodGrowth(BlockGrowFeatureEvent event) {
        LevelAccessor world = event.getLevel();
        Holder feature = event.getFeature();
        if (feature != null && world.getBiome(event.getPos()).is(FractumBiomes.BLOOD_HEATHLAND) && feature.is(TreeFeatures.ACACIA)) {
            event.setFeature(bloodWillowKey);
        }
    }

    @SubscribeEvent
    public static void onCrystalGrowth(BlockGrowFeatureEvent event) {
        LevelAccessor world = event.getLevel();
        Holder feature = event.getFeature();
        if (feature != null && world.getBiome(event.getPos()).is(FractumBiomes.CRYSTAL_VALLEY)) {
            if (feature.is(TreeFeatures.SPRUCE)) {
                event.setFeature(crystalSpruceKey);
            } else if (feature.is(TreeFeatures.MEGA_SPRUCE) || feature.is(TreeFeatures.MEGA_PINE)) {
                event.setFeature(crystalMegaKey);
            }
        }
    }

    @SubscribeEvent
    public static void onFireGrowth(BlockGrowFeatureEvent event) {
        LevelAccessor world = event.getLevel();
        Holder feature = event.getFeature();
        BlockPos pos = event.getPos();
        if (feature == null && world.getBiome(event.getPos()).is(FractumBiomes.FIRE_PLAINS) && world.getBlockState(pos).is(Blocks.DARK_OAK_SAPLING)) {
            event.setFeature(fireTreeKey);
        }
    }

    @SubscribeEvent
    public static void onSavageGrowth(BlockGrowFeatureEvent event) {
        LevelAccessor world = event.getLevel();
        Holder feature = event.getFeature();
        if (feature != null && world.getBiome(event.getPos()).is(FractumBiomes.SAVAGE_SWAMP) && feature.is(TreeFeatures.MEGA_JUNGLE_TREE)) {
            event.setFeature(savageTreeKey);
        }
    }

    @SubscribeEvent
    public static void onMarshGrowth(BlockGrowFeatureEvent event) {
        LevelAccessor world = event.getLevel();
        Holder feature = event.getFeature();
        if (feature != null && world.getBiome(event.getPos()).is(FractumBiomes.MARSHLAND) && (feature.is(TreeFeatures.MANGROVE) || feature.is(TreeFeatures.TALL_MANGROVE))) {
            event.setFeature(marshWillowKey);
        }
    }
}

