/*
 * Decompiled with CFR 0.152.
 */
package fractum.event;

import fractum.wgen.FractumBiomes;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;

@EventBusSubscriber
public class VexEventsListener {
    @SubscribeEvent
    public static void onVexJoinOverworld(EntityJoinLevelEvent event) {
        DustParticleOptions blackDust = new DustParticleOptions(0, 1.0f);
        DustParticleOptions yellowDust = new DustParticleOptions(0xFFFF99, 1.0f);
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof Vex && world.dimension() == Level.OVERWORLD && ((Vex)entity).getSpawnType() != EntitySpawnReason.MOB_SUMMONED && ((Vex)entity).getSpawnType() != EntitySpawnReason.SPAWNER && ((Vex)entity).getSpawnType() != EntitySpawnReason.STRUCTURE) {
            ((Vex)entity).addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, -1, 0, false, false));
            ((Vex)entity).setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            if (world.getBiome(entity.getOnPos()).is(FractumBiomes.MARSHLAND) && entity.getTags().isEmpty()) {
                entity.addTag("fatuus");
                entity.setInvulnerable(true);
                Objects.requireNonNull(((Vex)entity).getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(0.0);
            }
            if (0L <= world.dayTime() && world.dayTime() < 13000L && entity.getTags().isEmpty()) {
                entity.addTag("zanzara");
                Objects.requireNonNull(((Vex)entity).getAttribute(Attributes.MAX_HEALTH)).setBaseValue(1.0);
                Objects.requireNonNull(((Vex)entity).getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(1.0);
            }
            if (13000L <= world.dayTime() && world.dayTime() < 24000L && entity.getTags().isEmpty()) {
                entity.setSilent(true);
                entity.addTag("lucciola");
                Objects.requireNonNull(((Vex)entity).getAttribute(Attributes.MAX_HEALTH)).setBaseValue(2.0);
                Objects.requireNonNull(((Vex)entity).getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(0.0);
            }
        }
    }

    @SubscribeEvent
    public static void onLightVexLeave(@Nullable EntityLeaveLevelEvent event) {
        assert (event != null);
        Entity entity = event.getEntity();
        Level world = event.getLevel();
        if (entity instanceof Vex && (entity.getTags().contains("ignus") || entity.getTags().contains("lucciola")) && world.getBlockState(entity.getOnPos()).getBlock() == Blocks.LIGHT) {
            world.setBlock(entity.getOnPos(), Blocks.AIR.defaultBlockState(), 3);
        }
    }
}

