/*
 * Decompiled with CFR 0.152.
 */
package fractum.init;

import fractum.wgen.FractumBiomes;
import fractum.wgen.NetherCanon;
import fractum.wgen.NetherCommon;
import fractum.wgen.NetherRare;
import fractum.wgen.OverworldPrimary;
import fractum.wgen.OverworldSecondary;
import fractum.wgen.SurfaceRuleNether;
import fractum.wgen.SurfaceRuleOverworld;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class ModBiomes {
    public static void setupTerraBlender() {
        Regions.register((Region)new OverworldPrimary(new ResourceLocation("fractum", "overworld_6"), 6));
        Regions.register((Region)new OverworldSecondary(new ResourceLocation("fractum", "overworld_4"), 4));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"fractum", (SurfaceRules.RuleSource)SurfaceRuleOverworld.makeRules());
        Regions.register((Region)new NetherCanon(new ResourceLocation("fractum", "nether_10"), 10));
        Regions.register((Region)new NetherCommon(new ResourceLocation("fractum", "nether_8"), 8));
        Regions.register((Region)new NetherRare(new ResourceLocation("fractum", "nether_2"), 2));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)"fractum", (SurfaceRules.RuleSource)SurfaceRuleNether.makeRules());
    }

    public static void setupVillagerTypes() {
        ModBiomes.registerVillagerType(FractumBiomes.MARSHLAND, (ResourceKey<VillagerType>)VillagerType.SWAMP);
        ModBiomes.registerVillagerType(FractumBiomes.SAVAGE_SWAMP, (ResourceKey<VillagerType>)VillagerType.JUNGLE);
        ModBiomes.registerVillagerType(FractumBiomes.SKY_RUINS, (ResourceKey<VillagerType>)VillagerType.PLAINS);
        ModBiomes.registerVillagerType(FractumBiomes.CRYSTAL_VALLEY, (ResourceKey<VillagerType>)VillagerType.SNOW);
        ModBiomes.registerVillagerType(FractumBiomes.LAVA_ROCKS, (ResourceKey<VillagerType>)VillagerType.DESERT);
        ModBiomes.registerVillagerType(FractumBiomes.BRAMBLE, (ResourceKey<VillagerType>)VillagerType.TAIGA);
        ModBiomes.registerVillagerType(FractumBiomes.MESA_LANDSCAPE, (ResourceKey<VillagerType>)VillagerType.DESERT);
        ModBiomes.registerVillagerType(FractumBiomes.BIRCH_LANDSCAPE, (ResourceKey<VillagerType>)VillagerType.PLAINS);
        ModBiomes.registerVillagerType(FractumBiomes.FIRE_PLAINS, (ResourceKey<VillagerType>)VillagerType.PLAINS);
        ModBiomes.registerVillagerType(FractumBiomes.CORAL_COVE, (ResourceKey<VillagerType>)VillagerType.JUNGLE);
    }

    private static void registerVillagerType(ResourceKey<Biome> key, ResourceKey<VillagerType> type) {
        VillagerType.BY_BIOME.put(key, type);
    }
}

