/*
 * Decompiled with CFR 0.152.
 */
package fractum.mixin;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Blaze.class})
public abstract class BlazeMixin
extends Monster {
    @Shadow
    abstract void setCharged(boolean var1);

    protected BlazeMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Blaze self() {
        return (Blaze)this;
    }

    @Overwrite
    protected SoundEvent getAmbientSound() {
        if (this.self().getTags().contains("spa")) {
            return SoundEvents.BLASTFURNACE_FIRE_CRACKLE;
        }
        return SoundEvents.BLAZE_AMBIENT;
    }

    @Overwrite
    protected SoundEvent getDeathSound() {
        if (this.self().getTags().contains("spa")) {
            return SoundEvents.FIRE_EXTINGUISH;
        }
        return SoundEvents.BLAZE_DEATH;
    }

    @Overwrite
    public boolean isSensitiveToWater() {
        return !this.self().getTags().contains("spa");
    }

    @Overwrite
    public void aiStep() {
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        if (this.self().getTags().contains("spa")) {
            if (this.level().isClientSide()) {
                if (this.random.nextInt(24) == 0 && !this.isSilent()) {
                    this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, SoundEvents.BLAZE_BURN, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
                }
                for (int $$0 = 0; $$0 < 2; ++$$0) {
                    if (new Random().nextInt(100) < 15) {
                        this.self().level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.self().getRandomX(1.5), this.self().getRandomY(), this.self().getRandomZ(1.0), 0.01, 0.01, 0.01);
                    }
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else if (this.level().isClientSide()) {
            if (this.random.nextInt(24) == 0 && !this.isSilent()) {
                this.level().playLocalSound(this.getX() + 0.5, this.getY() + 0.5, this.getZ() + 0.5, SoundEvents.BLAZE_BURN, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int $$0 = 0; $$0 < 2; ++$$0) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.aiStep();
    }
}

