/*
 * Decompiled with CFR 0.152.
 */
package fractum.mixin;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={PiglinBrute.class})
public abstract class PiglinBruteMixin
extends Monster {
    protected PiglinBruteMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Overwrite
    protected SoundEvent getAmbientSound() {
        if (this.getTags().contains("vampire")) {
            return SoundEvents.BAT_LOOP;
        }
        return SoundEvents.PIGLIN_BRUTE_AMBIENT;
    }

    @Overwrite
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        if (this.getTags().contains("vampire")) {
            return SoundEvents.PANDA_BITE;
        }
        return SoundEvents.PIGLIN_BRUTE_HURT;
    }

    @Overwrite
    protected SoundEvent getDeathSound() {
        if (this.getTags().contains("vampire")) {
            return SoundEvents.VEX_DEATH;
        }
        return SoundEvents.PIGLIN_BRUTE_DEATH;
    }

    @Overwrite
    protected void playAngrySound() {
        if (this.getTags().contains("vampire")) {
            this.playSound(SoundEvents.VEX_DEATH, 0.7f, this.getVoicePitch());
        } else {
            this.playSound(SoundEvents.PIGLIN_BRUTE_ANGRY, 1.0f, this.getVoicePitch());
        }
    }
}

