/*
 * Decompiled with CFR 0.152.
 */
package fractum.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Vex.class})
public abstract class VexMixin
extends Monster
implements TraceableEntity {
    BlockState lightBlock = (BlockState)Blocks.LIGHT.defaultBlockState().setValue((Property)LightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));

    @Shadow
    public abstract void setIsCharging(boolean var1);

    protected VexMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Vex self() {
        return (Vex)this;
    }

    @Overwrite
    protected SoundEvent getAmbientSound() {
        if (this.self().getTags().contains("fatuus")) {
            return (SoundEvent)SoundEvents.SOUL_ESCAPE.value();
        }
        if (this.self().getTags().contains("zanzara")) {
            return SoundEvents.BEE_LOOP;
        }
        if (this.self().getTags().contains("lucciola")) {
            return SoundEvents.FIREFLY_BUSH_IDLE;
        }
        return SoundEvents.VEX_AMBIENT;
    }

    @Overwrite
    protected SoundEvent getDeathSound() {
        if (this.self().getTags().contains("ignus")) {
            return SoundEvents.CANDLE_EXTINGUISH;
        }
        if (this.self().getTags().contains("fatuus")) {
            return (SoundEvent)SoundEvents.SOUL_ESCAPE.value();
        }
        if (this.self().getTags().contains("zanzara")) {
            return SoundEvents.BEE_DEATH;
        }
        return SoundEvents.VEX_DEATH;
    }

    @Overwrite
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        if (this.self().getTags().contains("zanzara")) {
            return SoundEvents.BEE_HURT;
        }
        return SoundEvents.VEX_HURT;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (this.self().getTags().contains("fatuus") && !this.self().getTags().contains("ignus") && VexMixin.isSoulBelow((Entity)this.self(), this.self().level()) && this.self().level().getBlockState(this.self().getOnPos()).getBlock() == Blocks.AIR) {
            this.self().addTag("ignus");
            this.self().setNoAi(true);
            this.self().setInvulnerable(true);
            this.self().level().setBlock(this.self().getOnPos(), this.lightBlock, 0);
        }
        if (this.self().getTags().contains("ignus")) {
            if (this.self().tickCount % 5 == 0 && this.self().tickCount < 1300) {
                this.self().level().addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, true, true, this.self().getX(), this.self().getY(), this.self().getZ(), 1.0E-5, 1.0E-4, 1.0E-5);
            }
            this.self().playSound(SoundEvents.CANDLE_AMBIENT, 1.0f, 0.01f);
            if (this.self().tickCount >= 470) {
                this.self().level().setBlock(this.self().getOnPos(), (BlockState)this.lightBlock.setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(6)), 3);
            }
            if (this.self().tickCount >= 1000) {
                this.self().level().setBlock(this.self().getOnPos(), (BlockState)this.lightBlock.setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(4)), 3);
            }
            if (this.self().tickCount >= 1300) {
                this.self().level().setBlock(this.self().getOnPos(), (BlockState)this.lightBlock.setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(2)), 3);
            }
            if (this.self().tickCount >= 1400) {
                this.self().level().setBlock(this.self().getOnPos(), Blocks.AIR.defaultBlockState(), 3);
                Level level = this.self().level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.self().kill(serverLevel);
                }
            }
        }
        if (this.self().getTags().contains("zanzara") && !this.self().getTags().contains("lucciola")) {
            DustParticleOptions blackDust = new DustParticleOptions(0, 1.0f);
            this.self().level().addParticle((ParticleOptions)blackDust, true, true, this.self().getX(), this.self().getY(), this.self().getZ(), 0.0, 0.0, 0.0);
        }
        if (this.self().getTags().contains("lucciola") && !this.self().getTags().contains("zanzara")) {
            DustParticleOptions yellowDust = new DustParticleOptions(0xFFFF99, 1.0f);
            this.self().level().addParticle((ParticleOptions)yellowDust, true, true, this.self().getX(), this.self().getY(), this.self().getZ(), 0.0, 0.0, 0.0);
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (this.self().level().getBlockState(this.self().getOnPos().offset(x, y, z)).getBlock() != Blocks.LIGHT || x == 0 && y == 0 && z == 0) continue;
                        this.self().level().setBlock(this.self().getOnPos().offset(x, y, z), Blocks.AIR.defaultBlockState(), 3);
                    }
                }
            }
            if (this.self().level().getBlockState(this.self().getOnPos()).getBlock() == Blocks.AIR || this.self().level().getBlockState(this.self().getOnPos()).getBlock() == Blocks.LIGHT) {
                this.self().level().setBlock(this.self().getOnPos(), (BlockState)this.lightBlock.setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(10)), 3);
            }
        }
    }

    private static boolean isSoulBelow(Entity entity, Level world) {
        BlockPos entityPos = entity.getOnPos();
        if (world.getBlockState(entityPos).getBlock() == Blocks.BLACK_CANDLE) {
            return true;
        }
        if (world.getBlockState(entityPos).getBlock() == Blocks.AIR && world.getBlockState(entityPos.below(1)).getBlock() == Blocks.AIR) {
            for (int i = 2; i <= 4; ++i) {
                BlockPos checkPos = entityPos.below(i);
                if (world.getBlockState(checkPos).getBlock() != Blocks.SOUL_SOIL && world.getBlockState(checkPos).getBlock() != Blocks.MUD && world.getBlockState(checkPos).getBlock() != Blocks.MUDDY_MANGROVE_ROOTS) continue;
                return true;
            }
        }
        return false;
    }

    @Mixin(value={Vex.VexChargeAttackGoal.class})
    public static abstract class VexChargeAttackGoalMixin
    extends Goal {
        @Final
        @Shadow(remap=false)
        private Vex this$0;

        public Vex self() {
            return this.this$0;
        }

        @Overwrite
        public void start() {
            LivingEntity livingentity = this.self().getTarget();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.getEyePosition();
                this.self().getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, 1.0);
            }
            this.self().setIsCharging(true);
            if (this.self().getTags().contains("zanzara")) {
                this.self().playSound(SoundEvents.BEE_LOOP_AGGRESSIVE, 0.5f, 2.0f);
            } else {
                this.self().playSound(SoundEvents.VEX_CHARGE, 1.0f, 1.0f);
            }
        }
    }
}

