/*
 * Decompiled with CFR 0.152.
 */
package fractum.mixin;

import fractum.wgen.FractumBiomes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={WaterFluid.class})
public abstract class WaterFluidMixin
extends FlowingFluid {
    @Overwrite
    public void animateTick(Level pLevel, BlockPos pPos, FluidState pState, RandomSource pRandom) {
        if (!pState.isSource() && !((Boolean)pState.getValue((Property)FALLING)).booleanValue()) {
            if (pRandom.nextInt(64) == 0) {
                pLevel.playLocalSound((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, pRandom.nextFloat() * 0.25f + 0.75f, pRandom.nextFloat() + 0.5f, false);
            }
        } else if (pRandom.nextInt(10) == 0) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.UNDERWATER, (double)pPos.getX() + pRandom.nextDouble(), (double)pPos.getY() + pRandom.nextDouble(), (double)pPos.getZ() + pRandom.nextDouble(), 0.0, 0.0, 0.0);
        } else if (pLevel.getBiome(pPos).is(FractumBiomes.LAVA_ROCKS) && pRandom.nextInt(256) == 0) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pPos.getX() + pRandom.nextDouble(), (double)pPos.getY() + pRandom.nextDouble(), (double)pPos.getZ() + pRandom.nextDouble(), 0.0, 0.01, 0.0);
        }
    }
}

