/*
 * Decompiled with CFR 0.152.
 */
package xiamomc.pluginbase.Bindables;

import java.util.ListIterator;
import xiamomc.pluginbase.Bindables.BindableList;
import xiamomc.pluginbase.Bindables.TriggerReason;

public class BindableListIterator<T>
implements ListIterator<T> {
    private final ListIterator<T> backendIterator;
    private final BindableList<T> backendBindable;
    private T current;

    public BindableListIterator(BindableList<T> bindable) {
        this.backendBindable = bindable;
        this.backendIterator = bindable.list.listIterator();
    }

    @Override
    public boolean hasNext() {
        return this.backendIterator.hasNext();
    }

    @Override
    public T next() {
        T val = this.backendIterator.next();
        this.current = val;
        return val;
    }

    @Override
    public boolean hasPrevious() {
        return this.backendIterator.hasPrevious();
    }

    @Override
    public T previous() {
        T val = this.backendIterator.previous();
        this.current = val;
        return val;
    }

    @Override
    public int nextIndex() {
        return this.backendIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.backendIterator.previousIndex();
    }

    @Override
    public void remove() {
        this.backendIterator.remove();
        this.backendBindable.triggerChange(this.current, TriggerReason.REMOVE);
    }

    @Override
    public void set(T t) {
        this.backendIterator.set(t);
        this.backendBindable.triggerChange(t, TriggerReason.ADD);
    }

    @Override
    public void add(T t) {
        this.backendIterator.add(t);
        this.backendBindable.triggerChange(t, TriggerReason.ADD);
    }
}

