/*
 * Decompiled with CFR 0.152.
 */
package xiamomc.pluginbase;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import xiamomc.pluginbase.ISchedulablePlugin;
import xiamomc.pluginbase.Managers.DependencyManager;
import xiamomc.pluginbase.ScheduleInfo;

public abstract class XiaMoJavaPlugin
implements ISchedulablePlugin {
    private static final Map<String, XiaMoJavaPlugin> instances = new ConcurrentHashMap<String, XiaMoJavaPlugin>();
    protected final DependencyManager dependencyManager;
    protected final Logger logger = this.getSLF4JLogger();
    public boolean doInternalDebugOutput = false;
    protected long currentTick = 0L;
    private final AtomicInteger exceptionCaught = new AtomicInteger(0);
    protected boolean cancelSchedules = false;
    protected boolean acceptSchedules = true;
    protected final List<ScheduleInfo> schedules = new ObjectArrayList();

    @Deprecated
    public static XiaMoJavaPlugin GetInstance(String nameSpace) {
        return XiaMoJavaPlugin.getInstance(nameSpace);
    }

    public static XiaMoJavaPlugin getInstance(String nameSpace) {
        return instances.get(nameSpace);
    }

    public abstract String namespace();

    protected abstract Logger getSLF4JLogger();

    public XiaMoJavaPlugin() {
        this.dependencyManager = DependencyManager.getManagerOrCreate(this);
        instances.put(this.namespace(), this);
    }

    protected void enable() {
    }

    public final void enablePlugin() {
        this.dependencyManager.unRegisterPluginInstance(this);
        this.dependencyManager.registerPluginInstance(this);
        this.dependencyManager.unCacheAll();
        this.processExceptionCount();
        this.dependencyManager.cacheAs(XiaMoJavaPlugin.class, this);
        this.cancelSchedules = false;
        this.acceptSchedules = true;
        this.enable();
        this.startMainLoop(this::tick);
    }

    @Override
    public abstract void startMainLoop(Runnable var1);

    @Override
    public abstract void runAsync(Runnable var1);

    protected void disable() {
    }

    public final void disablePlugin() {
        this.disable();
        this.cancelSchedules = true;
        this.acceptSchedules = false;
        this.dependencyManager.unCacheAll();
        this.dependencyManager.unRegisterPluginInstance(this);
    }

    @NotNull
    public abstract File getDataFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tick() {
        ObjectArrayList schedulesTemp;
        ++this.currentTick;
        if (this.cancelSchedules) {
            return;
        }
        List<ScheduleInfo> list = this.schedules;
        synchronized (list) {
            schedulesTemp = new ObjectArrayList(this.schedules.size());
            schedulesTemp.addAll(this.schedules);
        }
        ObjectArrayList toRemove = new ObjectArrayList();
        schedulesTemp.forEach(arg_0 -> this.lambda$tick$1((List)toRemove, arg_0));
        if (!toRemove.isEmpty()) {
            List<ScheduleInfo> list2 = this.schedules;
            synchronized (list2) {
                this.schedules.removeAll((Collection<?>)toRemove);
            }
        }
        schedulesTemp.clear();
    }

    protected void runFunction(ScheduleInfo c) {
        if (this.cancelSchedules) {
            return;
        }
        try {
            c.Function.run();
        }
        catch (Throwable t) {
            this.onTaskExceptionCaught(t, c);
        }
    }

    protected int getExceptionLimit() {
        return 5;
    }

    @Override
    public boolean acceptSchedules() {
        return this.acceptSchedules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTaskExceptionCaught(Throwable exception, ScheduleInfo scheduleInfo) {
        int exceptions;
        if (exception == null) {
            return;
        }
        AtomicInteger atomicInteger = this.exceptionCaught;
        synchronized (atomicInteger) {
            exceptions = this.exceptionCaught.incrementAndGet();
        }
        this.logger.warn("\u6267\u884c" + String.valueOf(scheduleInfo) + "\u65f6\u6355\u83b7\u5230\u672a\u5904\u7406\u7684\u5f02\u5e38\uff1a");
        exception.printStackTrace();
        if (exceptions >= this.getExceptionLimit()) {
            this.logger.error("\u53ef\u63a5\u53d7\u5f02\u5e38\u5df2\u5230\u8fbe\u6700\u5927\u9650\u5236: " + String.valueOf(this.exceptionCaught) + " -> " + this.getExceptionLimit());
            this.schedules.clear();
            this.disablePlugin();
        }
    }

    private void processExceptionCount() {
        this.exceptionCaught.decrementAndGet();
        this.schedule(this::processExceptionCount, 5);
    }

    @Override
    @Deprecated
    public ScheduleInfo schedule(Consumer<?> consumer) {
        return this.schedule(() -> consumer.accept(null));
    }

    @Override
    @Deprecated
    public ScheduleInfo schedule(Consumer<?> c, int delay) {
        return this.schedule(() -> c.accept(null), delay);
    }

    @Override
    @Deprecated
    public ScheduleInfo schedule(Consumer<?> c, int delay, boolean isAsync) {
        return this.schedule(() -> c.accept(null), delay, isAsync);
    }

    @Override
    public ScheduleInfo schedule(Runnable runnable) {
        return this.schedule(runnable, 1);
    }

    @Override
    public ScheduleInfo schedule(Runnable function, int delay) {
        return this.schedule(function, delay, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduleInfo schedule(Runnable function, int delay, boolean async) {
        ScheduleInfo si = new ScheduleInfo(function, delay, this.currentTick, async);
        if (!this.acceptSchedules) {
            si.cancel();
            return si;
        }
        List<ScheduleInfo> list = this.schedules;
        synchronized (list) {
            this.schedules.add(si);
        }
        return si;
    }

    @Override
    public long getCurrentTick() {
        return this.currentTick;
    }

    private /* synthetic */ void lambda$tick$1(List toRemove, ScheduleInfo c) {
        if (c == null) {
            if (this.doInternalDebugOutput) {
                this.logger.warn("Trying to execute a NULL ScheduleInfo?! This shouldn't happen!");
            }
            return;
        }
        if (c.isCanceled()) {
            toRemove.add(c);
            return;
        }
        if (this.currentTick - c.TickScheduled >= (long)c.Delay) {
            toRemove.add(c);
            if (this.cancelSchedules) {
                return;
            }
            if (c.isAsync) {
                this.runAsync(() -> this.runFunction(c));
            } else {
                this.runFunction(c);
            }
        }
    }
}

