/*
 * Decompiled with CFR 0.152.
 */
package xiamomc.pluginbase.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import xiamomc.pluginbase.Annotations.Initializer;
import xiamomc.pluginbase.PluginObject;
import xiamomc.pluginbase.XiaMoJavaPlugin;

public abstract class JsonBasedStorage<T, P extends XiaMoJavaPlugin>
extends PluginObject<P> {
    protected File configurationFile;
    private static final Gson defaultGson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().disableHtmlEscaping().create();
    private final Gson gson = this.createGson();
    protected boolean storageInitialized;
    protected T storingObject = this.createDefault();

    protected Gson createGson() {
        return defaultGson;
    }

    protected JsonBasedStorage() {
    }

    public void initializeStorage() {
        this.initializeStorage(false);
    }

    public void initializeStorage(boolean noReload) {
        try {
            if (this.configurationFile == null) {
                this.configurationFile = new File(URI.create(String.valueOf(this.plugin.getDataFolder().toURI()) + "/" + this.getFileName()));
            }
            if (!this.configurationFile.exists()) {
                if (!this.configurationFile.getParentFile().exists()) {
                    Files.createDirectories(Paths.get(this.configurationFile.getParentFile().toURI()), new FileAttribute[0]);
                }
                if (!this.configurationFile.createNewFile()) {
                    this.logger.error("Unable to create file '%s', not loading storage data!".formatted(this.getFileName()));
                    return;
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("\u672a\u80fd\u521d\u59cb\u5316" + this.getDisplayName() + "\u7684JSON\u914d\u7f6e\uff1a" + t.getMessage());
            t.printStackTrace();
        }
        if (!noReload) {
            this.reloadConfiguration();
        }
        this.storageInitialized = true;
    }

    @Initializer
    private void load() {
        if (!this.storageInitialized) {
            this.initializeStorage();
        }
    }

    @NotNull
    protected abstract String getFileName();

    @NotNull
    protected abstract T createDefault();

    @NotNull
    protected abstract String getDisplayName();

    public boolean reloadConfiguration() {
        Object targetStore = null;
        boolean success = false;
        if (!this.configurationFile.exists()) {
            this.initializeStorage(true);
        }
        try (FileInputStream fileStream = new FileInputStream(this.configurationFile);
             InputStreamReader jsonStream = new InputStreamReader(fileStream);){
            targetStore = this.gson.fromJson((Reader)jsonStream, this.storingObject.getClass());
            success = true;
        }
        catch (Throwable t) {
            this.logger.warn("Can't load JSON configuration for " + this.getDisplayName() + ": " + t.getMessage());
            t.printStackTrace();
        }
        if (targetStore == null) {
            targetStore = this.createDefault();
        }
        this.storingObject = targetStore;
        return success;
    }

    public boolean saveConfiguration() {
        try {
            String jsonString = this.gson.toJson(this.storingObject);
            if (this.configurationFile.exists()) {
                this.configurationFile.delete();
            }
            if (!this.configurationFile.createNewFile()) {
                this.logger.error("Unable to create file, no saving configuration for '%s'!".formatted(this.getDisplayName()));
                return false;
            }
            try (FileOutputStream stream = new FileOutputStream(this.configurationFile);){
                stream.write(jsonString.getBytes());
            }
        }
        catch (Throwable t) {
            this.logger.error("Unable to save configuration for %s: %s".formatted(this.getDisplayName(), t.getMessage()));
            throw new RuntimeException(t);
        }
        return true;
    }
}

