/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xiamomc.pluginbase.Annotations.Initializer;
import xiamomc.pluginbase.Annotations.Resolved;
import xiamomc.pluginbase.Bindables.Bindable;
import xiamomc.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.client.DisguiseInstanceTracker;
import xyz.nifeather.morph.client.EntityCache;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.graphics.toasts.DisguiseEntryToast;
import xyz.nifeather.morph.client.graphics.toasts.NewDisguiseSetToast;
import xyz.nifeather.morph.client.properties.AbstractPropertyHandler;
import xyz.nifeather.morph.client.properties.PropertyHandlers;
import xyz.nifeather.morph.client.syncers.ClientDisguiseSyncer;
import xyz.nifeather.morph.client.syncers.DisguiseSyncer;
import xyz.nifeather.morph.client.syncers.OtherClientDisguiseSyncer;
import xyz.nifeather.morph.client.syncers.animations.AnimHandlerIndex;
import xyz.nifeather.morph.client.syncers.animations.AnimationHandler;

public class ClientMorphManager
extends MorphClientObject {
    private final SortedSet<String> availableMorphs = new ObjectAVLTreeSet();
    public final Bindable<String> selectedIdentifier = new Bindable<Object>(null);
    public final Bindable<String> currentIdentifier = new Bindable<Object>(null);
    @Deprecated(forRemoval=true)
    public final Bindable<Boolean> equipOverriden = new Bindable<Boolean>(false);
    @Deprecated(forRemoval=true)
    public final Bindable<class_2487> currentNbtCompound = new Bindable<Object>(null);
    public final Bindable<Float> revealingValue = new Bindable<Float>(Float.valueOf(0.0f));
    @Resolved
    private DisguiseInstanceTracker instanceTracker;
    private final List<String> emotes = new ObjectArrayList();
    @Nullable
    public String lastEmote;
    @Nullable
    public String emoteDisplayName;
    @Nullable
    private DisguiseSyncer localPlayerSyncer;
    private class_638 world;
    private class_638 prevWorld;
    @Nullable
    private class_1657 lastClientPlayer;
    public final Bindable<Boolean> selfVisibleEnabled = new Bindable<Boolean>(false);
    private final List<Function<List<String>, Boolean>> onGrantConsumers = new ObjectArrayList();
    private final List<Function<List<String>, Boolean>> onRevokeConsumers = new ObjectArrayList();
    @Deprecated(forRemoval=true)
    private final Map<class_1304, class_1799> equipmentSlotItemStackMap = new Object2ObjectOpenHashMap();
    private final class_1799 air = class_1799.field_8037;
    @Resolved
    private AnimHandlerIndex animIndex;
    @Deprecated(forRemoval=true)
    @Nullable
    private GameProfile serverSkin;
    @Nullable
    private AbstractPropertyHandler<?> propertyHandler;

    public List<String> getAvailableMorphs() {
        return this.availableMorphs.stream().toList();
    }

    public void clearAvailableDisguises() {
        ObjectArrayList disguises = new ObjectArrayList(this.availableMorphs);
        this.availableMorphs.clear();
        this.invokeRevoke((List<String>)disguises);
    }

    public void setEmotes(List<String> emotes) {
        if (emotes.size() > 4) {
            this.logger.warn("Server send a emote that has more than 4 elements!");
        }
        this.emotes.clear();
        this.emotes.addAll(emotes);
    }

    public void setEmoteDisplay(String id) {
        this.emoteDisplayName = id;
    }

    public void playEmote(String emote) {
        this.lastEmote = !emote.equals("reset") && !emote.equals("try_reset") ? emote : null;
        if (this.localPlayerSyncer != null) {
            this.localPlayerSyncer.playAnimation(emote);
        }
    }

    public List<String> getEmotes() {
        return new ObjectArrayList(this.emotes);
    }

    @Initializer
    private void load() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (RenderSystem.isOnRenderThread()) {
                this.onDisconnect();
            } else {
                this.addSchedule(this::onDisconnect);
            }
        });
        this.addSchedule(this::update);
    }

    private void onDisconnect() {
        this.world = null;
        this.prevWorld = null;
        this.reset();
    }

    private void update() {
        this.addSchedule(this::update);
        this.world = class_310.method_1551().field_1687;
        if (this.world == null) {
            return;
        }
        if (this.prevWorld == null) {
            this.prevWorld = this.world;
        }
        if (this.world != this.prevWorld) {
            this.prevWorld = this.world;
        }
        class_746 currentClientPlayer = class_310.method_1551().field_1724;
        if (this.lastClientPlayer != null && this.lastClientPlayer != currentClientPlayer) {
            this.refreshLocalSyncer(this.currentIdentifier.get());
        }
        if (currentClientPlayer == null || this.lastClientPlayer == currentClientPlayer) {
            return;
        }
        this.lastClientPlayer = currentClientPlayer;
    }

    private void setBindingClientSyncer(@NotNull DisguiseSyncer disguiseSyncer) {
        this.instanceTracker.setSyncer(class_310.method_1551().field_1724.method_5628(), disguiseSyncer);
        this.localPlayerSyncer = disguiseSyncer;
    }

    private void disposeExistingSyncerIfPresent() {
        if (this.localPlayerSyncer == null) {
            return;
        }
        this.logger.info("Removing previous syncer " + String.valueOf(this.localPlayerSyncer));
        this.instanceTracker.removeSyncer(this.localPlayerSyncer);
        this.localPlayerSyncer.dispose();
        this.localPlayerSyncer = null;
    }

    private Optional<DisguiseSyncer> setupSyncerFromIdentifier(@Nullable String disguiseIdentifier, BiConsumer<class_1309, AbstractPropertyHandler<class_1309>> onEntitySetup) {
        if (disguiseIdentifier == null || disguiseIdentifier.isBlank()) {
            return Optional.empty();
        }
        this.disposeExistingSyncerIfPresent();
        class_746 clientPlayer = class_310.method_1551().field_1724;
        assert (clientPlayer != null);
        DisguiseSyncer newDisguiseSyncer = this.createSyncerFor((class_742)clientPlayer, disguiseIdentifier, clientPlayer.method_5628());
        if (newDisguiseSyncer == null) {
            return Optional.empty();
        }
        if (this.lastEmote != null) {
            newDisguiseSyncer.playAnimation(this.lastEmote);
        }
        if (this.serverSkin != null) {
            newDisguiseSyncer.updateSkin(this.serverSkin);
        }
        newDisguiseSyncer.getEntityFuture().thenAccept(entity -> {
            AbstractPropertyHandler<class_1309> nextPropertyHandler = PropertyHandlers.INSTANCE.getHandler(entity).orElseThrow();
            this.propertyHandler = nextPropertyHandler;
            onEntitySetup.accept((class_1309)entity, nextPropertyHandler);
        });
        return Optional.of(newDisguiseSyncer);
    }

    private void refreshLocalSyncer(String currentIdentifier) {
        DisguiseSyncer lastDisguiseSyncer = this.localPlayerSyncer;
        Map<Object, Object> cachedProperty = lastDisguiseSyncer == null ? Map.of() : lastDisguiseSyncer.cachedNetworkProperties();
        this.disposeExistingSyncerIfPresent();
        this.setupSyncerFromIdentifier(currentIdentifier, (entity, propertyHandler) -> propertyHandler.tryCast((class_1297)entity).ifPresent(living -> propertyHandler.handle(cachedProperty, living))).ifPresent(syncer -> {
            syncer.mergeNetworkProperties(cachedProperty);
            this.setBindingClientSyncer((DisguiseSyncer)syncer);
        });
    }

    public void onMorphGrant(Function<List<String>, Boolean> consumer) {
        this.onGrantConsumers.add(consumer);
    }

    public void onMorphRevoke(Function<List<String>, Boolean> consumer) {
        this.onRevokeConsumers.add(consumer);
    }

    private void invokeRevoke(List<String> diff) {
        ObjectArrayList tobeRemoved = new ObjectArrayList();
        this.onRevokeConsumers.forEach(f -> {
            if (!((Boolean)f.apply(diff)).booleanValue()) {
                tobeRemoved.add(f);
            }
        });
        this.onRevokeConsumers.removeAll((Collection<?>)tobeRemoved);
    }

    private void invokeGrant(List<String> diff) {
        ObjectArrayList tobeRemoved = new ObjectArrayList();
        this.onGrantConsumers.forEach(f -> {
            if (!((Boolean)f.apply(diff)).booleanValue()) {
                tobeRemoved.add(f);
            }
        });
        this.onGrantConsumers.removeAll((Collection<?>)tobeRemoved);
    }

    public void setDisguises(List<String> identifiers, boolean displayToasts) {
        this.invokeRevoke(this.availableMorphs.stream().toList());
        this.availableMorphs.clear();
        this.addDisguises(identifiers, false);
        DisguiseEntryToast.invalidateAll();
        if (displayToasts) {
            class_310.method_1551().method_1566().method_1999((class_368)new NewDisguiseSetToast(this.availableMorphs.size() <= 0));
        }
    }

    public void addDisguises(List<String> identifiers, boolean displayToasts) {
        identifiers = new ObjectArrayList(identifiers);
        identifiers.removeIf(this.availableMorphs::contains);
        identifiers.forEach(i -> this.addDisguisePrivate((String)i, displayToasts));
        this.invokeGrant((List<String>)identifiers);
    }

    public void addDisguise(String identifier, boolean displayToasts) {
        this.addDisguisePrivate(identifier, displayToasts);
    }

    public void removeDisguises(List<String> identifiers, boolean displayToasts) {
        identifiers.forEach(i -> this.removeDisguisePrivate((String)i, displayToasts));
        this.invokeRevoke(identifiers);
    }

    public void removeDisguise(String identifier, boolean displayToasts) {
        this.removeDisguisePrivate(identifier, displayToasts);
    }

    private void addDisguisePrivate(String identifier, boolean displayToasts) {
        if (identifier.isEmpty()) {
            return;
        }
        this.availableMorphs.add(identifier);
        if (displayToasts) {
            class_310.method_1551().method_1566().method_1999((class_368)new DisguiseEntryToast(identifier, true));
        }
    }

    private void removeDisguisePrivate(String identifier, boolean displayToasts) {
        this.availableMorphs.remove(identifier);
        if (displayToasts) {
            class_310.method_1551().method_1566().method_1999((class_368)new DisguiseEntryToast(identifier, false));
        }
    }

    @Deprecated(forRemoval=true)
    public class_1799 getOverridedItemStackOn(class_1304 slot) {
        return this.equipmentSlotItemStackMap.getOrDefault(slot, this.air);
    }

    @Deprecated(forRemoval=true)
    public void swapHand() {
        class_1799 mainHand = this.equipmentSlotItemStackMap.getOrDefault(class_1304.field_6173, this.air);
        class_1799 offHand = this.equipmentSlotItemStackMap.getOrDefault(class_1304.field_6171, this.air);
        this.equipmentSlotItemStackMap.put(class_1304.field_6173, offHand);
        this.equipmentSlotItemStackMap.put(class_1304.field_6171, mainHand);
    }

    @Deprecated(forRemoval=true)
    public void setEquip(class_1304 slot, class_1799 item) {
        this.equipmentSlotItemStackMap.put(slot, item);
    }

    public void reset() {
        this.clearAvailableDisguises();
        this.setEmotes(List.of());
        this.selectedIdentifier.set(null);
        this.currentIdentifier.set(null);
        this.revealingValue.set(Float.valueOf(0.0f));
        if (this.localPlayerSyncer != null) {
            this.localPlayerSyncer.dispose();
        }
        this.localPlayerSyncer = null;
        this.lastEmote = null;
        EntityCache.getGlobalCache().dropAll();
        this.prevWorld = null;
        this.world = null;
        this.lastClientPlayer = null;
    }

    public void setCurrent(String val) {
        RenderSystem.assertOnRenderThread();
        if (this.localPlayerSyncer != null) {
            this.localPlayerSyncer.dispose();
        }
        this.localPlayerSyncer = null;
        this.lastEmote = null;
        this.emoteDisplayName = null;
        this.serverSkin = null;
        this.setupSyncerFromIdentifier(val, (a, b) -> {}).ifPresent(this::setBindingClientSyncer);
        if (val != null && val.isBlank()) {
            val = null;
        }
        this.currentIdentifier.set(val);
        this.equipOverriden.set(false);
        this.equipmentSlotItemStackMap.clear();
        this.currentNbtCompound.set(null);
    }

    public DisguiseSyncer createSyncerFor(class_742 player, String disguiseId, int networkId) {
        class_746 clientPlayer = class_310.method_1551().field_1724;
        if (clientPlayer == null) {
            throw new NullDependencyException("Required non-null client player to get DisguiseSyncer");
        }
        DisguiseSyncer syncer = clientPlayer == player ? new ClientDisguiseSyncer(player, disguiseId, networkId) : new OtherClientDisguiseSyncer(player, disguiseId, networkId);
        AnimationHandler handler = this.animIndex.get(disguiseId);
        syncer.setAnimationHandler(handler);
        return syncer;
    }

    @Deprecated(forRemoval=true)
    public void updateSkin(GameProfile profile) {
        this.serverSkin = profile;
        if (this.localPlayerSyncer != null) {
            this.localPlayerSyncer.updateSkin(profile);
        } else {
            this.logger.warn("Calling UpdateSkin while localPlayerSyncer is null!");
            Thread.dumpStack();
        }
    }

    public void handlePropertiesUpdate(Map<String, String> input) {
        if (this.localPlayerSyncer == null) {
            return;
        }
        this.localPlayerSyncer.mergeNetworkProperties(input);
        class_1309 entity = this.localPlayerSyncer.getDisguiseInstance();
        if (entity == null) {
            return;
        }
        AbstractPropertyHandler<?> propertyHandler = this.propertyHandler();
        if (propertyHandler == null) {
            return;
        }
        propertyHandler.tryCast((class_1297)entity).ifPresent(cast -> propertyHandler.handle(input, cast));
    }

    @Nullable
    public AbstractPropertyHandler<?> propertyHandler() {
        return this.propertyHandler;
    }
}

