/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_368;
import xiamomc.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.graphics.toasts.RequestToast;
import xyz.nifeather.morph.network.commands.S2C.S2CUpdateRequestStatusCommand;

public class ClientRequestManager
extends MorphClientObject {
    private final List<Request> requests = new ObjectArrayList();

    public void addRequest(S2CUpdateRequestStatusCommand.Type type, String sourceName) {
        if (type == S2CUpdateRequestStatusCommand.Type.Unknown) {
            return;
        }
        class_310.method_1551().method_1566().method_1999((class_368)new RequestToast(type, sourceName));
        this.requests.add(new Request(this.plugin.getCurrentTick(), type, sourceName));
    }

    public void scheduleRemoveRequest(String sourceName) {
        this.addSchedule(() -> this.requests.removeIf(r -> r.sourceName.equalsIgnoreCase(sourceName)));
    }

    public List<Request> getRequests() {
        return new ObjectArrayList(this.requests);
    }

    @Initializer
    private void load() {
        this.addSchedule(this::update);
    }

    private void update() {
        long currentTime = this.plugin.getCurrentTick();
        this.requests.removeIf(r -> currentTime - r.beginTime > 1800L);
    }

    private record Request(long beginTime, S2CUpdateRequestStatusCommand.Type type, String sourceName) {
    }
}

