/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xiamomc.pluginbase.XiaMoJavaPlugin;
import xyz.nifeather.morph.FeatherMorphCommonBootstrap;
import xyz.nifeather.morph.client.ClientMorphManager;
import xyz.nifeather.morph.client.ClientRequestManager;
import xyz.nifeather.morph.client.ClientSkillHandler;
import xyz.nifeather.morph.client.DisguiseInstanceTracker;
import xyz.nifeather.morph.client.EntityCache;
import xyz.nifeather.morph.client.config.ModConfigData;
import xyz.nifeather.morph.client.graphics.EntityRendererHelper;
import xyz.nifeather.morph.client.graphics.ModelWorkarounds;
import xyz.nifeather.morph.client.graphics.hud.HudRenderHelper;
import xyz.nifeather.morph.client.network.ServerHandler;
import xyz.nifeather.morph.client.properties.PropertyHandlers;
import xyz.nifeather.morph.client.screens.WaitingForServerScreen;
import xyz.nifeather.morph.client.screens.disguise.DisguiseScreen;
import xyz.nifeather.morph.client.screens.emote.EmoteScreen;
import xyz.nifeather.morph.client.storage.SavedDisguiseStorage;
import xyz.nifeather.morph.client.syncers.DisguiseSyncer;
import xyz.nifeather.morph.client.syncers.animations.AnimHandlerIndex;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SActivateSkillCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SMorphCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SSetSingleOptionCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SToggleSelfCommand;
import xyz.nifeather.morph.network.commands.C2S.C2SUnmorphCommand;
import xyz.nifeather.morph.shared.SharedValues;
import xyz.nifeather.morph.shared.platform.PlatformHelper;
import xyz.nifeather.morph.shared.platform.Services;

public class FeatherMorphClientBootstrap
extends XiaMoJavaPlugin {
    @Nullable
    private static FeatherMorphClientBootstrap instance;
    private Path configPath;
    private final Function<String, Boolean> isModLoaded;
    public static final String UNMORPH_STIRNG = "morph:unmorph";
    public static final Logger LOGGER;
    @Nullable
    private Runnable mainLoopRunnable;
    public ClientMorphManager morphManager;
    public ServerHandler serverHandler;
    private ClientSkillHandler skillHandler;
    private DisguiseInstanceTracker disguiseTracker;
    public SavedDisguiseStorage savedDisguiseStorage;
    private final AnimHandlerIndex animHandlerIndex = new AnimHandlerIndex();
    private final boolean debugToasts = false;
    private final HudRenderHelper hudRenderHelper = new HudRenderHelper();
    private ModelWorkarounds modelWorkarounds;
    @Nullable
    private Boolean attackPressedDown = null;
    private class_304 toggleselfKeyBind;
    private class_304 executeSkillKeyBind;
    private class_304 unMorphKeyBind;
    private class_304 morphKeyBind;
    private class_304 resetCacheKeybind;
    private class_304 displayOwnerBind;
    private class_304 emoteKeyBind;
    private class_304 testKeyBindGrant;
    private class_304 testKeyBindLost;
    private final int keybindCount = 4;
    @Nullable
    private Boolean lastClientView = null;

    public static FeatherMorphClientBootstrap getInstance() {
        return instance;
    }

    public static boolean isModLoaded(String modId) {
        return instance != null && FeatherMorphClientBootstrap.instance.isModLoaded.apply(modId) != false;
    }

    @Override
    public String namespace() {
        return FeatherMorphClientBootstrap.getClientNameSpace();
    }

    public static String getClientNameSpace() {
        return "morphclient";
    }

    @Override
    public Logger getSLF4JLogger() {
        return LOGGER;
    }

    @Override
    public void startMainLoop(Runnable r) {
        this.mainLoopRunnable = r;
    }

    @Override
    public void runAsync(Runnable r) {
        class_156.method_18349().execute(r);
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return new File(this.configPath.toFile(), "feathermorphclient-fabric");
    }

    public FeatherMorphClientBootstrap(Path configPath, Function<String, Boolean> isModLoaded) {
        instance = this;
        this.isModLoaded = isModLoaded;
        this.configPath = configPath;
        this.enablePlugin();
        this.registerKeys();
        this.dependencyManager.cache(this);
        this.disguiseTracker = new DisguiseInstanceTracker();
        this.dependencyManager.cache(this.disguiseTracker);
        this.morphManager = new ClientMorphManager();
        this.dependencyManager.cache(this.morphManager);
        this.serverHandler = new ServerHandler(this);
        this.dependencyManager.cache(this.serverHandler);
        this.skillHandler = new ClientSkillHandler();
        this.dependencyManager.cache(this.skillHandler);
        this.dependencyManager.cache(this.getModConfigData());
        this.dependencyManager.cache(new ClientRequestManager());
        this.dependencyManager.cache(new EntityRendererHelper());
        this.dependencyManager.cache(this.animHandlerIndex);
        this.serverHandler.initializeNetwork();
        Services.PLATFORM.registerClientTickEndEvent(this::tick);
        Services.PLATFORM.registerWorldTickEndEvent(this::postWorldTick);
        Services.PLATFORM.registerHudRenderEvent(this.hudRenderHelper::onRender);
        this.modelWorkarounds = ModelWorkarounds.getInstance();
        this.savedDisguiseStorage = new SavedDisguiseStorage();
        PropertyHandlers.init();
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.savedDisguiseStorage.clearCache());
    }

    private void postWorldTick(class_638 clientWorld) {
        ObjectArrayList syncersToRemove = new ObjectArrayList();
        this.disguiseTracker.getAllSyncer().forEach(syncer -> {
            if (syncer.disposed()) {
                syncersToRemove.add(syncer);
            } else {
                syncer.onGameTick();
            }
        });
        syncersToRemove.forEach(syncer -> this.disguiseTracker.removeSyncer((DisguiseSyncer)syncer));
    }

    public class_304 getEmoteKeyBind() {
        return this.emoteKeyBind;
    }

    private void registerKeys() {
        PlatformHelper platform = Services.PLATFORM;
        class_304.class_11900 category = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"morphclient", (String)"keybind"));
        this.executeSkillKeyBind = platform.registerPlatformKeyBinding(new class_304("key.morphclient.skill", class_3675.class_307.field_1668, 86, category));
        this.unMorphKeyBind = platform.registerPlatformKeyBinding(new class_304("key.morphclient.unmorph", class_3675.class_307.field_1668, 264, category));
        this.morphKeyBind = platform.registerPlatformKeyBinding(new class_304("key.morphclient.morph", class_3675.class_307.field_1668, 78, category));
        this.toggleselfKeyBind = platform.registerPlatformKeyBinding(new class_304("key.morphclient.toggle", class_3675.class_307.field_1668, 262, category));
        this.emoteKeyBind = platform.registerPlatformKeyBinding(new class_304("key.morphclient.emote", class_3675.class_307.field_1668, 71, category));
        this.resetCacheKeybind = platform.registerPlatformKeyBinding(new class_304("key.morphclient.reset_cache", class_3675.class_307.field_1668, -1, category));
        this.displayOwnerBind = platform.registerPlatformKeyBinding(new class_304("key.morphclient.display_name", class_3675.class_307.field_1668, 297, category));
    }

    private void updateKeys(class_310 client) {
        while (this.executeSkillKeyBind.method_1436() && this.skillHandler.getCurrentCooldown() <= 0L) {
            this.skillHandler.setSkillCooldown(this.skillHandler.getSkillCooldown());
            this.serverHandler.sendCommand((AbstractC2SCommand<?>)new C2SActivateSkillCommand());
        }
        while (this.unMorphKeyBind.method_1436()) {
            this.serverHandler.sendCommand((AbstractC2SCommand<?>)new C2SUnmorphCommand());
        }
        boolean attackPressed = class_310.method_1551().field_1690.field_1886.method_1434();
        if (attackPressed != Boolean.TRUE.equals(this.attackPressedDown)) {
            DisguiseSyncer syncer;
            class_746 clientPlayer = class_310.method_1551().field_1724;
            if (clientPlayer != null && attackPressed && (syncer = DisguiseInstanceTracker.getInstance().getSyncerFor((class_1297)clientPlayer)) != null) {
                syncer.playAttackAnimation();
            }
            this.attackPressedDown = attackPressed;
        }
        if (this.displayOwnerBind.method_1436()) {
            boolean doRender;
            EntityRendererHelper.doRenderRealName = doRender = !EntityRendererHelper.doRenderRealName;
            class_746 clientPlayer = client.field_1724;
            if (clientPlayer != null) {
                clientPlayer.method_7353((class_2561)class_2561.method_43471((String)("text.morphclient." + (doRender ? "display" : "hide") + "_real_names")), false);
            }
        }
        while (this.toggleselfKeyBind.method_1436()) {
            ModConfigData config = this.getModConfigData();
            boolean val = this.morphManager.selfVisibleEnabled.get() == false;
            this.updateClientView(config.allowClientView, val);
        }
        while (this.morphKeyBind.method_1436()) {
            class_746 player = client.field_1724;
            if (player != null && player.field_3913 != null && player.field_3913.field_54155.comp_3164()) {
                this.serverHandler.sendCommand((AbstractC2SCommand<?>)new C2SMorphCommand(null, Collections.emptyMap()));
                continue;
            }
            if (client.field_1755 != null) continue;
            client.method_1507((class_437)new WaitingForServerScreen(new DisguiseScreen()));
        }
        while (this.resetCacheKeybind.method_1436()) {
            EntityCache.getGlobalCache().clearCache();
            this.modelWorkarounds.initWorkarounds();
        }
        while (this.emoteKeyBind.method_1436()) {
            class_310.method_1551().method_1507((class_437)new WaitingForServerScreen(new EmoteScreen()));
        }
    }

    public void updateClientView(boolean clientViewEnabled, boolean selfViewVisible) {
        if (this.lastClientView == null || clientViewEnabled != this.lastClientView) {
            this.serverHandler.sendCommand((AbstractC2SCommand<?>)new C2SToggleSelfCommand(clientViewEnabled ? C2SToggleSelfCommand.SelfViewMode.CLIENT_ON : C2SToggleSelfCommand.SelfViewMode.CLIENT_OFF));
            this.lastClientView = clientViewEnabled;
        }
        this.serverHandler.sendCommand((AbstractC2SCommand<?>)new C2SToggleSelfCommand(C2SToggleSelfCommand.SelfViewMode.fromBoolean((boolean)selfViewVisible)));
        this.getModConfigData().allowClientView = clientViewEnabled;
    }

    public void requestDisguise(String id, Map<String, String> properties) {
        if (id == null) {
            id = UNMORPH_STIRNG;
        }
        if (UNMORPH_STIRNG.equals(id)) {
            this.serverHandler.sendCommand((AbstractC2SCommand<?>)new C2SUnmorphCommand());
        } else {
            this.serverHandler.sendCommand((AbstractC2SCommand<?>)new C2SMorphCommand(id, properties));
        }
    }

    private void onConfigSave() {
        FeatherMorphCommonBootstrap.instance().configHolder.save();
    }

    public ModConfigData getModConfigData() {
        return FeatherMorphCommonBootstrap.instance().modConfigData;
    }

    public ConfigBuilder getFactory(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create();
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory categoryGeneral = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"stat.generalButton"));
        ModConfigData modConfigData = this.getModConfigData();
        categoryGeneral.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.disguise_list_mouse_drag.name"), modConfigData.disguiseListMouseDragging).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.morphclient.disguise_list_mouse_drag.description")}).setDefaultValue(false).setSaveConsumer(v -> {
            modConfigData.disguiseListMouseDragging = v;
        }).build()).addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.previewInInventory.name"), modConfigData.alwaysShowPreviewInInventory).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.morphclient.previewInInventory.description")}).setDefaultValue(false).setSaveConsumer(v -> {
            modConfigData.alwaysShowPreviewInInventory = v;
        }).build()).addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.changeCameraHeight.name"), modConfigData.changeCameraHeight).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.morphclient.changeCameraHeight.description")}).setDefaultValue(false).setSaveConsumer(v -> {
            modConfigData.changeCameraHeight = v;
        }).build()).addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.allowClientView.name"), modConfigData.allowClientView).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.morphclient.allowClientView.description")}).setDefaultValue(true).setSaveConsumer(v -> {
            modConfigData.allowClientView = v;
            if (this.serverHandler.serverReady()) {
                this.updateClientView((boolean)v, this.morphManager.selfVisibleEnabled.get());
            }
        }).build()).addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.displayDisguiseOnHud.name"), modConfigData.displayDisguiseOnHud).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.morphclient.displayDisguiseOnHud.description")}).setDefaultValue(true).setSaveConsumer(v -> {
            modConfigData.displayDisguiseOnHud = v;
            if (this.serverHandler.serverReady()) {
                this.serverHandler.sendCommand((AbstractC2SCommand<?>)new C2SSetSingleOptionCommand(C2SSetSingleOptionCommand.ClientOptionEnum.HUD, v.booleanValue()));
            }
        }).build()).addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((class_2561)class_2561.method_43471((String)"option.morphclient.scrollSpeed.name"), modConfigData.scrollSpeed).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.morphclient.scrollSpeed.description")}).setMax(4.0f).setMin(0.5f).setDefaultValue(1.0f).setSaveConsumer(v -> {
            modConfigData.scrollSpeed = v.floatValue();
        }).build()).addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.verbosePackets.name"), modConfigData.verbosePackets).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.morphclient.verbosePackets.description")}).setDefaultValue(false).setSaveConsumer(v -> {
            modConfigData.verbosePackets = v;
        }).build()).addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.nametag_scaling"), modConfigData.scaleNameTag).setDefaultValue(false).setSaveConsumer(v -> {
            modConfigData.scaleNameTag = v;
        }).build());
        ConfigCategory categoryToast = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.morphclient.config_toasts"));
        categoryToast.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.grant_revoke_toasts"), modConfigData.displayGrantRevokeToast).setDefaultValue(true).setSaveConsumer(v -> {
            modConfigData.displayGrantRevokeToast = v;
        }).build()).addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.query_set_toasts"), modConfigData.displayQuerySetToast).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.morphclient.query_set_toasts.desc")}).setDefaultValue(false).setSaveConsumer(v -> {
            modConfigData.displayQuerySetToast = v;
        }).build()).addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.toast_progress"), modConfigData.displayToastProgress).setDefaultValue(false).setSaveConsumer(v -> {
            modConfigData.displayToastProgress = v;
        }).build());
        ConfigCategory debugCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"category.morphclient.debug"));
        debugCategory.setDescription(new class_5348[]{class_2561.method_43471((String)"category.morphclient.debug.description")});
        debugCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.morphclient.singleplayer_debug"), SharedValues.allowSinglePlayerDebugging).setTooltip(new class_2561[]{class_2561.method_43471((String)"option.morphclient.singleplayer_debug.tooltip")}).setDefaultValue(false).setSaveConsumer(v -> {
            SharedValues.allowSinglePlayerDebugging = v;
            modConfigData.singlePlayerDebugging = v;
        }).build());
        builder.setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)"title.morphclient.config")).transparentBackground();
        builder.setSavingRunnable(this::onConfigSave);
        return builder;
    }

    private void tick(class_310 client) {
        if (this.mainLoopRunnable != null) {
            this.mainLoopRunnable.run();
        }
        this.updateKeys(client);
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"FeatherMorph$Client");
    }
}

