/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.entities;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.response.NameAndId;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_11560;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_745;
import net.minecraft.class_7497;
import net.minecraft.class_7920;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.graphics.capes.ICapeProvider;
import xyz.nifeather.morph.client.graphics.capes.providers.KappaCapeProvider;

public class MorphLocalPlayer
extends class_745 {
    private final class_3545<Integer, GameProfile> currentProfilePair = new class_3545((Object)0, null);
    private final String playerName;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private class_2960 morphTextureIdentifier = class_2960.method_60655((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
    @Nullable
    private class_2960 capeTextureIdentifier;
    @Nullable
    private class_2960 ofCapeIdentifier;
    @Nullable
    private String skinTextureUrl;
    @NotNull
    private class_7920 model = class_7920.field_41122;
    @Nullable
    private class_1657 bindingPlayer;
    private volatile int requestId = 0;
    private static final ICapeProvider customCapeProvider = new KappaCapeProvider();
    private final AtomicBoolean initialFetchFired = new AtomicBoolean(false);
    @Nullable
    private volatile class_640 playerInfo;
    @Nullable
    private class_2338 overrideSleepPos;
    private class_1306 overrideMainArm;

    public boolean personEquals(MorphLocalPlayer other) {
        return other.playerName.equals(this.playerName);
    }

    public void copyFrom(MorphLocalPlayer prevPlayer) {
        ++this.requestId;
        this.capeTextureIdentifier = prevPlayer.capeTextureIdentifier;
        this.morphTextureIdentifier = prevPlayer.morphTextureIdentifier;
        this.model = prevPlayer.model;
        this.currentProfilePair.method_34964((Object)this.requestId);
        this.currentProfilePair.method_34965((Object)((GameProfile)prevPlayer.currentProfilePair.method_15441()));
        this.skinTextureUrl = prevPlayer.skinTextureUrl;
    }

    @Nullable
    public class_1657 getBindingPlayer() {
        return this.bindingPlayer;
    }

    public boolean hasBindingPlayer() {
        return this.bindingPlayer != null;
    }

    public void setBindingPlayer(@Nullable class_1657 newInstance) {
        this.bindingPlayer = newInstance;
    }

    public MorphLocalPlayer(class_638 clientWorld, GameProfile initialProfile, @Nullable class_1657 bindingPlayer) {
        super(clientWorld, initialProfile);
        this.setBindingPlayer(bindingPlayer);
        this.playerName = initialProfile.name();
        this.currentProfilePair.method_34964((Object)0);
        this.currentProfilePair.method_34965((Object)initialProfile);
        this.field_6011.method_12778(field_62514, (Object)127);
        this.updateSkin(initialProfile, true);
    }

    private static CompletableFuture<Optional<GameProfile>> fetchProfile(String playerName) {
        return CompletableFuture.supplyAsync(() -> {
            NameAndId repoProfile;
            class_7497 services = class_310.method_1551().method_73361();
            class_11560 cachedNameIdPair = services.comp_4407().method_14515(playerName).orElse(null);
            if (cachedNameIdPair == null && (repoProfile = (NameAndId)services.comp_839().findProfileByName(playerName).orElse(null)) != null) {
                cachedNameIdPair = new class_11560(repoProfile.id(), repoProfile.name());
            }
            if (cachedNameIdPair == null) {
                return Optional.empty();
            }
            ProfileResult profileFetchResult = services.comp_837().fetchProfile(cachedNameIdPair.comp_4422(), true);
            if (profileFetchResult == null) {
                return Optional.empty();
            }
            return Optional.of(profileFetchResult.profile());
        });
    }

    public void updateSkin(GameProfile profile) {
        this.updateSkin(profile, false);
    }

    private void updateSkin(GameProfile profile, boolean isInitial) {
        if (!RenderSystem.isOnRenderThread()) {
            FeatherMorphClientBootstrap.getInstance().schedule(() -> this.updateSkin(profile));
            return;
        }
        if (isInitial && this.initialFetchFired.get()) {
            return;
        }
        this.initialFetchFired.set(true);
        int reqId = this.requestId;
        int invokeId = this.requestId = reqId + 1;
        if (profile.properties().containsKey((Object)"textures")) {
            this.updateSkinTextures(profile);
            return;
        }
        MorphLocalPlayer.fetchProfile(profile.name()).thenAccept(optional -> {
            if (invokeId == this.requestId) {
                FeatherMorphClientBootstrap.getInstance().schedule(() -> optional.ifPresent(this::updateSkinTextures));
            }
        });
    }

    private void updateSkinTextures(GameProfile profile) {
        RenderSystem.assertOnRenderThread();
        this.playerInfo = new class_640(profile, false);
    }

    @NotNull
    public Optional<class_2338> method_18398() {
        if (this.overrideSleepPos != null) {
            return Optional.of(this.overrideSleepPos);
        }
        return super.method_18398();
    }

    public void overrideSleepPos(class_2338 pos) {
        this.overrideSleepPos = pos;
    }

    public boolean method_7325() {
        return this.bindingPlayer != null && this.bindingPlayer.method_7325();
    }

    public void setOverrideMainArm(@Nullable class_1306 arm) {
        this.overrideMainArm = arm;
    }

    @NotNull
    public class_1306 method_6068() {
        if (this.overrideMainArm != null) {
            return this.overrideMainArm;
        }
        return this.bindingPlayer == null ? super.method_6068() : this.bindingPlayer.method_6068();
    }

    public boolean method_6128() {
        return this.bindingPlayer == null ? super.method_6128() : this.bindingPlayer.method_6128();
    }

    public boolean method_6123() {
        return this.bindingPlayer == null ? super.method_6123() : this.bindingPlayer.method_6123();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
    }

    public boolean method_74091(class_1664 modelPart) {
        return this.bindingPlayer == null || this.bindingPlayer.method_74091(modelPart);
    }

    @Nullable
    public class_640 method_3123() {
        return this.playerInfo;
    }

    public boolean method_5733() {
        return this.hasBindingPlayer() && (class_310.method_1551().method_1560() != this.bindingPlayer || this.bindingPlayer != class_310.method_1551().field_1724);
    }

    public double method_5707(class_243 vector) {
        if (vector.equals((Object)class_310.method_1551().field_1773.method_19418().method_19326())) {
            return 0.0;
        }
        return super.method_5707(vector);
    }
}

