/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5611;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2i;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.graphics.Anchor;
import xyz.nifeather.morph.client.graphics.Axes;
import xyz.nifeather.morph.client.graphics.IMDrawable;
import xyz.nifeather.morph.client.graphics.MarginPadding;
import xyz.nifeather.morph.client.graphics.transforms.Recorder;
import xyz.nifeather.morph.client.graphics.transforms.Transformer;
import xyz.nifeather.morph.client.graphics.transforms.easings.Easing;
import xyz.nifeather.morph.client.utilties.MathUtils;

public abstract class MDrawable
extends MorphClientObject
implements IMDrawable {
    protected int depth = 0;
    @NotNull
    protected Anchor anchor = Anchor.TopLeft;
    protected IMDrawable parent;
    protected final AtomicBoolean posValid = new AtomicBoolean(false);
    protected final AtomicBoolean layoutValid = new AtomicBoolean(false);
    protected float xScreenSpaceOffset;
    protected float yScreenSpaceOffset;
    protected Axes relativeSizeAxes = Axes.None;
    protected float width = 1.0f;
    protected float height = 1.0f;
    protected int renderWidth;
    protected int renderHeight;
    private int x;
    private int y;
    private float screenSpaceX;
    private float screenSpaceY;
    private float parentScreenSpaceX;
    private float parentScreenSpaceY;
    @NotNull
    private class_8030 parentScreenSpace = class_8030.method_48248();
    @NotNull
    protected MarginPadding padding = new MarginPadding();
    @NotNull
    private MarginPadding margin = new MarginPadding();
    private boolean masking = false;
    private boolean hovered;
    private Recorder<Integer> xRec;
    private Recorder<Integer> yRec;
    private Recorder<Float> hRec;
    private Recorder<Float> wRec;
    protected final Recorder<Float> alpha = new Recorder<Float>(Float.valueOf(1.0f));
    private boolean focused;

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @NotNull
    public Anchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(@NotNull Anchor anchor) {
        if (anchor == this.anchor) {
            return;
        }
        this.anchor = anchor;
        this.invalidatePosition();
    }

    @Override
    public void setParent(IMDrawable parent) {
        if (this.parent == parent) {
            return;
        }
        if (this.parent != null) {
            throw new RuntimeException("A drawable may not have multiple parents.");
        }
        this.parent = parent;
        this.invalidatePosition();
        this.invalidateLayout();
    }

    @Override
    public IMDrawable getParent() {
        return this.parent;
    }

    @Override
    @ApiStatus.Internal
    public void invalidatePosition() {
        this.posValid.set(false);
    }

    @Override
    @ApiStatus.Internal
    public void invalidateLayout() {
        this.layoutValid.set(false);
    }

    protected boolean validateLayout() {
        return this.layoutValid.get();
    }

    protected void updateLayout() {
        this.layoutValid.set(true);
        if (this.parent == null) {
            this.updateParentScreenSpace();
        }
    }

    protected boolean validatePosition() {
        return this.posValid.get();
    }

    protected void updatePosition() {
        if (this.parent != null) {
            this.setParentScreenSpaceY(this.parent.getScreenSpaceY());
            this.setParentScreenSpaceX(this.parent.getScreenSpaceX());
            MarginPadding parentPadding = this.parent.getPadding();
            float rectW = this.parent.getRenderWidth() - parentPadding.left - parentPadding.right;
            float rectH = this.parent.getRenderHeight() - parentPadding.top - parentPadding.bottom;
            this.setParentScreenSpace(new class_8030(0, 0, (int)rectW, (int)rectH));
        } else {
            this.updateParentScreenSpace();
        }
        this.renderWidth = this.relativeSizeAxes.modX ? Math.round(this.width * (float)this.parentScreenSpace.comp_1196()) : Math.round(this.width);
        this.renderHeight = this.relativeSizeAxes.modY ? Math.round(this.height * (float)this.parentScreenSpace.comp_1197()) : Math.round(this.height);
        class_1041 windowInstance = class_310.method_1551().method_22683();
        boolean isEmptyRect = this.parentScreenSpace == class_8030.method_48248();
        float parentRectWidth = isEmptyRect ? (float)windowInstance.method_4486() : (float)this.parentScreenSpace.comp_1196();
        float parentRectHeight = isEmptyRect ? (float)windowInstance.method_4502() : (float)this.parentScreenSpace.comp_1197();
        class_5611 rectCentre = new class_5611(parentRectWidth / 2.0f, parentRectHeight / 2.0f);
        float xScreenSpaceOffset = this.x;
        float yScreenSpaceOffset = this.y;
        MarginPadding parentPadding = this.parent == null ? new MarginPadding(0.0f) : this.parent.getPadding();
        int maskX = this.anchor.posMask << 4 >> 4;
        if ((maskX & 1) == 1) {
            xScreenSpaceOffset += this.margin.left + parentPadding.left;
        } else if ((maskX & 2) == 2) {
            xScreenSpaceOffset += this.margin.getCentreOffsetX() + (rectCentre.method_32118() - (float)this.renderWidth / 2.0f) + parentPadding.getCentreOffsetX();
        } else if ((maskX & 4) == 4) {
            xScreenSpaceOffset += -this.margin.right + (parentRectWidth - (float)this.renderWidth) - parentPadding.left;
        }
        int maskY = this.anchor.posMask >> 4 << 4;
        if ((maskY & 0x10) == 16) {
            yScreenSpaceOffset += this.margin.top + parentPadding.top;
        } else if ((maskY & 0x20) == 32) {
            yScreenSpaceOffset += this.margin.getCentreOffsetY() + (rectCentre.method_32119() - (float)this.renderHeight / 2.0f) + parentPadding.getCentreOffsetY();
        } else if ((maskY & 0x40) == 64) {
            yScreenSpaceOffset += -this.margin.bottom + (parentRectHeight - (float)this.renderHeight) - parentPadding.bottom;
        }
        this.xScreenSpaceOffset = xScreenSpaceOffset;
        this.yScreenSpaceOffset = yScreenSpaceOffset;
        this.screenSpaceX = this.parentScreenSpaceX + xScreenSpaceOffset;
        this.screenSpaceY = this.parentScreenSpaceY + yScreenSpaceOffset;
        this.posValid.set(true);
    }

    public Axes getRelativeSizeAxes() {
        return this.relativeSizeAxes;
    }

    public void setRelativeSizeAxes(Axes a) {
        this.relativeSizeAxes = a;
        this.invalidateLayout();
        this.invalidatePosition();
    }

    public float getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(float w) {
        if (this.width == w) {
            return;
        }
        this.width = w;
        this.invalidatePosition();
        this.invalidateLayout();
    }

    @Override
    public float getRenderWidth() {
        boolean modX = this.relativeSizeAxes.modX;
        return modX ? this.width * (float)this.getParentScreenSpace().comp_1196() : this.width;
    }

    public float getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(float h) {
        if (this.height == h) {
            return;
        }
        this.height = h;
        this.invalidatePosition();
        this.invalidateLayout();
    }

    @Override
    public float getRenderHeight() {
        boolean modY = this.relativeSizeAxes.modY;
        return modY ? this.height * (float)this.getParentScreenSpace().comp_1197() : this.height;
    }

    @Override
    public void setSize(class_5611 vector2f) {
        this.setWidth(vector2f.method_32118());
        this.setHeight(vector2f.method_32119());
    }

    @Override
    public float getScreenSpaceX() {
        return this.screenSpaceX;
    }

    @Override
    public float getScreenSpaceY() {
        return this.screenSpaceY;
    }

    public void setParentScreenSpaceX(float parentX) {
        if (this.parentScreenSpaceX == parentX) {
            return;
        }
        this.parentScreenSpaceX = parentX;
        this.invalidatePosition();
    }

    public void setParentScreenSpaceY(float parentY) {
        if (this.parentScreenSpaceY == parentY) {
            return;
        }
        this.parentScreenSpaceY = parentY;
        this.invalidatePosition();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int newX) {
        if (this.x == newX) {
            return;
        }
        this.x = newX;
        this.invalidatePosition();
    }

    public int getY() {
        return this.y;
    }

    public void setY(int newY) {
        if (this.y == newY) {
            return;
        }
        this.y = newY;
        this.invalidatePosition();
    }

    protected void updateParentScreenSpace() {
        class_1041 windowInstance = class_310.method_1551().method_22683();
        this.parentScreenSpace = new class_8030(0, 0, windowInstance.method_4486(), windowInstance.method_4502());
    }

    @NotNull
    public class_8030 getParentScreenSpace() {
        if (this.parentScreenSpace == class_8030.method_48248()) {
            class_1041 windowInstance = class_310.method_1551().method_22683();
            return new class_8030(0, 0, windowInstance.method_4486(), windowInstance.method_4502());
        }
        return this.parentScreenSpace;
    }

    public void setParentScreenSpace(class_8030 rect) {
        if (this.parentScreenSpace.equals((Object)rect)) {
            return;
        }
        this.parentScreenSpace = rect;
        this.invalidatePosition();
    }

    @Override
    @NotNull
    public MarginPadding getPadding() {
        return this.padding;
    }

    public void setPadding(MarginPadding padding) {
        this.padding = padding = padding == null ? new MarginPadding() : padding;
    }

    @NotNull
    public MarginPadding getMargin() {
        return this.margin;
    }

    public void setMargin(@NotNull MarginPadding margin) {
        if (this.margin.equals(margin)) {
            return;
        }
        this.margin = margin;
        this.invalidatePosition();
    }

    public boolean masking() {
        return this.masking;
    }

    public void setMasking(boolean masking) {
        this.masking = masking;
    }

    protected void onRender(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.hovered();
    }

    protected boolean hovered() {
        return this.hovered;
    }

    protected void onHover() {
    }

    protected void onHoverLost() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        boolean hovered = this.hovered;
        boolean bl = this.hovered = (float)mouseX < this.screenSpaceX + this.width && (float)mouseX > this.screenSpaceX && (float)mouseY < this.screenSpaceY + this.height && (float)mouseY > this.screenSpaceY;
        if (hovered != this.hovered) {
            if (this.hovered) {
                this.onHover();
            } else {
                this.onHoverLost();
            }
        }
        if (this.alpha.get().floatValue() == 0.0f) {
            matrices.popMatrix();
            return;
        }
        try {
            if (!this.validatePosition()) {
                this.updatePosition();
            }
            if (!this.validateLayout()) {
                this.updateLayout();
            }
            matrices.translate(this.xScreenSpaceOffset, this.yScreenSpaceOffset);
            if (this.masking) {
                context.method_44379(0, 0, this.renderWidth, this.renderHeight);
            }
            this.onRender(context, mouseX, mouseY, delta);
        }
        finally {
            matrices.translate(-this.xScreenSpaceOffset, -this.yScreenSpaceOffset);
            matrices.popMatrix();
            if (this.masking) {
                context.method_44380();
            }
        }
    }

    public void moveTo(Vector2i position, long duration, Easing easing) {
        this.moveToX(position.x(), duration, easing);
        this.moveToY(position.y(), duration, easing);
    }

    public void moveToX(int x, long duration, Easing easing) {
        if (this.xRec == null) {
            this.xRec = new Recorder<Integer>(this.x);
            this.xRec.onUpdate = this::setX;
        }
        Transformer.transform(this.xRec, Integer.valueOf(x), duration, easing);
    }

    public void moveToY(int newY, long duration, Easing easing) {
        if (this.yRec == null) {
            this.yRec = new Recorder<Integer>(this.y);
            this.yRec.onUpdate = this::setY;
        }
        Transformer.transform(this.yRec, Integer.valueOf(newY), duration, easing);
    }

    public void resizeHeightTo(float newH, long duration, Easing easing) {
        if (this.hRec == null) {
            this.hRec = new Recorder<Float>(Float.valueOf(this.height));
            this.hRec.onUpdate = this::setHeight;
        }
        Transformer.transform(this.hRec, Float.valueOf(newH), duration, easing);
    }

    public void resizeWidthTo(float newW, long duration, Easing easing) {
        if (this.wRec == null) {
            this.wRec = new Recorder<Float>(Float.valueOf(this.width));
            this.wRec.onUpdate = this::setWidth;
        }
        Transformer.transform(this.wRec, Float.valueOf(newW), duration, easing);
    }

    public void resizeTo(class_5611 wH, long duration, Easing easing) {
        this.resizeHeightTo(wH.method_32118(), duration, easing);
        this.resizeWidthTo(wH.method_32119(), duration, easing);
    }

    public void setAlpha(float newVal) {
        this.alpha.set(Float.valueOf(newVal));
    }

    public void fadeTo(float newVal, long duration, Easing easing) {
        Transformer.transform(this.alpha, Float.valueOf(MathUtils.clamp(0.0f, 1.0f, newVal)), duration, easing);
    }

    public void fadeIn(long duration, Easing easing) {
        this.fadeTo(1.0f, duration, easing);
    }

    public void fadeOut(long duration, Easing easing) {
        this.fadeTo(0.0f, duration, easing);
    }

    @Override
    public void dispose() {
    }

    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        return this.method_25370() ? null : class_8016.method_48193((class_364)this);
    }

    public class_8030 method_48202() {
        return new class_8030(this.getX(), this.getY(), Math.round(this.getRenderWidth()), Math.round(this.getHeight()));
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public class_6379.class_6380 method_37018() {
        return this.focused ? class_6379.class_6380.field_33786 : (this.hovered ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784);
    }

    public void method_37020(class_6382 builder) {
    }
}

