/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;
import xyz.nifeather.morph.client.Vec3dUtils;

public class ModelWorkarounds {
    private static ModelWorkarounds instance;
    private final Map<class_2960, ModelPartConsumer<class_630, class_630>> workarounds = new Object2ObjectOpenHashMap();

    public static ModelWorkarounds getInstance() {
        if (instance == null) {
            instance = new ModelWorkarounds();
        }
        return instance;
    }

    private void addWorkaround(class_1299<?> modelType, ModelPartConsumer<class_630, class_630> consumer) {
        this.workarounds.put(class_1299.method_5890(modelType), consumer);
    }

    private void addWorkaround(List<class_1299<?>> types, ModelPartConsumer<class_630, class_630> consumer) {
        types.forEach(t -> this.addWorkaround((class_1299<?>)t, consumer));
    }

    public ModelWorkarounds() {
        this.initWorkarounds();
    }

    public void initWorkarounds() {
        LoggerFactory.getLogger((String)"morph").info("Initializing arm render workarounds");
        this.workarounds.clear();
        this.addWorkaround(List.of(class_1299.field_38095, class_1299.field_6077, class_1299.field_6047), (class_630 l, class_630 r) -> WorkaroundMeta.of(class_243.field_1353, Vec3dUtils.ONE()));
        this.addWorkaround(List.of(class_1299.field_21973, class_1299.field_23696), (class_630 l, class_630 r) -> WorkaroundMeta.of(new class_243(0.0, (double)-0.57f, (double)0.8f), Vec3dUtils.ONE()));
        this.addWorkaround(List.of(class_1299.field_6048, class_1299.field_6075, class_1299.field_6139), (class_630 l, class_630 r) -> WorkaroundMeta.of(new class_243(0.0, (double)-0.45f, 1.0), Vec3dUtils.ONE()));
        this.addWorkaround(class_1299.field_6042, (class_630 l, class_630 r) -> WorkaroundMeta.of(new class_243(0.0, (double)-0.57f, (double)0.65f), Vec3dUtils.ONE()));
        this.addWorkaround(class_1299.field_6046, (class_630 l, class_630 r) -> WorkaroundMeta.of(new class_243(0.0, (double)-0.57f, 0.5), Vec3dUtils.ONE()));
        this.addWorkaround(class_1299.field_6147, (class_630 l, class_630 r) -> WorkaroundMeta.of(Vec3dUtils.of(0.0, -0.2, 0.0), Vec3dUtils.of(0.75)));
        this.addWorkaround(List.of(class_1299.field_38384, class_1299.field_6059), (class_630 l, class_630 r) -> {
            r.field_3674 = 0.0f;
            l.field_3674 = 0.0f;
            return new WorkaroundMeta(Vec3dUtils.of(0.0, 0.25, 0.1), Vec3dUtils.of(1.5));
        });
        this.addWorkaround(class_1299.field_6099, (class_630 l, class_630 r) -> WorkaroundMeta.of(Vec3dUtils.of(0.0, -0.1, 0.2), Vec3dUtils.ONE()));
        this.addWorkaround(List.of(class_1299.field_40116, class_1299.field_42622), (class_630 l, class_630 r) -> WorkaroundMeta.of(new class_243(0.0, -0.6, 0.7), Vec3dUtils.ONE()));
        this.addWorkaround(class_1299.field_6077, (class_630 l, class_630 r) -> WorkaroundMeta.of(new class_243(0.0, -0.5, 0.3), Vec3dUtils.ONE()));
        this.addWorkaround(class_1299.field_6067, (class_630 l, class_630 r) -> WorkaroundMeta.of(Vec3dUtils.of(0.0, -0.5, 0.6f), Vec3dUtils.ONE()));
        this.addWorkaround(class_1299.field_6116, (class_630 l, class_630 r) -> {
            l.field_3675 = -0.6f;
            r.field_3675 = -l.field_3675;
            return new WorkaroundMeta(Vec3dUtils.of(0.0, -3.2, 0.6f), Vec3dUtils.of(0.6));
        });
    }

    private WorkaroundMeta defaultMeta() {
        return new WorkaroundMeta(new class_243(0.0, (double)-0.6f, (double)0.45f), Vec3dUtils.ONE());
    }

    public WorkaroundMeta apply(class_1299<?> entityType, class_630 left, class_630 right) {
        ModelPartConsumer<class_630, class_630> workaround = this.workarounds.get(class_1299.method_5890(entityType));
        return workaround == null ? this.defaultMeta() : workaround.accept(left, right);
    }

    private static interface ModelPartConsumer<L, R> {
        @NotNull
        public WorkaroundMeta accept(L var1, R var2);
    }

    public record WorkaroundMeta(class_243 offset, class_243 scale) {
        public static WorkaroundMeta of(class_243 offset, class_243 scale) {
            return new WorkaroundMeta(offset, scale);
        }
    }
}

