/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.color;

import me.shedaniel.math.Color;
import xyz.nifeather.morph.client.utilties.MathUtils;

public class ColorUtils {
    private static final int colorMask = 255;

    public static Color fromIntRGBA(int color) {
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        return Color.ofRGBA((int)r, (int)g, (int)b, (int)a);
    }

    public static Color fromIntARGB(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return Color.ofRGBA((int)r, (int)g, (int)b, (int)a);
    }

    public static Color fromHex(String hex) {
        if (!((String)hex).startsWith("#")) {
            hex = "#" + (String)hex;
        }
        boolean hasAlpha = ((String)hex).length() >= 8;
        int rawColor = Integer.decode((String)hex);
        int a = hasAlpha ? rawColor >> 24 & 0xFF : 255;
        int r = rawColor >> 16 & 0xFF;
        int g = rawColor >> 8 & 0xFF;
        int b = rawColor & 0xFF;
        return Color.ofRGBA((int)r, (int)g, (int)b, (int)a);
    }

    public static int[] toRgbaArray(int c) {
        Color color = ColorUtils.fromIntRGBA(c);
        return new int[]{color.getRed() / 255, color.getGreen() / 255, color.getBlue() / 255, color.getAlpha() / 255};
    }

    public static Color forOpacity(Color color, float alpha) {
        alpha = MathUtils.clamp(0.0f, 1.0f, alpha);
        return Color.ofRGBA((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue(), (int)Math.round(255.0f * alpha));
    }

    public static float GetHue(Color color) {
        float cMin;
        float b1;
        float g1;
        float r1 = (float)color.getRed() / 255.0f;
        float cMax = MathUtils.max(r1, g1 = (float)color.getGreen() / 255.0f, b1 = (float)color.getBlue() / 255.0f);
        float cDelta = cMax - (cMin = MathUtils.min(r1, g1, b1));
        if (cDelta == 0.0f) {
            return 0.0f;
        }
        if (cMax == r1) {
            return 60.0f * ((g1 - b1) / cDelta % 6.0f);
        }
        if (cMax == g1) {
            return 60.0f * ((b1 - r1) / cDelta + 2.0f);
        }
        return 60.0f * ((r1 - g1) / cDelta + 4.0f);
    }

    public static float getSaturation(Color color) {
        float cMin;
        float b1;
        float g1;
        float r1 = (float)color.getRed() / 255.0f;
        float cMax = MathUtils.max(r1, g1 = (float)color.getGreen() / 255.0f, b1 = (float)color.getBlue() / 255.0f);
        float cDelta = cMax - (cMin = MathUtils.min(r1, g1, b1));
        if (cDelta == 0.0f) {
            return 0.0f;
        }
        return cDelta / cMax;
    }

    public static float getBrightnessOrValue(Color color) {
        float r1 = (float)color.getRed() / 255.0f;
        float g1 = (float)color.getGreen() / 255.0f;
        float b1 = (float)color.getBlue() / 255.0f;
        return MathUtils.max(r1, g1, b1);
    }
}

