/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.container;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import xyz.nifeather.morph.client.graphics.IMDrawable;
import xyz.nifeather.morph.client.graphics.MDrawable;

public class BasicContainer<T extends IMDrawable>
extends MDrawable
implements class_4069 {
    protected final List<T> children = new ObjectArrayList();
    private boolean dragging;
    private class_364 focusedElement;

    @Override
    @ApiStatus.Internal
    public void invalidatePosition() {
        this.invalidateLayout();
        super.invalidatePosition();
        this.children.forEach(IMDrawable::invalidatePosition);
    }

    public List<T> method_25396() {
        return new ObjectArrayList(this.children);
    }

    @Override
    public void invalidateLayout() {
        this.children.forEach(IMDrawable::invalidateLayout);
        super.invalidateLayout();
    }

    @Override
    protected void updateLayout() {
        for (IMDrawable child : this.children) {
            child.setParent(this);
        }
        super.updateLayout();
    }

    public void add(T drawable) {
        this.children.add(drawable);
        drawable.setParent(this);
        this.invalidateLayout();
    }

    public void addRange(T ... drawables) {
        this.children.addAll(Arrays.stream(drawables).toList());
        this.invalidateLayout();
    }

    public void addRange(Collection<T> drawables) {
        this.children.addAll(drawables);
        this.invalidateLayout();
    }

    public void remove(T drawable) {
        drawable.setParent(null);
        this.children.remove(drawable);
        drawable.dispose();
        this.invalidateLayout();
    }

    public void removeRange(T[] drawables) {
        this.children.removeAll(Arrays.stream(drawables).toList());
        for (T drawable : drawables) {
            drawable.dispose();
        }
        this.invalidateLayout();
    }

    public void removeRange(Collection<T> drawables) {
        this.children.removeAll(drawables);
        for (IMDrawable drawable : drawables) {
            drawable.dispose();
        }
        this.invalidateLayout();
    }

    public void clear() {
        this.children.forEach(drawable -> {
            drawable.setParent(null);
            drawable.dispose();
        });
        this.children.clear();
        this.invalidateLayout();
    }

    public boolean contains(T drawable) {
        return this.children.contains(drawable);
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        List<IMDrawable> filter = this.children.stream().filter(child -> mouseX > (double)child.getScreenSpaceX() && mouseX < (double)(child.getScreenSpaceX() + child.getRenderWidth()) && mouseY > (double)child.getScreenSpaceY() && mouseY < (double)(child.getScreenSpaceY() + child.getRenderHeight())).toList();
        boolean handled = false;
        for (IMDrawable t : filter) {
            if (!t.method_25402(mouseButtonEvent, bl)) continue;
            handled = true;
            break;
        }
        return handled;
    }

    public boolean method_25397() {
        return this.dragging;
    }

    public void method_25398(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public class_364 method_25399() {
        return this.focusedElement;
    }

    public void method_25395(@Nullable class_364 focused) {
        if (this.focusedElement != null) {
            this.focusedElement.method_25365(false);
        }
        this.focusedElement = focused;
        if (focused != null) {
            focused.method_25365(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRender(class_332 context, int mouseX, int mouseY, float delta) {
        super.onRender(context, mouseX, mouseY, delta);
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate(0.0f, 0.0f, (Matrix3x2f)matrices);
        try {
            this.children.forEach(d -> {
                boolean haveDepth = d.getDepth() != 0;
                d.method_25394(context, mouseX, mouseY, delta);
            });
        }
        finally {
            matrices.popMatrix();
        }
    }

    @Override
    @Nullable
    public class_8016 method_48205(class_8023 navigation) {
        return super.method_48205(navigation);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.children.forEach(IMDrawable::dispose);
    }
}

