/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.container;

import net.minecraft.class_332;
import xiamomc.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.client.graphics.Anchor;
import xyz.nifeather.morph.client.graphics.Axes;
import xyz.nifeather.morph.client.graphics.MDrawable;
import xyz.nifeather.morph.client.graphics.color.MaterialColors;
import xyz.nifeather.morph.client.graphics.container.BasicContainer;

public class BasicFlowContainer<T extends MDrawable>
extends BasicContainer<T> {
    private int spacing = 0;
    private Axes flowAxes = Axes.Both;

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int newVal) {
        if (newVal == this.spacing) {
            return;
        }
        this.spacing = newVal;
        this.invalidateLayout();
    }

    public Axes getFlowAxes() {
        return this.flowAxes;
    }

    public void setFlowAxes(Axes val) {
        if (val == this.flowAxes) {
            return;
        }
        if (val == Axes.None || val == null) {
            val = Axes.Both;
        }
        this.flowAxes = val;
        this.invalidateLayout();
    }

    @Initializer
    private void load() {
    }

    @Override
    protected void updateLayout() {
        super.updateLayout();
        int currentX = 0;
        int currentY = 0;
        float childMaxHeight = 0.0f;
        Anchor lastChildAnchor = null;
        for (MDrawable child : this.children) {
            Anchor childAnchor = child.getAnchor();
            if (lastChildAnchor != null && lastChildAnchor != childAnchor) {
                throw new IllegalStateException("Different anchors are not supported.");
            }
            lastChildAnchor = childAnchor;
            if (child.getAnchor() != Anchor.TopLeft) {
                throw new IllegalArgumentException("Anchors except TopLeft are not supported yet.");
            }
            if (this.flowAxes == Axes.Both) {
                float rectWidth = this.relativeSizeAxes.modX ? this.width * (float)this.getParentScreenSpace().comp_1196() : this.width;
                float maxWidth = rectWidth - this.padding.left - this.padding.right;
                if ((float)currentX + child.getWidth() > maxWidth) {
                    currentY = (int)((float)currentY + (childMaxHeight + (float)this.spacing));
                    currentX = 0;
                    childMaxHeight = 0.0f;
                }
            }
            child.setX(currentX);
            child.setY(currentY);
            switch (this.flowAxes) {
                case Both: {
                    currentX = (int)((float)currentX + (Math.max(0.0f, child.getWidth()) + (float)this.spacing));
                    childMaxHeight = Math.max(childMaxHeight, child.getHeight());
                    break;
                }
                case X: {
                    currentX = (int)((float)currentX + (Math.max(0.0f, child.getWidth()) + (float)this.spacing));
                    break;
                }
                case Y: {
                    currentY = (int)((float)currentY + (Math.max(0.0f, child.getHeight()) + (float)this.spacing));
                }
            }
        }
    }

    @Override
    protected void onRender(class_332 context, int mouseX, int mouseY, float delta) {
        super.onRender(context, mouseX, mouseY, delta);
        context.method_25294(0, 0, this.renderWidth, this.renderHeight, MaterialColors.Amber500.getColor());
    }
}

