/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.hud;

import me.shedaniel.math.Color;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import xiamomc.pluginbase.Annotations.Initializer;
import xiamomc.pluginbase.Annotations.Resolved;
import xiamomc.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.client.ClientMorphManager;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.graphics.color.ColorUtils;
import xyz.nifeather.morph.client.graphics.color.MaterialColors;
import xyz.nifeather.morph.client.graphics.transforms.Recorder;
import xyz.nifeather.morph.client.graphics.transforms.Transformer;
import xyz.nifeather.morph.client.graphics.transforms.easings.Easing;

public class HudRenderHelper
extends MorphClientObject {
    @Resolved
    private ClientMorphManager manager;
    private final Bindable<Float> revValueNext = new Bindable<Float>(Float.valueOf(0.0f));
    private final Recorder<Float> revDisplayRecorder = new Recorder<Float>(Float.valueOf(0.0f));
    private final Recorder<Float> progressHeightRecorder = new Recorder<Float>(Float.valueOf(0.0f));
    private final Recorder<Float> barHeightRecorder = new Recorder<Float>(Float.valueOf(0.0f));
    private final Recorder<Color> colorRecord = new Recorder<Color>(Color.ofOpaque((int)0));
    private final Bindable<Color> colorNext = new Bindable<Color>(Color.ofOpaque((int)0));
    private final Recorder<Float> drawAlpha = new Recorder<Float>(Float.valueOf(0.0f));
    private final Bindable<Color> preferredBgColor = new Bindable<Color>(Color.ofOpaque((int)0));
    private final Recorder<Color> bgColorRecord = new Recorder<Color>(Color.ofOpaque((int)0));
    private final Bindable<Boolean> visible = new Bindable<Boolean>(false);

    @Initializer
    private void load() {
        this.revValueNext.bindTo(this.manager.revealingValue);
        this.colorNext.onValueChanged((o, n) -> {
            if (o == null) {
                o = MaterialColors.Indigo500;
            }
            if (!n.equals(o)) {
                Transformer.transform(this.colorRecord, n, this.visible.get() != false ? 1500L : 0L, Easing.OutQuint);
            }
        }, true);
        this.revValueNext.onValueChanged((o, n) -> Transformer.transform(this.revDisplayRecorder, n, this.visible.get() != false ? 2000L : 0L, Easing.OutQuint), true);
        this.preferredBgColor.onValueChanged((o, n) -> {
            if (o == null) {
                o = MaterialColors.Indigo500;
            }
            if (!n.equals(o)) {
                Transformer.transform(this.bgColorRecord, n, this.visible.get() != false ? 1500L : 0L, Easing.OutQuint);
            }
        }, true);
        this.visible.onValueChanged((o, n) -> {
            Transformer.transform(this.progressHeightRecorder, Float.valueOf(n != false ? 0.0f : -2.5f), 650L, Easing.InOutQuint);
            Transformer.transform(this.barHeightRecorder, Float.valueOf(n != false ? 0.0f : -6.0f), 650L, Easing.OutBack);
            Transformer.transform(this.drawAlpha, Float.valueOf(n != false ? 1.0f : 0.0f), 650L, Easing.OutQuint);
        }, true);
        this.addSchedule(this::update);
    }

    private void update() {
        this.addSchedule(this::update);
        Float rev = this.revDisplayRecorder.get();
        Color targetClr = rev.floatValue() >= 20.0f ? (rev.floatValue() >= 80.0f ? MaterialColors.Red600 : MaterialColors.Orange500) : MaterialColors.Green400;
        this.colorNext.set(targetClr);
        this.preferredBgColor.set(targetClr.darker(3.0));
        this.visible.set(rev.floatValue() > 0.1f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender(class_332 context, class_9779 renderTickCounter) {
        if (this.manager == null || this.drawAlpha.get().floatValue() == 0.0f || class_310.method_1551().field_1690.field_1842) {
            return;
        }
        Matrix3x2fStack matrices = context.method_51448();
        try {
            matrices.pushMatrix();
            this.renderBar(context, renderTickCounter);
        }
        finally {
            matrices.popMatrix();
        }
    }

    public void renderBar(class_332 context, class_9779 renderTickCounter) {
        int width = 8;
        int height = 28;
        int padding = 1;
        int windowHeight = context.method_51443();
        Matrix3x2fStack matrices = context.method_51448();
        Color backgroundColor = ColorUtils.forOpacity(this.bgColorRecord.get(), this.drawAlpha.get().floatValue());
        int contentColor = ColorUtils.forOpacity(this.colorRecord.get(), this.drawAlpha.get().floatValue()).getColor();
        float offsetX = this.barHeightRecorder.get().floatValue() + 2.0f;
        int offsetY = windowHeight - height - 2;
        matrices.translate(offsetX, (float)offsetY, (Matrix3x2f)matrices);
        context.method_25294(0, 0, width, height, backgroundColor.darker(1.3).getColor());
        int barStart = padding + Math.round((float)(height - padding * 2) * (this.revDisplayRecorder.get().floatValue() / 100.0f));
        int barEnd = height - padding;
        context.method_25294(padding, barStart, width - padding, barEnd, contentColor);
    }
}

