/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.toasts;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import me.shedaniel.math.Color;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import xiamomc.pluginbase.Annotations.Initializer;
import xiamomc.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.graphics.color.ColorUtils;
import xyz.nifeather.morph.client.graphics.transforms.Recorder;
import xyz.nifeather.morph.client.graphics.transforms.Transformer;
import xyz.nifeather.morph.client.graphics.transforms.easings.Easing;

public class LinedToast
extends MorphClientObject
implements class_368 {
    private final Recorder<Integer> outlineWidth = Recorder.of(0);
    protected final Bindable<class_368.class_369> visibility = new Bindable<class_368.class_369>(class_368.class_369.field_2209);
    private final AtomicBoolean layoutValid = new AtomicBoolean(false);
    private static final class_2561 defaultText = class_2561.method_43473();
    private class_2561 title;
    private class_2561 description;
    private class_2561 titleDisplay = defaultText;
    private class_2561 descDisplay = defaultText;
    private Color lineColor = Color.ofRGB((int)255, (int)255, (int)255);
    private final class_327 textRenderer;
    private double progress;
    private final Color progressColor;
    private final Color borderColor;

    public LinedToast() {
        this.textRenderer = class_310.method_1551().field_1772;
        this.progress = 0.0;
        this.progressColor = ColorUtils.fromHex("666666");
        this.borderColor = ColorUtils.fromHex("#444444");
    }

    protected boolean fadeInOnEnter() {
        return false;
    }

    @Initializer
    private void load() {
        this.outlineWidth.set(this.method_29049());
        this.visibility.onValueChanged((o, visible) -> {
            if (visible == class_368.class_369.field_2210) {
                Transformer.delay(300).then(() -> Transformer.transform(this.outlineWidth, Integer.valueOf(2), 600L, Easing.OutQuint));
            } else {
                Transformer.transform(this.outlineWidth, Integer.valueOf(this.method_29049()), 600L, Easing.OutQuad);
            }
        }, true);
    }

    protected void invalidateLayout() {
        this.layoutValid.set(false);
    }

    protected void updateLayout() {
        if (this.title != null) {
            class_5250 titleDisplay = class_2561.method_43470((String)this.textRenderer.method_1714((class_5348)this.title, this.getTextWidth()).getString());
            if (!titleDisplay.getString().equalsIgnoreCase(this.title.getString())) {
                titleDisplay = class_2561.method_30163((String)(titleDisplay.getString() + "..."));
            }
            this.titleDisplay = titleDisplay;
        } else {
            this.titleDisplay = class_2561.method_43470((String)"Null title");
        }
        if (this.description != null) {
            class_5250 descDisplay = class_2561.method_43470((String)this.textRenderer.method_1714((class_5348)this.description, this.getTextWidth()).getString());
            if (!descDisplay.getString().equalsIgnoreCase(this.description.getString())) {
                descDisplay = class_2561.method_30163((String)(descDisplay.getString() + "..."));
            }
            this.descDisplay = descDisplay;
        } else {
            this.descDisplay = class_2561.method_43470((String)"");
        }
        this.layoutValid.set(true);
    }

    public void setTitle(class_2561 text) {
        this.title = text;
        this.invalidateLayout();
    }

    @Nullable
    public class_2561 getTitle() {
        return this.title;
    }

    public void setDescription(class_2561 text) {
        this.description = text;
        this.invalidateLayout();
    }

    @Nullable
    public class_2561 getDescription() {
        return this.description;
    }

    @NotNull
    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(@Nullable Color newColor) {
        if (newColor == null) {
            newColor = Color.ofRGB((int)255, (int)255, (int)255);
        }
        this.lineColor = newColor;
    }

    protected void postTextDrawing(class_332 context, long startTime) {
    }

    protected void postBackgroundDrawing(class_332 context, long startTime) {
    }

    protected void postDraw(class_332 context, long startTime) {
    }

    protected boolean drawProgress() {
        return FeatherMorphClientBootstrap.getInstance().getModConfigData().displayToastProgress;
    }

    protected float getTextStartX() {
        return (float)this.method_29049() * 0.25f - 4.0f;
    }

    protected int getTextWidth() {
        return (int)((float)this.method_29049() * 0.65f);
    }

    public class_368.class_369 method_61988() {
        return this.visibility.get();
    }

    public void method_61989(class_374 manager, long startTime) {
        this.progress = Math.min(1.0, (double)startTime / (5000.0 * manager.method_48221()));
        class_368.class_369 visibility = this.progress >= 1.0 ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
        this.visibility.set(visibility);
    }

    public void method_1986(class_332 context, class_327 textRenderer, long startTime) {
        if (!this.layoutValid.get()) {
            this.updateLayout();
        }
        int xRightPadding = 1;
        int xLeftPadding = 2;
        int yPadding = 1;
        context.method_44379(xRightPadding, 0, this.method_29049(), this.method_29050());
        context.method_25294(xRightPadding, yPadding, this.method_29049() - xLeftPadding, this.method_29050() - yPadding, -13421773);
        Matrix3x2fStack matrices = context.method_51448();
        if (this.drawProgress()) {
            double progressDisplay = Math.max(0.0, 0.95 - this.progress);
            matrices.pushMatrix();
            double translateX = (double)this.method_29049() * (1.0 - progressDisplay);
            matrices.translate((float)(-translateX), 0.0f, (Matrix3x2f)matrices);
            context.method_25294(xRightPadding, yPadding, this.method_29049(), this.method_29050() - yPadding, ColorUtils.forOpacity(this.progressColor, (float)progressDisplay).getColor());
            matrices.popMatrix();
        }
        this.postBackgroundDrawing(context, startTime);
        int textStartX = (int)this.getTextStartX();
        int n = Math.round((float)this.method_29050() / 2.0f);
        Objects.requireNonNull(textRenderer);
        int textStartY = n - 9 + yPadding;
        context.method_27535(textRenderer, this.titleDisplay, textStartX, textStartY - 1, -1);
        Objects.requireNonNull(textRenderer);
        context.method_27535(textRenderer, this.descDisplay, textStartX, textStartY + 9 + 1, -1);
        this.postTextDrawing(context, startTime);
        matrices.pushMatrix();
        matrices.translate(0.0f, 0.0f, (Matrix3x2f)matrices);
        int lineWidth = Math.min(this.outlineWidth.get(), this.method_29049() - xRightPadding);
        context.method_25294(xRightPadding + 1, yPadding + 1, lineWidth, this.method_29050() - yPadding - 1, this.lineColor.getColor());
        context.method_73198(xRightPadding + 1, yPadding + 1, this.method_29049() - xLeftPadding - 2, this.method_29050() - yPadding - 2, this.lineColor.getColor());
        context.method_73198(xRightPadding, yPadding, this.method_29049() - xLeftPadding, this.method_29050() - yPadding, this.borderColor.getColor());
        matrices.popMatrix();
        this.postDraw(context, startTime);
        context.method_44380();
    }
}

