/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.transforms;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import xyz.nifeather.morph.client.graphics.transforms.easings.Easing;

public abstract class Transform<TValue> {
    public long startTime;
    public long duration;
    public TValue startValue;
    public TValue endValue;
    public Easing easing;
    public boolean aborted;
    public List<Runnable> onFinish;

    protected Transform(long startTime, long duration, TValue startValue, TValue endValue, Easing easing) {
        this.update(startTime, duration, startValue, endValue, easing);
    }

    public void update(long startTime, long duration, TValue startValue, TValue endValue, Easing easing) {
        this.startTime = startTime;
        this.duration = duration;
        this.startValue = startValue;
        this.endValue = endValue;
        this.easing = easing;
    }

    public void abort() {
        this.aborted = true;
    }

    public abstract void applyProgress(double var1);

    public Transform<TValue> then(Runnable runnable) {
        if (this.onFinish == null) {
            this.onFinish = new ObjectArrayList();
        }
        this.onFinish.add(runnable);
        return this;
    }
}

