/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.graphics.transforms.easings.impl;

import xyz.nifeather.morph.client.graphics.transforms.easings.Easing;
import xyz.nifeather.morph.client.graphics.transforms.easings.IEasing;

public class EasingImpl
implements IEasing {
    private final Easing easing;
    private static final double elasticConst = 2.0943951023931953;
    private static final double elasticInOutConst = 1.3962634015954636;
    private static final double backConst1 = 1.70158;
    private static final double backConst2 = 2.70158;
    private static final double backConst3 = 2.5949095;

    public EasingImpl(Easing easing) {
        this.easing = easing;
    }

    @Override
    public double apply(double progress) {
        return switch (this.easing) {
            default -> progress;
            case Easing.InSine -> 1.0 - Math.cos(progress * Math.PI / 2.0);
            case Easing.OutSine -> Math.sin(progress * Math.PI / 2.0);
            case Easing.InOutSine -> -(Math.cos(progress * Math.PI) - 1.0) / 2.0;
            case Easing.InCubic -> progress * progress * progress;
            case Easing.OutCubic -> 1.0 + (progress -= 1.0) * progress * progress;
            case Easing.InOutCubic -> {
                if (progress < 0.5) {
                    yield 4.0 * progress * progress * progress;
                }
                yield 1.0 - Math.pow(-2.0 * progress + 2.0, 3.0) / 2.0;
            }
            case Easing.InQuint -> progress * progress * progress * progress * progress;
            case Easing.OutQuint -> 1.0 + (progress -= 1.0) * progress * progress * progress * progress;
            case Easing.InOutQuint -> {
                if (progress < 0.5) {
                    yield 16.0 * progress * progress * progress * progress * progress;
                }
                yield 1.0 - Math.pow(-2.0 * progress + 2.0, 5.0) / 2.0;
            }
            case Easing.InCirc -> 1.0 - Math.sqrt(1.0 - progress * progress);
            case Easing.OutCirc -> Math.sqrt(1.0 - Math.pow(progress - 1.0, 2.0));
            case Easing.InOutCirc -> {
                if (progress < 0.5) {
                    yield (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * progress, 2.0))) / 2.0;
                }
                yield (Math.sqrt(1.0 - Math.pow(-2.0 * progress + 2.0, 2.0)) + 1.0) / 2.0;
            }
            case Easing.InElastic -> {
                if (progress == 0.0) {
                    yield 0.0;
                }
                if (progress == 1.0) {
                    yield 1.0;
                }
                yield -Math.pow(2.0, 10.0 * progress - 10.0) * Math.sin((progress * 10.0 - 10.75) * 2.0943951023931953);
            }
            case Easing.OutElastic -> {
                if (progress == 0.0) {
                    yield 0.0;
                }
                if (progress == 1.0) {
                    yield 1.0;
                }
                yield Math.pow(2.0, -10.0 * progress) * Math.sin((progress * 10.0 - 0.75) * 2.0943951023931953) + 1.0;
            }
            case Easing.InOutElastic -> {
                if (progress == 0.0) {
                    yield 0.0;
                }
                if (progress == 1.0) {
                    yield 1.0;
                }
                if (progress < 0.5) {
                    yield -(Math.pow(2.0, 20.0 * progress - 10.0) * Math.sin((20.0 * progress - 11.125) * 1.3962634015954636)) / 2.0;
                }
                yield Math.pow(2.0, -20.0 * progress + 10.0) * Math.sin((20.0 * progress - 11.125) * 2.0943951023931953) / 2.0 + 1.0;
            }
            case Easing.InQuad -> progress * progress;
            case Easing.OutQuad -> 1.0 - (1.0 - progress) * (1.0 - progress);
            case Easing.InOutQuad -> {
                if (progress < 0.5) {
                    yield 2.0 * progress * progress;
                }
                yield 1.0 - Math.pow(-2.0 * progress + 2.0, 2.0) / 2.0;
            }
            case Easing.InQuart -> progress * progress * progress * progress;
            case Easing.OutQuart -> 1.0 - (progress -= 1.0) * progress * progress * progress;
            case Easing.InOutQuart -> {
                if (progress < 0.5) {
                    yield 8.0 * progress * progress * progress * progress;
                }
                yield 1.0 - Math.pow(-2.0 * progress + 2.0, 4.0) / 2.0;
            }
            case Easing.InExpo -> {
                if (progress == 0.0) {
                    yield 0.0;
                }
                yield Math.pow(2.0, 10.0 * progress - 10.0);
            }
            case Easing.OutExpo -> {
                if (progress == 1.0) {
                    yield 1.0;
                }
                yield 1.0 - Math.pow(2.0, -10.0 * progress);
            }
            case Easing.InOutExpo -> {
                if (progress == 0.0) {
                    yield 0.0;
                }
                if (progress == 1.0) {
                    yield 1.0;
                }
                if (progress < 0.5) {
                    yield Math.pow(2.0, 20.0 * progress - 10.0) / 2.0;
                }
                yield (2.0 - Math.pow(2.0, -20.0 * progress + 10.0)) / 2.0;
            }
            case Easing.InBack -> 2.70158 * progress * progress * progress - 1.70158 * progress * progress;
            case Easing.OutBack -> 1.0 + 2.70158 * Math.pow(progress - 1.0, 3.0) + 1.70158 * Math.pow(progress - 1.0, 2.0);
            case Easing.InOutBack -> {
                if (progress < 0.5) {
                    yield Math.pow(2.0 * progress, 2.0) * (7.189819 * progress - 2.5949095) / 2.0;
                }
                yield (Math.pow(2.0 * progress - 2.0, 2.0) * (3.5949095 * (progress * 2.0 - 2.0) + 2.5949095) + 2.0) / 2.0;
            }
            case Easing.InBounce -> 1.0 - EasingImpl.calcOutBounce(1.0 - progress);
            case Easing.OutBounce -> EasingImpl.calcOutBounce(progress);
            case Easing.InOutBounce -> progress < 0.5 ? (1.0 - EasingImpl.calcOutBounce(1.0 - 2.0 * progress)) / 2.0 : (1.0 + EasingImpl.calcOutBounce(2.0 * progress - 1.0)) / 2.0;
        };
    }

    private static double calcOutBounce(double progress) {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (progress < 1.0 / d1) {
            return n1 * progress * progress;
        }
        if (progress < 2.0 / d1) {
            return n1 * (progress -= 1.5 / d1) * progress + 0.75;
        }
        if (progress < 2.5 / d1) {
            return n1 * (progress -= 2.25 / d1) * progress + 0.9375;
        }
        return n1 * (progress -= 2.625 / d1) * progress + 0.984375;
    }
}

