/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.network;

import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.network.ServerHandler;
import xyz.nifeather.morph.client.network.handlers.V1ProtocolHandler;
import xyz.nifeather.morph.client.network.handlers.V2ProtocolHandler;
import xyz.nifeather.morph.client.network.handlers.record.CommandHandleResult;
import xyz.nifeather.morph.network.Constants;
import xyz.nifeather.morph.network.commands.C2S.ClientInitializeRecordV3;
import xyz.nifeather.morph.network.commands.S2C.InitializeRespondV3;
import xyz.nifeather.morph.shared.SharedValues;
import xyz.nifeather.morph.shared.payload.V1MorphCommandPayload;
import xyz.nifeather.morph.shared.payload.V1MorphVersionChannelPayload;
import xyz.nifeather.morph.shared.payload.V1V2MorphInitChannelPayload;
import xyz.nifeather.morph.shared.payload.V2MorphCommandPayload;
import xyz.nifeather.morph.shared.payload.V2MorphVersionChannelPayload;

public class LegacyServerHandler {
    private final ServerHandler serverHandler;

    public LegacyServerHandler(ServerHandler serverHandler) {
        this.serverHandler = serverHandler;
        this.initNetwork();
    }

    private void initNetwork() {
        PayloadTypeRegistry.playC2S().register(V2MorphVersionChannelPayload.id, V2MorphVersionChannelPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(V2MorphCommandPayload.id, V2MorphCommandPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(V1V2MorphInitChannelPayload.id, V1V2MorphInitChannelPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(V1MorphVersionChannelPayload.id, V1MorphVersionChannelPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(V1MorphCommandPayload.id, V1MorphCommandPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(V1V2MorphInitChannelPayload.id, this::handleInitV1V2);
        ClientPlayNetworking.registerGlobalReceiver(V2MorphVersionChannelPayload.id, this::handleVersionV2);
        ClientPlayNetworking.registerGlobalReceiver(V2MorphCommandPayload.id, this::handleCommandV2);
        ClientPlayNetworking.registerGlobalReceiver(V1MorphVersionChannelPayload.id, this::handleVersionV1);
        ClientPlayNetworking.registerGlobalReceiver(V1MorphCommandPayload.id, this::handleCommandV1);
    }

    public void sendInitializeV2(List<String> clientFeatures, int clientApi) {
        V2ProtocolHandler.INSTANCE.sendInitializeRequest(new ClientInitializeRecordV3(clientFeatures, clientApi, true));
    }

    private void handleInitV1V2(V1V2MorphInitChannelPayload payload, ClientPlayNetworking.Context context) {
        ServerHandler.logPacket(false, SharedValues.initializeChannelV1V2, payload.message());
        InitializeRespondV3 v2Handle = V2ProtocolHandler.INSTANCE.handleInitializeRespond(payload);
        if (v2Handle.apiVersion() != -1) {
            FeatherMorphClientBootstrap.LOGGER.info("Server is using V2 packets");
            this.serverHandler.setProtocolHandler(V2ProtocolHandler.INSTANCE);
            V2ProtocolHandler.INSTANCE.sendVersion(Constants.ApiLevel.ANIMATION.protocolVersion);
            return;
        }
        FeatherMorphClientBootstrap.LOGGER.info("Server is possibly using V1 packets");
        this.serverHandler.setProtocolHandler(V1ProtocolHandler.INSTANCE);
        V1ProtocolHandler.INSTANCE.sendVersion(Constants.ApiLevel.ANIMATION.protocolVersion);
    }

    private void handleVersionV2(V2MorphVersionChannelPayload payload, ClientPlayNetworking.Context context) {
        ServerHandler.logPacket(false, SharedValues.versionChannelV2, "" + payload.protocolVersion());
        InitializeRespondV3 record = new InitializeRespondV3(List.of("1_21_3_packetbuf"), payload.protocolVersion());
        this.serverHandler.handleServerInitRespond(record);
    }

    private void handleCommandV2(V2MorphCommandPayload payload, ClientPlayNetworking.Context context) {
        ServerHandler.logPacket(false, SharedValues.commandChannelV2, payload.content());
        CommandHandleResult handleResult = V2ProtocolHandler.INSTANCE.handleCommandInput(payload);
        if (!handleResult.success()) {
            return;
        }
        this.serverHandler.handleCommand(handleResult.result());
    }

    private void handleVersionV1(V1MorphVersionChannelPayload payload, ClientPlayNetworking.Context context) {
        ServerHandler.logPacket(false, SharedValues.versionChannelV1, "" + payload.getProtocolVersion());
        InitializeRespondV3 record = new InitializeRespondV3(List.of(), payload.protocolVersion());
        this.serverHandler.handleServerInitRespond(record);
    }

    private void handleCommandV1(V1MorphCommandPayload payload, ClientPlayNetworking.Context context) {
        ServerHandler.logPacket(false, SharedValues.commandChannelV1, payload.content());
        CommandHandleResult handleResult = V1ProtocolHandler.INSTANCE.handleCommandInput(payload);
        if (!handleResult.success()) {
            return;
        }
        this.serverHandler.handleCommand(handleResult.result());
    }
}

