/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.properties;

import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ClientProperty<X> {
    protected final String identifier;
    protected final Function<String, Optional<X>> inputHandle;

    public ClientProperty(String id, Function<String, Optional<X>> inputHandle) {
        this.identifier = id;
        this.inputHandle = inputHandle;
    }

    public String identifier() {
        return this.identifier;
    }

    public Optional<X> handleInput(String input) {
        return this.inputHandle.apply(input);
    }

    @NotNull
    public String handleOutput(X value) throws Exception {
        return "";
    }

    public static <T> ClientProperty<T> of(String id, Function<String, Optional<T>> inputHandle) {
        return new ClientProperty(id, inputHandle);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ClientProperty)) {
            return false;
        }
        ClientProperty other = (ClientProperty)obj;
        return other.identifier.equals(this.identifier) && other.inputHandle.equals(this.inputHandle);
    }
}

