/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.properties;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_12079;
import net.minecraft.class_1304;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import net.minecraft.class_8824;
import net.minecraft.class_9296;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.mixin.accessors.ResolvableProfileAccessor;
import xyz.nifeather.morph.client.network.commands.ClientSetEquipCommand;
import xyz.nifeather.morph.client.properties.DisguiseEquipment;
import xyz.nifeather.morph.client.properties.struct.MorphEquipmentStruct;
import xyz.nifeather.morph.client.properties.struct.MorphProfileProperty;
import xyz.nifeather.morph.client.properties.struct.MorphResolvableProfileStruct;
import xyz.nifeather.morph.client.utilties.NbtHelperCopy;
import xyz.nifeather.morph.client.utilties.NbtUtils;
import xyz.nifeather.morph.network.utils.ProtocolEquipmentSlot;

public class CommonInputHandles {
    public static final Function<String, Optional<Boolean>> BOOLEAN = input -> Optional.of(Boolean.valueOf(input));
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    public static <E extends Enum<?>> Optional<E> readEnum(E[] array, String input) {
        return Arrays.stream(array).filter(e -> e.name().equalsIgnoreCase(input)).findFirst();
    }

    public static <V> Optional<class_6880<V>> readVariantHolder(class_5321<class_2378<V>> registryKey, String input) {
        try {
            class_638 world = class_310.method_1551().field_1687;
            class_2378 registry = world.method_30349().method_30530(registryKey);
            class_2960 resourceLocation = class_2960.method_60654((String)input);
            Object val = registry.method_63535(resourceLocation);
            if (val == null) {
                return Optional.empty();
            }
            return Optional.of(registry.method_47983(val));
        }
        catch (Throwable t) {
            FeatherMorphClientBootstrap.LOGGER.error("Failed to read variant from input '%s' in registry '%s'".formatted(input, registryKey), t);
            return Optional.empty();
        }
    }

    public static Optional<class_1767> readDyeColor(String input) {
        return Arrays.stream(class_1767.values()).filter(c -> c.name().equalsIgnoreCase(input)).findFirst();
    }

    public static Optional<UUID> uuid(String str) {
        try {
            return Optional.of(UUID.fromString(str));
        }
        catch (Throwable t) {
            FeatherMorphClientBootstrap.LOGGER.error("Failed to read UUID from input '%s'".formatted(str), t);
            return Optional.empty();
        }
    }

    public static Optional<class_2561> component(String input) {
        try {
            JsonElement json = (JsonElement)gson.fromJson(input, JsonElement.class);
            class_2561 component = (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
            return Optional.ofNullable(component);
        }
        catch (Throwable ignored) {
            return Optional.of(class_2561.method_43470((String)"<Component deserialization failed>"));
        }
    }

    public static Optional<String> string(String input) {
        return Optional.of(input);
    }

    public static <X> Optional<X> empty(String str) {
        return Optional.empty();
    }

    public static Optional<Integer> intOrEmpty(String str) {
        try {
            return Optional.of(Integer.parseInt(str));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static Optional<class_9296> resolvableProfile(String input) {
        MorphResolvableProfileStruct record = (MorphResolvableProfileStruct)gson.fromJson(input, MorphResolvableProfileStruct.class);
        return record.dynamic() ? CommonInputHandles.resolvableProfileDynamic(record) : CommonInputHandles.resolvableProfileStatic(record);
    }

    public static Optional<class_9296> resolvableProfileDynamic(MorphResolvableProfileStruct record) {
        if (record.id() != null) {
            return Optional.of(class_9296.method_73312((UUID)record.id()));
        }
        if (record.name() != null) {
            return Optional.of(class_9296.method_74889((String)record.name()));
        }
        FeatherMorphClientBootstrap.LOGGER.error("Unable to create dynamic ResolvableProfile: Either UUID and name is NULL");
        return Optional.empty();
    }

    public static Optional<class_9296> resolvableProfileStatic(MorphResolvableProfileStruct record) {
        String skinName = record.name() == null ? "" : record.name();
        UUID profileID = record.id() == null ? UUID.randomUUID() : record.id();
        ImmutableMultimap.Builder propertiesBuilder = ImmutableMultimap.builder();
        for (String propertyJson : record.properties()) {
            MorphProfileProperty struct = (MorphProfileProperty)gson.fromJson(propertyJson, MorphProfileProperty.class);
            propertiesBuilder.put((Object)struct.name(), (Object)new Property(struct.name(), struct.value(), struct.signature()));
        }
        GameProfile profile = new GameProfile(profileID, skinName, new PropertyMap((Multimap)propertiesBuilder.build()));
        class_8685.class_11892 skinPatch = new class_8685.class_11892(CommonInputHandles.readNullableResourceTexture(record.bodyTexture()), CommonInputHandles.readNullableResourceTexture(record.cape()), CommonInputHandles.readNullableResourceTexture(record.elytra()), CommonInputHandles.readEnum((Enum[])class_7920.values(), (String)record.model()));
        class_9296 resolvableProfile = class_9296.method_73307((GameProfile)profile);
        ((ResolvableProfileAccessor)resolvableProfile).setSkinPatch(skinPatch);
        return Optional.of(resolvableProfile);
    }

    private static Optional<class_12079.class_10726> readNullableResourceTexture(@Nullable String input) {
        if (input == null) {
            return Optional.empty();
        }
        class_2960 location = class_2960.method_12829((String)input);
        if (location == null) {
            return Optional.empty();
        }
        return Optional.of(new class_12079.class_10726(location));
    }

    public static Optional<GameProfile> gameProfile(String input) {
        class_2487 compound = NbtUtils.parseSNbt(input);
        return Optional.ofNullable(compound == null ? null : NbtHelperCopy.toGameProfile(compound));
    }

    public static Optional<DisguiseEquipment> equipment(String input) {
        MorphEquipmentStruct struct = (MorphEquipmentStruct)gson.fromJson(input, MorphEquipmentStruct.class);
        int dataVersion = struct.dataVersion();
        DisguiseEquipment.DisguiseEquipmentBuilder builder = DisguiseEquipment.builder(Map.of());
        struct.equipmentData().forEach((slotName, snbt) -> {
            class_1304 slot;
            ProtocolEquipmentSlot protocolSlot = ProtocolEquipmentSlot.valueOf((String)slotName.toUpperCase());
            class_1799 item = ClientSetEquipCommand.jsonToStack(snbt, dataVersion);
            switch (protocolSlot) {
                default: {
                    throw new MatchException(null, null);
                }
                case MAINHAND: {
                    class_1304 class_13042 = class_1304.field_6173;
                    break;
                }
                case OFF_HAND: {
                    class_1304 class_13042 = class_1304.field_6171;
                    break;
                }
                case HELMET: {
                    class_1304 class_13042 = class_1304.field_6169;
                    break;
                }
                case CHESTPLATE: {
                    class_1304 class_13042 = class_1304.field_6174;
                    break;
                }
                case LEGGINGS: {
                    class_1304 class_13042 = class_1304.field_6172;
                    break;
                }
                case BOOTS: {
                    class_1304 class_13042 = slot = class_1304.field_6166;
                }
            }
            if (item != null) {
                builder.forSlot(slot, item);
            }
        });
        return Optional.of(builder.build());
    }
}

