/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.properties;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_10630;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.client.properties.ISupportDiffs;
import xyz.nifeather.morph.client.utilties.ClientItemUtils;

public class DisguiseEquipment
implements ISupportDiffs<DisguiseEquipment> {
    private final Map<class_1304, class_1799> itemStackMap = new ConcurrentHashMap<class_1304, class_1799>();

    public DisguiseEquipment(Map<class_1304, class_1799> items) {
        this.itemStackMap.putAll(items);
    }

    public @Unmodifiable Map<class_1304, class_1799> contents() {
        return ImmutableMap.copyOf(this.itemStackMap);
    }

    @NotNull
    public class_1799 getItem(@NotNull class_1304 slot) {
        return this.itemStackMap.getOrDefault(slot, ClientItemUtils.air);
    }

    @Nullable
    public class_1799 getItemOrNull(@Nullable class_1304 slot) {
        return this.itemStackMap.getOrDefault(slot, null);
    }

    @NotNull
    public class_1799 getItemInMainHand() {
        return this.getItem(class_1304.field_6173);
    }

    @NotNull
    public class_1799 getItemInOffHand() {
        return this.getItem(class_1304.field_6171);
    }

    public class_1799 getHelmet() {
        return this.getItem(class_1304.field_6169);
    }

    public class_1799 getChestplate() {
        return this.getItem(class_1304.field_6174);
    }

    public class_1799 getLeggings() {
        return this.getItem(class_1304.field_6172);
    }

    public class_1799 getBoots() {
        return this.getItem(class_1304.field_6166);
    }

    public boolean filterAll(Function<class_1799, Boolean> filter) {
        boolean pass = true;
        for (Map.Entry<class_1304, class_1799> entry : this.itemStackMap.entrySet()) {
            pass = filter.apply(entry.getValue()) != false && pass;
        }
        return pass;
    }

    public DisguiseEquipmentBuilder cloneForEdit() {
        return DisguiseEquipment.builder(this);
    }

    public static DisguiseEquipmentBuilder builder() {
        return new DisguiseEquipmentBuilder();
    }

    public static DisguiseEquipmentBuilder builder(class_10630 other) {
        return new DisguiseEquipmentBuilder(other);
    }

    public static DisguiseEquipmentBuilder builder(DisguiseEquipment other) {
        return new DisguiseEquipmentBuilder(other.itemStackMap);
    }

    public static DisguiseEquipmentBuilder builder(Map<class_1304, class_1799> map) {
        return new DisguiseEquipmentBuilder(map);
    }

    public static DisguiseEquipment copy(class_10630 other) {
        return DisguiseEquipment.builder(other).build();
    }

    public static DisguiseEquipment empty() {
        return DisguiseEquipment.builder().build();
    }

    @Override
    public DisguiseEquipment diff(DisguiseEquipment other) {
        HashMap<class_1304, class_1799> changes = new HashMap<class_1304, class_1799>();
        for (class_1304 slot : class_1304.values()) {
            class_1799 theirs;
            class_1799 ours = this.getItemOrNull(slot);
            if (Objects.equals(ours, theirs = other.getItemOrNull(slot))) continue;
            changes.put(slot, ClientItemUtils.itemOrAir(theirs));
        }
        return new DisguiseEquipment(changes);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DisguiseEquipment)) {
            return false;
        }
        DisguiseEquipment other = (DisguiseEquipment)obj;
        return other.itemStackMap.equals(this.itemStackMap);
    }

    public static class DisguiseEquipmentBuilder {
        private final Map<class_1304, class_1799> itemMap = new ConcurrentHashMap<class_1304, class_1799>();

        private static Map<class_1304, class_1799> airMap() {
            ConcurrentHashMap<class_1304, class_1799> itemMap = new ConcurrentHashMap<class_1304, class_1799>();
            for (class_1304 value : class_1304.values()) {
                itemMap.put(value, ClientItemUtils.air);
            }
            return itemMap;
        }

        public DisguiseEquipmentBuilder() {
            this(DisguiseEquipmentBuilder.airMap());
        }

        public DisguiseEquipmentBuilder(@NotNull class_10630 entityEquipment) {
            this(Map.of(class_1304.field_6169, ClientItemUtils.itemOrAir(entityEquipment.method_66659(class_1304.field_6169)), class_1304.field_6174, ClientItemUtils.itemOrAir(entityEquipment.method_66659(class_1304.field_6174)), class_1304.field_6172, ClientItemUtils.itemOrAir(entityEquipment.method_66659(class_1304.field_6172)), class_1304.field_6166, ClientItemUtils.itemOrAir(entityEquipment.method_66659(class_1304.field_6166)), class_1304.field_6173, ClientItemUtils.itemOrAir(entityEquipment.method_66659(class_1304.field_6173)), class_1304.field_6171, ClientItemUtils.itemOrAir(entityEquipment.method_66659(class_1304.field_6171))));
        }

        public DisguiseEquipmentBuilder(Map<class_1304, class_1799> existing) {
            this.itemMap.putAll(existing);
        }

        public DisguiseEquipmentBuilder helmet(@NotNull class_1799 stack) {
            return this.forSlot(class_1304.field_6169, stack);
        }

        public DisguiseEquipmentBuilder chestplate(@NotNull class_1799 stack) {
            return this.forSlot(class_1304.field_6174, stack);
        }

        public DisguiseEquipmentBuilder leggings(@NotNull class_1799 stack) {
            return this.forSlot(class_1304.field_6172, stack);
        }

        public DisguiseEquipmentBuilder boots(@NotNull class_1799 stack) {
            return this.forSlot(class_1304.field_6166, stack);
        }

        public DisguiseEquipmentBuilder mainHand(@NotNull class_1799 stack) {
            return this.forSlot(class_1304.field_6173, stack);
        }

        public DisguiseEquipmentBuilder offHand(@NotNull class_1799 stack) {
            return this.forSlot(class_1304.field_6171, stack);
        }

        public DisguiseEquipmentBuilder forSlot(class_1304 slot, @NotNull class_1799 stack) {
            Objects.requireNonNull(stack, "Null item is not accepted");
            this.itemMap.put(slot, stack);
            return this;
        }

        public DisguiseEquipment build() {
            return new DisguiseEquipment(this.itemMap);
        }
    }
}

