/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.properties.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_2379;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.mixin.accessors.ArmorStandEntityAccessor;
import xyz.nifeather.morph.client.properties.ClientProperty;
import xyz.nifeather.morph.client.properties.CommonInputHandles;
import xyz.nifeather.morph.client.properties.impl.EntityPropertyHandler;

public class ArmorStandPropertyHandler
extends EntityPropertyHandler<class_1531> {
    public final ClientProperty<Boolean> SHOW_ARMS = ClientProperty.of("armor_stand/show_arms", CommonInputHandles.BOOLEAN);
    public final ClientProperty<Boolean> HAS_BASE_PLATE = ClientProperty.of("armor_stand/has_base_plate", CommonInputHandles.BOOLEAN);
    public final ClientProperty<Boolean> SMALL = ClientProperty.of("armor_stand/small", CommonInputHandles.BOOLEAN);
    public final ClientProperty<class_2379> HEAD_ROTATION = ClientProperty.of("armor_stand/head_rotation", this::vector3fFromString);
    public final ClientProperty<class_2379> BODY_ROTATION = ClientProperty.of("armor_stand/body_rotation", this::vector3fFromString);
    public final ClientProperty<class_2379> LEFT_ARM_ROTATION = ClientProperty.of("armor_stand/left_arm_rotation", this::vector3fFromString);
    public final ClientProperty<class_2379> RIGHT_ARM_ROTATION = ClientProperty.of("armor_stand/right_arm_rotation", this::vector3fFromString);
    public final ClientProperty<class_2379> LEFT_LEG_ROTATION = ClientProperty.of("armor_stand/left_leg_rotation", this::vector3fFromString);
    public final ClientProperty<class_2379> RIGHT_LEG_ROTATION = ClientProperty.of("armor_stand/right_leg_rotation", this::vector3fFromString);
    private final Gson gson = new GsonBuilder().create();

    public ArmorStandPropertyHandler() {
        this.register(this.SHOW_ARMS, this.HAS_BASE_PLATE, this.SMALL);
        this.register(this.HEAD_ROTATION, this.BODY_ROTATION, this.LEFT_ARM_ROTATION, this.RIGHT_ARM_ROTATION, this.LEFT_LEG_ROTATION, this.RIGHT_LEG_ROTATION);
    }

    private Optional<class_2379> vector3fFromString(String input) {
        try {
            List gsonList = (List)this.gson.fromJson(input, List.class);
            List<Float> castList = gsonList.stream().map(o -> Float.valueOf(Float.parseFloat(String.valueOf(o)))).toList();
            if (castList.size() != 3) {
                throw new RuntimeException("Malformed float array: Invalid array size");
            }
            if (castList.stream().anyMatch(f -> !Float.isFinite(f.floatValue()))) {
                throw new RuntimeException("Malformed float array: contains Non-finite values");
            }
            return Optional.of(new class_2379(castList.get(0).floatValue(), castList.get(1).floatValue(), castList.get(2).floatValue()));
        }
        catch (Throwable t) {
            FeatherMorphClientBootstrap.LOGGER.error("Failed to map string input to Vector3f! Input is '%s'".formatted(input), t);
            return Optional.empty();
        }
    }

    @Override
    public Optional<class_1531> tryCast(class_1297 entity) {
        class_1531 armorStand;
        return Optional.ofNullable(entity instanceof class_1531 ? (armorStand = (class_1531)entity) : null);
    }

    @Override
    protected <X> void applyToEntity(class_1531 entity, ClientProperty<X> property, X value) {
        super.applyToEntity(entity, property, value);
        switch (property.identifier()) {
            case "armor_stand/show_arms": {
                entity.method_6913(((Boolean)value).booleanValue());
                break;
            }
            case "armor_stand/has_base_plate": {
                entity.method_6907((Boolean)value == false);
                break;
            }
            case "armor_stand/small": {
                ((ArmorStandEntityAccessor)entity).callSetSmall((Boolean)value);
                break;
            }
            case "armor_stand/head_rotation": {
                entity.method_6919((class_2379)value);
                break;
            }
            case "armor_stand/body_rotation": {
                entity.method_6927((class_2379)value);
                break;
            }
            case "armor_stand/left_arm_rotation": {
                entity.method_6910((class_2379)value);
                break;
            }
            case "armor_stand/right_arm_rotation": {
                entity.method_6925((class_2379)value);
                break;
            }
            case "armor_stand/left_leg_rotation": {
                entity.method_6909((class_2379)value);
                break;
            }
            case "armor_stand/right_leg_rotation": {
                entity.method_6926((class_2379)value);
            }
        }
    }
}

