/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.properties.impl;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import xyz.nifeather.morph.client.entities.IMorphLivingEntity;
import xyz.nifeather.morph.client.entities.MorphLocalPlayer;
import xyz.nifeather.morph.client.properties.ClientProperty;
import xyz.nifeather.morph.client.properties.CommonInputHandles;
import xyz.nifeather.morph.client.properties.impl.EntityPropertyHandler;
import xyz.nifeather.morph.client.utilties.MathUtils;

public class PlayerPropertyHandler
extends EntityPropertyHandler<class_1657> {
    private final ClientProperty<class_1306> MAIN_HAND = ClientProperty.of("player/main_hand", this::humanoidArmFromString);
    private final ClientProperty<Integer> STUCKED_ARROWS = ClientProperty.of("entity/stucked_arrows", CommonInputHandles::intOrEmpty);
    private final ClientProperty<GameProfile> SKIN = ClientProperty.of("player/skin", CommonInputHandles::gameProfile);

    private Optional<class_1306> humanoidArmFromString(String input) {
        if (input.equals("notset")) {
            return Optional.empty();
        }
        return Optional.of(input.equals("left") ? class_1306.field_6182 : class_1306.field_6183);
    }

    public PlayerPropertyHandler() {
        this.register(this.MAIN_HAND, this.STUCKED_ARROWS, this.SKIN);
    }

    @Override
    public Optional<class_1657> tryCast(class_1297 entity) {
        Optional<class_1657> optional;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            optional = Optional.of(player);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    protected <X> void applyToEntity(class_1657 entity, ClientProperty<X> property, X value) {
        super.applyToEntity(entity, property, value);
        if (!(entity instanceof MorphLocalPlayer)) {
            return;
        }
        MorphLocalPlayer morphLocalPlayer = (MorphLocalPlayer)entity;
        if (!(entity instanceof IMorphLivingEntity)) {
            return;
        }
        IMorphLivingEntity customLiving = (IMorphLivingEntity)entity;
        switch (property.identifier()) {
            case "player/main_hand": {
                morphLocalPlayer.setOverrideMainArm((class_1306)value);
                break;
            }
            case "entity/stucked_arrows": {
                customLiving.morphclient$setOverrideArrowCount(MathUtils.clamp(0, 100, (Integer)value));
                break;
            }
            case "player/skin": {
                morphLocalPlayer.updateSkin((GameProfile)value);
            }
        }
    }
}

