/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.screens.disguise;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5611;
import net.minecraft.class_8027;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import xiamomc.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.client.ClientMorphManager;
import xyz.nifeather.morph.client.EntityCache;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.config.ModConfigData;
import xyz.nifeather.morph.client.graphics.Anchor;
import xyz.nifeather.morph.client.graphics.Axes;
import xyz.nifeather.morph.client.graphics.DrawableSprite;
import xyz.nifeather.morph.client.graphics.DrawableText;
import xyz.nifeather.morph.client.graphics.EntityDisplay;
import xyz.nifeather.morph.client.graphics.IMDrawable;
import xyz.nifeather.morph.client.graphics.MButtonWidget;
import xyz.nifeather.morph.client.graphics.MDrawable;
import xyz.nifeather.morph.client.graphics.MarginPadding;
import xyz.nifeather.morph.client.graphics.color.Colors;
import xyz.nifeather.morph.client.graphics.color.MaterialColors;
import xyz.nifeather.morph.client.graphics.container.BasicContainer;
import xyz.nifeather.morph.client.graphics.container.Container;
import xyz.nifeather.morph.client.graphics.container.DrawableButtonWrapper;
import xyz.nifeather.morph.client.graphics.container.TextFieldWidgetWrapper;
import xyz.nifeather.morph.client.graphics.transforms.Recorder;
import xyz.nifeather.morph.client.network.ServerHandler;
import xyz.nifeather.morph.client.screens.FeatherScreen;
import xyz.nifeather.morph.client.screens.WaitingForServerScreen;
import xyz.nifeather.morph.client.screens.disguise.DisguiseList;
import xyz.nifeather.morph.client.screens.disguise.EntityDisplayEntry;
import xyz.nifeather.morph.client.screens.disguise.class_114514;
import xyz.nifeather.morph.client.screens.disguise.preview.DisguisePreviewDisplay;

public class DisguiseScreen
extends FeatherScreen {
    @Nullable
    private EntityDisplay playerDisplay;
    private final Bindable<String> selectedIdentifier = new Bindable<String>("morph:unmorph");
    private final Bindable<Boolean> serverReady = new Bindable<Boolean>(false);
    private final Bindable<String> currentIdentifier = new Bindable<String>("morph:unmorph");
    private final TextFieldWidgetWrapper textBox;
    private final ClientMorphManager manager;
    private final ServerHandler serverHandler;
    private final Container topTextContainer = new Container();
    private final Container bottomTextContainer = new Container();
    private final DisguiseList disguiseList = new DisguiseList(class_310.method_1551(), 200, 0, 20, 0, 22);
    private final DrawableText titleText = new DrawableText((class_2561)class_2561.method_43471((String)"gui.morphclient.select_disguise"));
    private final DrawableText selectedIdentifierText = new DrawableText();
    private final DrawableText serverAPIText = new DrawableText();
    private final DrawableText handlerText = new DrawableText();
    private final int fontMargin = 4;
    private final Bindable<Integer> topHeight = new Bindable<Integer>(0);
    private final Bindable<Integer> bottomHeight = new Bindable<Integer>(0);
    private final Recorder<Float> backgroundDim = new Recorder<Float>(Float.valueOf(0.0f));
    private final class_114514 field_1919810 = new class_114514(this);
    private List<EntityDisplayEntry> fullList;

    public DisguiseScreen() {
        super((class_2561)class_2561.method_43470((String)"\u9009\u62e9\u754c\u9762"));
        FeatherMorphClientBootstrap morphClient = FeatherMorphClientBootstrap.getInstance();
        this.serverHandler = morphClient.serverHandler;
        this.manager = morphClient.morphManager;
        this.manager.onMorphGrant(c -> {
            if (!this.isCurrent()) {
                return false;
            }
            morphClient.schedule(() -> {
                List<String> availableMorphs = this.manager.getAvailableMorphs();
                c.forEach(s -> this.disguiseList.method_25396().add(availableMorphs.indexOf(s) + 1, new EntityDisplayEntry((String)s)));
            });
            return true;
        });
        this.manager.onMorphRevoke(c -> {
            if (!this.isCurrent()) {
                return false;
            }
            morphClient.schedule(() -> c.forEach(s -> this.disguiseList.method_25396().removeIf(w -> w.getIdentifierString().equals(s))));
            return true;
        });
        this.selectedIdentifier.bindTo(this.manager.selectedIdentifier);
        this.selectedIdentifier.onValueChanged((o, n) -> this.refreshEntityPreview((String)n), true);
        this.serverReady.bindTo(this.serverHandler.serverReady);
        this.serverReady.onValueChanged((o, n) -> FeatherMorphClientBootstrap.getInstance().schedule(() -> {
            if (this.isCurrent() && !n.booleanValue()) {
                this.push(new WaitingForServerScreen(new DisguiseScreen()));
            }
        }), true);
        this.currentIdentifier.bindTo(this.manager.currentIdentifier);
        this.currentIdentifier.onValueChanged((o, n) -> {
            Object display = null;
            if (n != null) {
                class_1309 cachedEntity = EntityCache.getGlobalCache().getEntity((String)n, null);
                display = cachedEntity != null ? cachedEntity.method_5477() : class_2561.method_43470((String)n);
            }
            class_5250 text = class_2561.method_54159((String)"gui.morphclient.current_disguise", (Object[])new Object[]{display == null ? class_2561.method_43471((String)"gui.none") : display});
            this.selectedIdentifierText.setText((class_2561)text);
            this.refreshEntityPreview((String)n);
        }, true);
        this.titleText.setWidth(200.0f);
        this.titleText.setHeight(20.0f);
        this.textBox = new TextFieldWidgetWrapper(new class_342(class_310.method_1551().field_1772, 120, 17, (class_2561)class_2561.method_43470((String)"Search disguise...")));
        this.textBox.setChangedListener(this::onTextBoxText);
        this.textBox.setAnchor(Anchor.TopRight);
        this.textBox.setMargin(new MarginPadding(5.0f));
    }

    private void refreshEntityPreview(String newId) {
        String identifier;
        String string = newId == null ? (this.currentIdentifier.get() == null ? "morph:unmorph" : this.currentIdentifier.get()) : (identifier = newId);
        if (this.playerDisplay != null) {
            this.remove(this.playerDisplay);
            this.playerDisplay.dispose();
            this.playerDisplay = null;
        }
        DisguisePreviewDisplay newDisplay = new DisguisePreviewDisplay(identifier, true, EntityDisplay.InitialSetupMethod.SYNC);
        newDisplay.setMasking(true);
        newDisplay.setParentScreenSpace(new class_8030(class_8029.method_48246((class_8027)class_8027.field_41822, (int)0, (int)0), this.field_22789, this.field_22790));
        newDisplay.setRelativeSizeAxes(Axes.Both);
        newDisplay.setAnchor(Anchor.CentreRight);
        newDisplay.setSize(new class_5611(0.4f, 0.7f));
        this.playerDisplay = newDisplay;
        this.add(newDisplay);
    }

    @Override
    protected void onScreenExit(class_437 next) {
        super.onScreenExit(next);
        if (next == null) {
            if (this.fullList != null) {
                this.disguiseList.clearChildren(false);
                this.disguiseList.addChildrenRange(this.fullList);
                this.fullList = null;
            }
            this.disguiseList.clearChildren();
            this.serverReady.unBindFromTarget();
            this.selectedIdentifier.unBindFromTarget();
            this.currentIdentifier.unBindFromTarget();
        }
    }

    public float getBackgroundDim() {
        return this.backgroundDim.get().floatValue();
    }

    @Override
    protected void onScreenEnter(class_437 last) {
        super.onScreenEnter(last);
        this.resizeDisguiseList();
        if (last == null || last instanceof WaitingForServerScreen) {
            this.disguiseList.addChild(new EntityDisplayEntry("morph:unmorph"));
            this.manager.getAvailableMorphs().forEach(s -> this.disguiseList.addChild(new EntityDisplayEntry((String)s)));
            this.scrollToCurrentOrLast(false);
        }
        if (last instanceof WaitingForServerScreen) {
            WaitingForServerScreen waitingForServerScreen = (WaitingForServerScreen)last;
            this.backgroundDim.set(Float.valueOf(waitingForServerScreen.getCurrentDim()));
        }
        Objects.requireNonNull(this.field_22793);
        int headerTargetHeight = 9 * 2 + 8;
        this.topHeight.set(headerTargetHeight);
        this.bottomHeight.set(30);
        this.backgroundDim.set(Float.valueOf(0.3f));
        this.topTextContainer.addRange(new MDrawable[]{this.titleText, this.selectedIdentifierText});
        this.topTextContainer.setPadding(new MarginPadding(0.0f, 0.0f, 3.0f, 0.0f));
        this.bottomTextContainer.add(this.handlerText);
        this.bottomTextContainer.add(this.serverAPIText);
        this.bottomTextContainer.setAnchor(Anchor.BottomLeft);
        this.bottomTextContainer.setPadding(new MarginPadding(0.0f, 0.0f, 5.0f, 0.0f));
        int containerHeight = 30;
        this.bottomTextContainer.setHeight(containerHeight);
        this.topTextContainer.setHeight(containerHeight);
        BasicContainer buttonContainer = new BasicContainer();
        DrawableButtonWrapper closeButton = this.createDrawableWrapper(0, 0, 112, 20, (class_2561)class_2561.method_43471((String)"gui.back"), button -> this.method_25419());
        DrawableButtonWrapper configMenuButton = this.createDrawableWrapper(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)"C"), button -> {
            class_437 screen = FeatherMorphClientBootstrap.getInstance().getFactory(this).build();
            class_310.method_1551().method_1507(screen);
        });
        DrawableButtonWrapper selfVisibleToggle = this.createToggleSelfButton();
        selfVisibleToggle.setX(Math.round(configMenuButton.getWidth() + 5.0f));
        closeButton.setX(selfVisibleToggle.getX() + (int)selfVisibleToggle.getWidth() + 5);
        buttonContainer.addRange(new MDrawable[]{closeButton, selfVisibleToggle, configMenuButton});
        buttonContainer.setAnchor(Anchor.BottomRight);
        buttonContainer.setSize(new class_5611((float)closeButton.getX() + closeButton.getWidth(), 20.0f));
        buttonContainer.setMargin(new MarginPadding(5.0f));
        DrawableSprite topHeader = new DrawableSprite(class_437.field_49897, false);
        topHeader.setY(this.topHeight.get() - 2);
        topHeader.setSize(new class_5611(1.0f, 2.0f));
        topHeader.setRelativeSizeAxes(Axes.X);
        DrawableSprite bottomFooter = new DrawableSprite(class_437.field_49898, false);
        bottomFooter.setAnchor(Anchor.BottomLeft);
        bottomFooter.setY(-this.bottomHeight.get().intValue() + 1);
        bottomFooter.setSize(new class_5611(1.0f, 2.0f));
        bottomFooter.setRelativeSizeAxes(Axes.X);
        int screenX = 30;
        this.topTextContainer.setX(screenX);
        this.bottomTextContainer.setX(screenX);
        this.textBox.setX(-25);
        buttonContainer.setX(-25);
        Objects.requireNonNull(this.field_22793);
        int fontHeight = 9;
        this.serverAPIText.setMargin(new MarginPadding(0.0f, 0.0f, fontHeight + 2, 0.0f));
        this.serverAPIText.setColor(-1711276033);
        this.handlerText.setColor(-1711276033);
        this.selectedIdentifierText.setMargin(new MarginPadding(0.0f, 0.0f, fontHeight + 2, 0.0f));
        this.handlerText.setText("H: %s".formatted(this.serverHandler.protocolHandler().getClass().getSimpleName()));
        class_5250 apiText = class_2561.method_43470((String)"C %s :: S %s".formatted(this.serverHandler.getImplmentingApiVersion(), this.serverHandler.getServerApiVersion()));
        if (!this.serverHandler.serverApiMatch()) {
            apiText = apiText.method_27695(new class_124[]{class_124.field_1065, class_124.field_1067});
            this.serverAPIText.setTooltip((class_2561)class_2561.method_43471((String)"gui.morphclient.version_mismatch"));
            this.serverAPIText.setColor(-1);
        }
        this.serverAPIText.setText((class_2561)apiText);
        this.addRange(new IMDrawable[]{this.disguiseList, this.topTextContainer, this.bottomTextContainer, buttonContainer, this.textBox, topHeader, bottomFooter});
    }

    private DrawableButtonWrapper createToggleSelfButton() {
        Bindable<Boolean> bindable = this.manager.selfVisibleEnabled;
        Function<Boolean, class_2561> textFunction = val -> {
            class_5251 color = val != false ? class_5251.method_27718((class_124)class_124.field_1060) : class_5251.method_27718((class_124)class_124.field_1061);
            return class_2561.method_43470((String)(val != false ? "I" : "O")).method_10862(class_2583.field_24360.method_27703(color));
        };
        MButtonWidget button = this.buildButtonWidget(0, 0, 20, 20, textFunction.apply(bindable.get()), btn -> {
            boolean val = (Boolean)bindable.get() == false;
            bindable.set(val);
            FeatherMorphClientBootstrap modInstance = FeatherMorphClientBootstrap.getInstance();
            ModConfigData config = modInstance.getModConfigData();
            modInstance.updateClientView(config.allowClientView, val);
            btn.method_25355((class_2561)textFunction.apply(val));
        });
        return new DrawableButtonWrapper(button);
    }

    private void resizeDisguiseList() {
        Objects.requireNonNull(this.field_22793);
        int headerTargetHeight = 9 * 2 + 8;
        int footerTargetHeight = 30;
        int disguiseListWidth = Math.round((float)this.field_22789 * 0.6f);
        this.disguiseList.method_25358(disguiseListWidth);
        this.disguiseList.method_53533(this.field_22790 - headerTargetHeight - footerTargetHeight);
        this.disguiseList.method_46419(headerTargetHeight);
    }

    @Override
    protected void onScreenResize() {
        assert (this.field_22787 != null);
        this.resizeDisguiseList();
        this.bottomTextContainer.invalidatePosition();
        this.topTextContainer.invalidatePosition();
    }

    private void scrollToCurrentOrLast(boolean scrollToLastIfNoCurrent) {
        EntityDisplayEntry widget;
        List filter = this.disguiseList.method_25396();
        String current = this.manager.currentIdentifier.get();
        if (current != null && (widget = (EntityDisplayEntry)this.disguiseList.method_25396().stream().filter(w -> current.equals(w.getIdentifierString())).findFirst().orElse(null)) != null) {
            this.disguiseList.scrollTo(widget);
            return;
        }
        if (!scrollToLastIfNoCurrent) {
            return;
        }
        EntityDisplayEntry last = null;
        if (!filter.isEmpty()) {
            last = (EntityDisplayEntry)filter.getLast();
        }
        if (last != null) {
            this.disguiseList.scrollTo(last);
        }
    }

    private void onTextBoxText(String str) {
        if (!str.startsWith("!")) {
            this.textBox.widget.method_1868(Colors.WHITE.getColor());
            this.applySearch(str);
        } else {
            this.textBox.widget.method_1868(MaterialColors.Amber500.getColor());
            this.field_1919810.apply(str);
        }
    }

    private void applySearch(String str) {
        if (str.isEmpty()) {
            if (this.fullList != null) {
                this.disguiseList.clearChildren(false);
                this.disguiseList.addChildrenRange(this.fullList);
                this.fullList = null;
            }
            return;
        }
        if (this.fullList == null) {
            this.fullList = new ObjectArrayList((Collection)this.disguiseList.method_25396());
        }
        String finalStr = str.toLowerCase().trim();
        List<EntityDisplayEntry> filter = this.fullList.stream().filter(w -> w.getIdentifier().method_12832().contains(finalStr) || w.getEntityName().contains(finalStr)).toList();
        this.disguiseList.clearChildren(false);
        this.disguiseList.addChildrenRange(filter);
        if (this.disguiseList.method_44387() > (double)this.disguiseList.method_44390()) {
            this.scrollToCurrentOrLast(true);
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_25395(this.textBox);
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        this.disguiseList.setMouseDown(true);
        return super.method_25402(mouseButtonEvent, bl);
    }

    public boolean method_25406(class_11909 mouseButtonEvent) {
        this.disguiseList.setMouseDown(false);
        return super.method_25406(mouseButtonEvent);
    }

    public void method_16014(double mouseX, double mouseY) {
        this.disguiseList.method_16014(mouseX, mouseY);
        super.method_16014(mouseX, mouseY);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        context.method_25290(class_10799.field_56883, class_437.field_49511, 0, 0, 0.0f, (float)(-this.topHeight.get().intValue()), this.field_22789, this.topHeight.get().intValue(), 32, 32);
        context.method_25290(class_10799.field_56883, class_437.field_49511, 0, this.field_22790 - this.bottomHeight.get(), 0.0f, 0.0f, this.field_22789, this.field_22790, 32, 32);
    }
}

