/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.screens.disguise;

import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5348;
import net.minecraft.class_5611;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.slf4j.LoggerFactory;
import xiamomc.pluginbase.Annotations.Resolved;
import xiamomc.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.client.ClientMorphManager;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.graphics.Anchor;
import xyz.nifeather.morph.client.graphics.DrawableSprite;
import xyz.nifeather.morph.client.graphics.EntityDisplay;
import xyz.nifeather.morph.client.graphics.container.Container;
import xyz.nifeather.morph.client.graphics.transforms.easings.Easing;

public class DisplayWidget
extends MorphClientObject
implements class_6379,
class_4068,
class_364 {
    private final String identifier;
    private String entityName;
    private class_2561 display;
    int screenSpaceY = 0;
    int screenSpaceX = 0;
    private int width = 0;
    private int height = 0;
    private final boolean isPlayerItSelf;
    @Resolved(shouldSolveImmediately=true)
    private ClientMorphManager manager;
    private Bindable<String> currentIdentifier = new Bindable();
    private Bindable<String> selectedIdentifier = new Bindable();
    public static final class_2960 buttonTextureSelected = class_2960.method_60655((String)"morphclient", (String)"disguise_selection/disguise_select_selected");
    public static final class_2960 buttonTextureCurrent = class_2960.method_60655((String)"morphclient", (String)"disguise_selection/disguise_select_current");
    public static final class_2960 buttonTextureWaiting = class_2960.method_60655((String)"morphclient", (String)"disguise_selection/disguise_select_waiting");
    public static final class_2960 buttonTextureOverlay = class_2960.method_60655((String)"morphclient", (String)"disguise_selection/disguise_select_overlay_hover");
    private final DrawableSprite spriteSelected;
    private final DrawableSprite spriteCurrent;
    private final DrawableSprite spriteWaiting;
    private final DrawableSprite spriteHover;
    private final EntityDisplay entityDisplay;
    private final Container displayContainer = new Container();
    private final Container backgroundContainer = new Container();
    private static final class_327 textRenderer = class_310.method_1551().field_1772;
    private boolean hovered;
    @NotNull
    private final Bindable<ActivationState> activationState = new Bindable<ActivationState>(ActivationState.NONE);
    private boolean focused = false;

    @Nullable
    public String entityName() {
        return this.entityName;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public void setWidth(int w) {
        this.width = w;
        this.updateBackgroundSize(false);
    }

    public void setHeight(int h) {
        this.height = h;
        this.updateBackgroundSize(false);
    }

    public void dispose() {
        this.currentIdentifier.dispose();
        this.currentIdentifier = null;
        this.selectedIdentifier.dispose();
        this.selectedIdentifier = null;
    }

    public DisplayWidget(int screenSpaceX, int screenSpaceY, int width, int height, String identifier) {
        this.identifier = identifier;
        this.isPlayerItSelf = identifier.equals("morph:unmorph");
        this.screenSpaceX = screenSpaceX;
        this.screenSpaceY = screenSpaceY;
        this.width = width;
        this.height = height;
        this.selectedIdentifier.bindTo(this.manager.selectedIdentifier);
        this.currentIdentifier.bindTo(this.manager.currentIdentifier);
        this.entityDisplay = new EntityDisplay(identifier, false, EntityDisplay.InitialSetupMethod.ASYNC);
        this.entityDisplay.postEntitySetup = () -> {
            this.entityName = this.entityDisplay.getDisplayName().getString();
            this.trimDisplay(this.entityDisplay.getDisplayName());
        };
        this.displayContainer.setSize(new class_5611(48.0f, 18.0f));
        this.entityDisplay.setSize(new class_5611(18.0f, 18.0f));
        this.displayContainer.add(this.entityDisplay);
        this.spriteSelected = new DrawableSprite(buttonTextureSelected);
        this.backgroundContainer.add(this.spriteSelected);
        this.spriteCurrent = new DrawableSprite(buttonTextureCurrent);
        this.backgroundContainer.add(this.spriteCurrent);
        this.spriteWaiting = new DrawableSprite(buttonTextureWaiting);
        this.backgroundContainer.add(this.spriteWaiting);
        this.spriteHover = new DrawableSprite(buttonTextureOverlay);
        this.backgroundContainer.add(this.spriteHover);
        this.updateBackgroundSize(true);
        this.display = this.entityDisplay.getDisplayName();
        this.entityDisplay.setAnchor(Anchor.BottomCentre);
        if (identifier.equals(this.currentIdentifier.get()) || this.isPlayerItSelf) {
            this.entityDisplay.doSetupImmedately();
        }
        this.activationState.onValueChanged((oldVal, newVal) -> {
            if (newVal == null) {
                return;
            }
            this.spriteCurrent.fadeOut(300L, Easing.OutExpo);
            this.spriteSelected.fadeOut(300L, Easing.OutExpo);
            this.spriteWaiting.fadeOut(300L, Easing.OutExpo);
            switch (newVal.ordinal()) {
                case 1: {
                    this.selectedIdentifier.set(this.identifier);
                    this.spriteSelected.fadeIn(300L, Easing.OutExpo);
                    break;
                }
                case 3: {
                    this.selectedIdentifier.set(this.identifier);
                    this.spriteCurrent.fadeIn(300L, Easing.OutExpo);
                    break;
                }
                case 2: {
                    this.spriteWaiting.fadeIn(300L, Easing.OutExpo);
                    break;
                }
            }
        });
        this.selectedIdentifier.onValueChanged((o, n) -> {
            ActivationState actState = this.activationState.get();
            if (!identifier.equals(n) && actState != ActivationState.CURRENT && actState != ActivationState.WAITING) {
                this.activationState.set(ActivationState.NONE);
            }
        }, true);
        this.currentIdentifier.onValueChanged((o, n) -> {
            n = n == null ? "morph:unmorph" : n;
            o = o == null ? "morph:unmorph" : o;
            boolean isCurrent = identifier.equals(n);
            boolean prevIsCurrent = identifier.equals(o);
            if (prevIsCurrent) {
                this.entityDisplay.resetEntity();
            }
            this.activationState.set(isCurrent ? ActivationState.CURRENT : (prevIsCurrent ? ActivationState.NONE : this.activationState.get()));
        }, true);
    }

    private void updateBackgroundSize(boolean makeHidden) {
        class_5611 backgroundSize = new class_5611((float)this.width, (float)this.height);
        this.backgroundContainer.setSize(backgroundSize);
        this.backgroundContainer.method_25396().forEach(d -> {
            if (makeHidden) {
                d.setAlpha(0.0f);
            }
            d.setSize(backgroundSize);
        });
    }

    private void trimDisplay(class_2561 text) {
        this.display = text;
        this.addSchedule(() -> {
            boolean trimmed;
            double targetMultiplier = this.entityDisplay.getDisplayingEntity() == null ? 0.85 : 0.7;
            class_5348 toDisplay = textRenderer.method_1714((class_5348)text, (int)Math.round((double)this.width * targetMultiplier));
            boolean bl = trimmed = !toDisplay.getString().equals(text.getString());
            if (trimmed) {
                this.display = class_2561.method_43470((String)(toDisplay.getString() + "..."));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        boolean lastHovered = this.hovered;
        boolean bl = this.hovered = mouseX < this.screenSpaceX + this.width && mouseX > this.screenSpaceX && mouseY < this.screenSpaceY + this.height && mouseY > this.screenSpaceY;
        if (lastHovered != this.hovered) {
            if (this.hovered) {
                this.spriteHover.fadeIn(300L, Easing.OutExpo);
            } else {
                this.spriteHover.fadeOut(300L, Easing.OutExpo);
            }
        }
        Matrix3x2fStack matrices = context.method_51448();
        try {
            ActivationState actState;
            matrices.pushMatrix();
            if (this.hovered) {
                matrices.translate(0.0f, 0.0f, (Matrix3x2f)matrices);
            }
            if ((actState = this.activationState.get()) == ActivationState.CURRENT) {
                matrices.translate(0.0f, 0.0f, (Matrix3x2f)matrices);
            }
            this.backgroundContainer.setX(this.screenSpaceX);
            this.backgroundContainer.setY(this.screenSpaceY);
            this.backgroundContainer.method_25394(context, mouseX, mouseY, delta);
            matrices.translate(0.0f, 0.0f, (Matrix3x2f)matrices);
            int x = this.screenSpaceX + this.width - 24 - 15;
            int y = this.screenSpaceY + 1;
            int mX = Math.round((float)this.screenSpaceX + (float)this.width * 0.75f);
            int mY = this.screenSpaceY + this.height / 2;
            this.displayContainer.setX(x);
            this.displayContainer.setY(y);
            this.displayContainer.setMasking(!this.hovered);
            this.displayContainer.method_25394(context, mX, mY, 0.0f);
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"morph").error(e.getMessage());
            e.printStackTrace();
        }
        finally {
            Objects.requireNonNull(textRenderer);
            context.method_27535(textRenderer, this.display, this.screenSpaceX + 10, this.screenSpaceY + Math.round((float)(this.height - 9) / 2.0f), -1);
            matrices.popMatrix();
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.isHovered();
    }

    public class_6379.class_6380 method_37018() {
        return this.activationState.get() == ActivationState.CURRENT ? class_6379.class_6380.field_33786 : class_6379.class_6380.field_33784;
    }

    private void playClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        int button = mouseButtonEvent.method_74245();
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        if (!this.isHovered()) {
            return false;
        }
        if (button == 0) {
            ActivationState lastFocusType = this.activationState.get();
            switch (lastFocusType.ordinal()) {
                case 1: {
                    this.activationState.set(this.isPlayerItSelf && this.manager.currentIdentifier.get() == null ? ActivationState.NONE : ActivationState.WAITING);
                    FeatherMorphClientBootstrap.getInstance().requestDisguise(this.identifier, Map.of());
                    this.playClickSound();
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    this.activationState.set(ActivationState.SELECTED);
                    this.playClickSound();
                }
            }
            return true;
        }
        if (button == 1) {
            ActivationState actState = this.activationState.get();
            if (actState == ActivationState.SELECTED) {
                this.manager.selectedIdentifier.set(null);
                this.playClickSound();
            } else if (actState == ActivationState.CURRENT && !this.isPlayerItSelf) {
                this.activationState.set(ActivationState.WAITING);
                FeatherMorphClientBootstrap.getInstance().requestDisguise(null, Map.of());
                this.playClickSound();
            }
        }
        return super.method_25402(mouseButtonEvent, bl);
    }

    private boolean isHovered() {
        return this.hovered;
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public void method_37020(class_6382 builder) {
        builder.method_37031().method_37034(class_6381.field_33790, (class_2561)class_2561.method_43470((String)"Disguise of").method_10852(this.display));
    }

    private static enum ActivationState {
        NONE,
        SELECTED,
        WAITING,
        CURRENT;

    }
}

