/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.storage;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.client.MorphClientObject;

public class ClientDirectoryStorage
extends MorphClientObject {
    private final String directoryBaseName;
    private final URI pluginStorageBaseUri;
    private final URI absoluteDirectoryPath;
    private boolean initializeFailed = false;
    private final String separator = "/";

    public boolean initializeFailed() {
        return this.initializeFailed;
    }

    private URI getAbsoulteURI(String path) {
        return new File(path).getAbsoluteFile().toURI();
    }

    public ClientDirectoryStorage(String directoryBaseName) {
        this.directoryBaseName = directoryBaseName;
        this.pluginStorageBaseUri = this.plugin.getDataFolder().getAbsoluteFile().toURI();
        this.absoluteDirectoryPath = this.getAbsoulteURI(this.pluginStorageBaseUri.getPath() + "/" + directoryBaseName);
        File dirFile = new File(this.absoluteDirectoryPath);
        if (!dirFile.exists()) {
            try {
                boolean success = dirFile.mkdirs();
                if (!success) {
                    this.logger.error("Unable to create directory '%s': Unknown error".formatted(directoryBaseName));
                }
                this.initializeFailed = true;
            }
            catch (Throwable t) {
                this.logger.error("Unable to create directory '%s' for logging: %s".formatted(directoryBaseName, t.getLocalizedMessage()));
                t.printStackTrace();
                this.initializeFailed = true;
            }
        }
        this.initializeFailed = false;
    }

    public File getRootDirectory() {
        return Path.of(this.absoluteDirectoryPath).toFile();
    }

    public File[] getFiles(String pattern) {
        return this.getFilesUnder(this.getRootDirectory(), f -> f.isFile() && f.getName().matches(pattern)).toArray(new File[0]);
    }

    @NotNull
    public List<File> getFilesUnder(File rootDirectory, @Nullable FileFilter filter) {
        if (!rootDirectory.isDirectory()) {
            return new ObjectArrayList();
        }
        ObjectArrayList fileList = new ObjectArrayList();
        File[] subFiles = rootDirectory.listFiles(file -> true);
        if (subFiles == null) {
            return new ObjectArrayList();
        }
        for (File file2 : subFiles) {
            if (file2.isDirectory()) {
                fileList.addAll(this.getFilesUnder(file2, filter));
                continue;
            }
            if (filter != null && !filter.accept(file2)) continue;
            fileList.add((Object)file2);
        }
        return fileList;
    }

    public File[] getFiles() {
        return this.getFilesUnder(this.getRootDirectory(), null).toArray(new File[0]);
    }

    public File[] getDirectories(String pattern) {
        File path = this.getRootDirectory();
        return path.listFiles(f -> f.isDirectory() && f.getName().matches(pattern));
    }

    public File[] getDirectories() {
        return this.getRootDirectory().listFiles(File::isDirectory);
    }

    public File getDirectory(String relativePath, boolean createIfNotExist) {
        File file = new File(this.getAbsoulteURI(this.absoluteDirectoryPath.getPath() + "/" + relativePath));
        if (!file.toPath().toUri().getPath().startsWith(this.absoluteDirectoryPath.getPath())) {
            throw new RuntimeException("Trying to access a file that does not belongs to this plugin: %s".formatted(file.toURI()));
        }
        if (!file.exists() && createIfNotExist) {
            try {
                boolean success = file.mkdirs();
                if (!success) {
                    this.logger.warn("Unable to create directory: Unknown error");
                    return null;
                }
            }
            catch (Throwable t) {
                this.logger.error("Unable to create directory '%s': %s".formatted(relativePath, t.getLocalizedMessage()));
                t.printStackTrace();
            }
        }
        if (!file.isDirectory()) {
            return null;
        }
        return file;
    }

    @Nullable
    public File getFile(String fileName, boolean createIfNotExist) {
        File file = new File(this.getRootDirectory(), fileName);
        if (!file.toPath().toUri().getPath().startsWith(this.absoluteDirectoryPath.getPath())) {
            this.logger.error("Trying to access a file that does not belongs to this plugin: %s".formatted(file.toURI()));
            return null;
        }
        if (!file.exists()) {
            if (!createIfNotExist) {
                return null;
            }
            try {
                boolean success = true;
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    success = parent.mkdirs();
                }
                boolean bl = success = success && file.createNewFile();
                if (!success) {
                    this.logger.warn("Unable to create file: Unknown error");
                    return null;
                }
            }
            catch (Throwable t) {
                this.logger.error("Unable to create file '%s'".formatted(fileName), t);
            }
        }
        if (!file.isFile()) {
            this.logger.error("The given file is a directory");
            return null;
        }
        return file;
    }

    private boolean ensureParentAlwaysPresent(File baseFile, boolean isDirectory) {
        File parent = baseFile.getParentFile();
        if (!parent.exists()) {
            this.ensureParentAlwaysPresent(parent, true);
        }
        try {
            return baseFile.createNewFile();
        }
        catch (IOException e) {
            this.logger.warn("Can't create file: " + e.getMessage());
            return false;
        }
    }
}

