/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.client.syncers;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_10017;
import net.minecraft.class_10031;
import net.minecraft.class_10055;
import net.minecraft.class_11352;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1498;
import net.minecraft.class_1577;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_8080;
import net.minecraft.class_8942;
import net.minecraft.class_9064;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.LoggerFactory;
import xiamomc.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.client.ConvertedMeta;
import xyz.nifeather.morph.client.DisguiseInstanceTracker;
import xyz.nifeather.morph.client.EntityCache;
import xyz.nifeather.morph.client.FeatherMorphClientBootstrap;
import xyz.nifeather.morph.client.MorphClientObject;
import xyz.nifeather.morph.client.entities.IDisguiseRenderState;
import xyz.nifeather.morph.client.entities.IHasOverrideGlowing;
import xyz.nifeather.morph.client.entities.IMorphClientEntity;
import xyz.nifeather.morph.client.entities.MorphLocalPlayer;
import xyz.nifeather.morph.client.mixin.accessors.AbstractHorseEntityMixin;
import xyz.nifeather.morph.client.mixin.accessors.EntityAccessor;
import xyz.nifeather.morph.client.mixin.accessors.LimbAnimatorAccessor;
import xyz.nifeather.morph.client.mixin.accessors.LivingEntityAccessor;
import xyz.nifeather.morph.client.syncers.animations.AnimationHandler;
import xyz.nifeather.morph.client.utilties.ClientItemUtils;

public abstract class DisguiseSyncer
extends MorphClientObject {
    @Nullable
    protected class_1309 disguiseInstance;
    @NotNull
    protected class_742 bindingPlayer;
    @NotNull
    private ConvertedMeta bindingMeta = new ConvertedMeta();
    protected final String disguiseId;
    protected final int bindingNetworkId;
    @Resolved(shouldSolveImmediately=true)
    private DisguiseInstanceTracker instanceTracker;
    protected final Map<String, String> cachedProperties = new ConcurrentHashMap<String, String>();
    private AnimationHandler animHandler;
    private int crystalId;
    protected class_1297 beamTarget;
    @NotNull
    private final CompletableFuture<class_1309> entityFuture = new CompletableFuture();
    private static final class_1799 air = new class_1799((class_1935)class_1802.field_8162);
    private final AtomicBoolean isSyncing = new AtomicBoolean(false);
    private boolean allowTick = true;
    @Nullable
    private PositionRecord disguiseLastPositionSaving;
    private class_638 world;
    private class_638 prevWorld;
    private final AtomicBoolean disposed = new AtomicBoolean(false);

    @Nullable
    public class_1309 getDisguiseInstance() {
        return this.disguiseInstance;
    }

    @NotNull
    protected ConvertedMeta getBindingMeta() {
        return this.bindingMeta;
    }

    @Nullable
    protected class_2487 getCompound() {
        return this.bindingMeta.nbt;
    }

    public String disguiseIdentifier() {
        return this.disguiseId;
    }

    @NotNull
    protected abstract EntityCache getEntityCache();

    public void mergeNetworkProperties(Map<String, String> map) {
        this.cachedProperties.putAll(map);
    }

    public void setCachedNetworkProperties(Map<String, String> map) {
        this.cachedProperties.clear();
        this.cachedProperties.putAll(map);
    }

    public @Unmodifiable Map<String, String> cachedNetworkProperties() {
        return ImmutableMap.copyOf(this.cachedProperties);
    }

    @NotNull
    public class_742 getBindingPlayer() {
        return this.bindingPlayer;
    }

    public DisguiseSyncer(@NotNull class_742 bindingPlayer, String morphId, int networkId) {
        this.bindingPlayer = bindingPlayer;
        this.disguiseId = morphId;
        this.bindingNetworkId = networkId;
        this.bindingMeta.outdated = true;
        this.setupEntity();
    }

    public void setAnimationHandler(AnimationHandler handler) {
        this.animHandler = handler;
    }

    public void playAnimation(String animation) {
        if (this.animHandler == null) {
            this.logger.warn("No animation handler for disguise '%s'!".formatted(this.disguiseId));
            return;
        }
        this.animHandler.play((class_1297)this.disguiseInstance, animation);
    }

    private void scheduleCrystalSearch() {
        if (this.beamTarget != null || this.crystalId == 0) {
            return;
        }
        this.addSchedule(this::scheduleCrystalSearch, 10);
        this.beamTarget = this.findCrystalBy(this.crystalId);
    }

    @Nullable
    private class_1297 findCrystalBy(int id) {
        if (this.disguiseInstance == null || id == 0) {
            return null;
        }
        return this.bindingPlayer.method_73183().method_8469(id);
    }

    protected void finishEntityFuture(class_1309 instance) {
        this.entityFuture.complete(instance);
    }

    public CompletableFuture<class_1309> getEntityFuture() {
        return this.entityFuture;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setupEntity() {
        if (this.disguiseInstance != null) {
            throw new IllegalStateException("This syncer %s already have a disguise instance on bind!".formatted(this.toString()));
        }
        try (class_638 clientWorld = class_310.method_1551().field_1687;){
            class_1309 newInstance;
            if (clientWorld == null) {
                boolean bl = false;
                return bl;
            }
            EntityCache entityCache = this.getEntityCache();
            class_1309 prevEntity = this.disguiseInstance;
            FeatherMorphClientBootstrap client = FeatherMorphClientBootstrap.getInstance();
            if (prevEntity != null) {
                prevEntity.method_5673(class_1304.field_6173, class_1799.field_8037);
                prevEntity.method_5673(class_1304.field_6171, class_1799.field_8037);
                prevEntity.method_5673(class_1304.field_6169, class_1799.field_8037);
                prevEntity.method_5673(class_1304.field_6174, class_1799.field_8037);
                prevEntity.method_5673(class_1304.field_6172, class_1799.field_8037);
                prevEntity.method_5673(class_1304.field_6166, class_1799.field_8037);
                this.beamTarget = null;
                prevEntity.field_6235 = 0;
                this.disposeEntity(prevEntity);
                entityCache.discardEntity(this.disguiseId);
            }
            if ((newInstance = entityCache.getEntity(this.disguiseId, (class_1657)this.bindingPlayer)) == null) {
                this.logger.info("Can't create entity with ID: %s, is it valid for the client?".formatted(this.disguiseId));
                boolean bl = false;
                return bl;
            }
            newInstance.method_5838(newInstance.method_5628() - newInstance.method_5628() * 2);
            client.schedule(() -> clientWorld.method_53875((class_1297)newInstance));
            class_2487 nbt = this.getCompound();
            if (nbt != null) {
                client.schedule(() -> this.mergeNbt(nbt));
            }
            newInstance.method_5780("BINDING_" + this.bindingPlayer.method_5628());
            newInstance.field_5960 = true;
            if (newInstance instanceof IMorphClientEntity) {
                IMorphClientEntity iMorphEntity = (IMorphClientEntity)newInstance;
                iMorphEntity.featherMorph$setIsDisguiseEntity(this.bindingNetworkId);
            }
            if (newInstance instanceof MorphLocalPlayer) {
                MorphLocalPlayer prevPlayer;
                MorphLocalPlayer localPlayer = (MorphLocalPlayer)newInstance;
                localPlayer.setBindingPlayer((class_1657)class_310.method_1551().field_1724);
                if (prevEntity instanceof MorphLocalPlayer && (prevPlayer = (MorphLocalPlayer)prevEntity).personEquals(localPlayer)) {
                    localPlayer.copyFrom(prevPlayer);
                }
            }
            this.disguiseInstance = newInstance;
            this.initialSync();
            this.baseSync();
            this.finishEntityFuture(newInstance);
            return true;
        }
        catch (Throwable t) {
            this.logger.error("Error occurred while refreshing client view: %s".formatted(t.getMessage()));
            t.printStackTrace();
            this.disguiseInstance = null;
            return false;
        }
    }

    public void playAttackAnimation() {
        if (this.disguiseInstance != null) {
            this.disguiseInstance.method_5711((byte)4);
        }
    }

    protected void mergeNbt(class_2487 nbtCompound) {
        class_1309 entity = this.disguiseInstance;
        if (entity == null) {
            return;
        }
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(entity.method_71370(), FeatherMorphClientBootstrap.LOGGER);){
            entity.method_5651(class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)entity.method_56673(), (class_2487)nbtCompound));
        }
        if (entity instanceof class_1498) {
            class_1498 horse = (class_1498)entity;
            boolean haveSaddle = nbtCompound.method_10545("SaddleItem");
            if (haveSaddle) {
                class_1799 itemStack = ClientItemUtils.fromCompound((class_7225.class_7874)this.bindingPlayer.method_73183().method_30349(), (class_2487)nbtCompound.method_10562("SaddleItem").orElseThrow()).orElse(air);
                boolean isSaddle = itemStack.method_31574(class_1802.field_8175);
                ((AbstractHorseEntityMixin)horse).callSetFlag(4, isSaddle);
            }
            if (nbtCompound.method_10545("ArmorItem")) {
                class_1799 armorItem = ClientItemUtils.fromCompound((class_7225.class_7874)this.bindingPlayer.method_73183().method_30349(), (class_2487)nbtCompound.method_10562("ArmorItem").orElseThrow()).orElse(air);
                horse.method_56678(armorItem);
            }
        }
        this.bindingPlayer.method_18382();
        Integer crystalPosition = nbtCompound.method_10550("BeamTarget").orElse(-1);
        this.crystalId = crystalPosition;
        this.beamTarget = this.findCrystalBy(crystalPosition);
        if (this.beamTarget == null) {
            this.scheduleCrystalSearch();
        }
    }

    protected void markSyncing() {
        this.isSyncing.set(true);
    }

    protected void markNotSyncing() {
        this.isSyncing.set(false);
    }

    public boolean isSyncing() {
        return this.isSyncing.get();
    }

    protected void onTickError() {
    }

    private void onSyncError(Exception e) {
        this.allowTick = false;
        this.markNotSyncing();
        this.logger.error(e.getMessage());
        e.printStackTrace();
        if (this.disguiseInstance != null) {
            try {
                this.disposeEntity(this.disguiseInstance);
            }
            catch (Exception ee) {
                LoggerFactory.getLogger((String)"MorphClient").error("Unable to remove entity:" + ee.getMessage());
                ee.printStackTrace();
            }
            this.disguiseInstance = null;
        }
        this.onTickError();
        class_746 clientPlayer = class_310.method_1551().field_1724;
        assert (clientPlayer != null);
        clientPlayer.method_7353((class_2561)class_2561.method_43470((String)(String.valueOf(this) + "Sync Failed!")), false);
    }

    public void onGameTick() {
        if (!this.allowTick) {
            return;
        }
        try {
            class_746 clientPlayer = class_310.method_1551().field_1724;
            assert (clientPlayer != null);
            this.syncTick();
        }
        catch (Exception e) {
            this.onSyncError(e);
        }
    }

    public void preRenderStateSetup() {
        if (!this.allowTick || this.disguiseInstance == null) {
            return;
        }
        float xRot = this.bindingPlayer.method_36455();
        float xRotO = this.bindingPlayer.field_6004;
        if (this.disguiseInstance.method_5864() == class_1299.field_6078) {
            xRot = -xRot;
            xRotO = -xRotO;
        }
        float yRot = this.bindingPlayer.method_36454();
        float yRotO = this.bindingPlayer.field_5982;
        if (this.disguiseInstance.method_5864() == class_1299.field_6116) {
            yRot = 180.0f + yRot;
            yRotO = 180.0f + yRotO;
        }
        this.disguiseLastPositionSaving = PositionRecord.fromEntity(this.disguiseInstance);
        this.disguiseInstance.method_60949(this.bindingPlayer.method_73189(), yRot, xRot);
        this.disguiseInstance.method_63615(this.bindingPlayer.method_61411(), yRotO, xRotO);
        this.disguiseInstance.method_18799(this.bindingPlayer.method_18798());
    }

    public void modifyRenderState(class_10017 renderState) {
        if (!this.allowTick) {
            return;
        }
        if (this.disguiseInstance == null) {
            return;
        }
        if (this.disguiseInstance.method_5864() != class_1299.field_6097 && this.disguiseInstance.method_16914()) {
            renderState.field_53337 = this.disguiseInstance.method_5477();
            renderState.field_53338 = this.disguiseInstance.method_56072().method_55675(class_9064.field_47745, 0, this.disguiseInstance.method_61415(1.0f));
        }
        if (renderState instanceof class_10031) {
            class_10031 guardianRenderState = (class_10031)renderState;
            guardianRenderState.field_53392 = new class_243(this.bindingPlayer.field_6014, this.bindingPlayer.field_6036, this.bindingPlayer.field_5969);
        }
        if (renderState instanceof class_10055) {
            class_10055 avatarRenderState = (class_10055)renderState;
            float tickDelta = class_310.method_1551().method_61966().method_60637(false);
            class_10055 playerState = (class_10055)class_310.method_1551().method_1561().method_72977((class_1297)this.bindingPlayer, tickDelta);
            avatarRenderState.field_53536 = playerState.field_53536;
            avatarRenderState.field_53537 = playerState.field_53537;
            avatarRenderState.field_53538 = playerState.field_53538;
        }
    }

    public void postRenderStateSetup() {
        if (!this.allowTick || this.disguiseInstance == null) {
            return;
        }
        if (this.disguiseLastPositionSaving != null) {
            this.disguiseLastPositionSaving.applyToEntity(this.disguiseInstance);
            this.disguiseLastPositionSaving = null;
        }
    }

    public void postRenderSubmit() {
    }

    public void updateSkin(GameProfile profile) {
        if (this.disposed.get()) {
            this.logger.warn("Trying to update skin for a disposed DisguiseSyncer " + String.valueOf(this));
            Thread.dumpStack();
            return;
        }
        if (!RenderSystem.isOnRenderThread()) {
            throw new RuntimeException("May not invoke updateSkin() while not on the render thread.");
        }
        class_1309 class_13092 = this.disguiseInstance;
        if (!(class_13092 instanceof MorphLocalPlayer)) {
            FeatherMorphClientBootstrap.LOGGER.warn(String.valueOf(this) + " Received a GameProfile while current disguise is not a player! Current instance is %s".formatted(this.disguiseInstance));
            return;
        }
        MorphLocalPlayer localPlayer = (MorphLocalPlayer)class_13092;
        localPlayer.updateSkin(profile);
    }

    public abstract void syncTick();

    public void onEntityRenderStateSetup(class_10017 renderState, IDisguiseRenderState asDisguiseRenderState) {
    }

    protected abstract void initialSync();

    protected void syncYawPitch() {
        if (this.disguiseInstance == null) {
            return;
        }
        class_742 player = this.bindingPlayer;
        if (this.disguiseInstance.method_18398().isEmpty()) {
            if (this.disguiseInstance.method_5864() == class_1299.field_6078) {
                this.disguiseInstance.method_36457(-player.method_36455());
            } else {
                this.disguiseInstance.method_36457(player.method_36455());
            }
        }
        if (this.disguiseInstance.method_5864() == class_1299.field_6116) {
            this.disguiseInstance.method_36456(180.0f + player.method_36454());
        } else {
            this.disguiseInstance.method_36456(player.method_36454());
        }
        this.disguiseInstance.field_6241 = player.field_6241;
        this.disguiseInstance.field_6259 = player.field_6259;
        if (this.disguiseInstance.method_5864() == class_1299.field_6131) {
            this.disguiseInstance.field_6283 = player.field_6241;
            this.disguiseInstance.field_6220 = player.field_6259;
        }
    }

    protected boolean showOverridedEquips() {
        return this.bindingMeta.showOverridedEquips;
    }

    protected void syncEquipments() {
        if (this.disguiseInstance == null) {
            return;
        }
        ConvertedMeta meta = this.getBindingMeta();
        boolean showOverridedEquips = this.showOverridedEquips();
        ConvertedMeta.ConvertedEquipment disguiseEquip = meta.convertedEquipment;
        if (disguiseEquip == null && showOverridedEquips) {
            return;
        }
        class_1799 headStack = showOverridedEquips ? disguiseEquip.head : this.bindingPlayer.method_6118(class_1304.field_6169);
        class_1799 chestStack = showOverridedEquips ? disguiseEquip.chest : this.bindingPlayer.method_6118(class_1304.field_6174);
        class_1799 legStack = showOverridedEquips ? disguiseEquip.leggings : this.bindingPlayer.method_6118(class_1304.field_6172);
        class_1799 feetStack = showOverridedEquips ? disguiseEquip.feet : this.bindingPlayer.method_6118(class_1304.field_6166);
        class_1799 handStack = showOverridedEquips ? disguiseEquip.mainHand : this.bindingPlayer.method_6118(class_1304.field_6173);
        class_1799 offHandStack = showOverridedEquips ? disguiseEquip.offHand : this.bindingPlayer.method_6118(class_1304.field_6171);
        this.disguiseInstance.method_5673(class_1304.field_6173, handStack);
        this.disguiseInstance.method_5673(class_1304.field_6171, offHandStack);
        this.disguiseInstance.method_5673(class_1304.field_6169, headStack);
        this.disguiseInstance.method_5673(class_1304.field_6174, chestStack);
        this.disguiseInstance.method_5673(class_1304.field_6172, legStack);
        this.disguiseInstance.method_5673(class_1304.field_6166, feetStack);
    }

    protected void syncPosition() {
        if (this.disguiseInstance == null) {
            return;
        }
        class_243 playerPos = this.bindingPlayer.method_73189();
        this.disguiseInstance.method_5814(playerPos.field_1352, playerPos.field_1351 - 4096.0, playerPos.field_1350);
    }

    private void preMetaChange(ConvertedMeta meta) {
        class_1309 class_13092;
        if (meta.nbt != null) {
            this.mergeNbt(meta.nbt);
        }
        if (meta.profileNbt != null && (class_13092 = this.disguiseInstance) instanceof MorphLocalPlayer) {
            MorphLocalPlayer localPlayer = (MorphLocalPlayer)class_13092;
            localPlayer.updateSkin(meta.profileNbt);
        }
        meta.outdated = false;
        this.bindingMeta = meta;
    }

    protected void baseSync() {
        class_1309 entity = this.disguiseInstance;
        if (entity == null) {
            return;
        }
        if (this.disposed()) {
            this.logger.warn("Trying to update a disposed DisguiseSyncer(%s)!".formatted(this));
            Thread.dumpStack();
            return;
        }
        if (this.bindingPlayer.method_31481() || this.bindingPlayer.method_73183() != class_310.method_1551().field_1687) {
            this.logger.info(String.valueOf(this) + " Player removed, scheduling syncer dispose");
            this.addSchedule(this::dispose);
            return;
        }
        this.world = class_310.method_1551().field_1687;
        if (this.world != this.prevWorld) {
            class_638 prev = this.prevWorld;
            this.prevWorld = this.world;
            if (prev != null) {
                this.logger.info(String.valueOf(this) + " World changed, scheduling syncer dispose");
                this.getEntityCache().dropAll();
                this.addSchedule(this::dispose);
            }
            return;
        }
        if (this.disguiseInstance.method_31481()) {
            this.logger.info(String.valueOf(this) + " Instance removed, scheduling syncer dispose");
            this.addSchedule(this::dispose);
            return;
        }
        if (this.bindingMeta.outdated) {
            this.preMetaChange(this.instanceTracker.getMetaFor(this.bindingNetworkId));
        }
        this.markSyncing();
        this.syncPosition();
        this.syncEquipments();
        entity.method_5773();
        if (this.beamTarget != null && this.beamTarget.method_31481()) {
            this.beamTarget = null;
        }
        LimbAnimatorAccessor entitylimbAnimatorAccessor = (LimbAnimatorAccessor)entity.field_42108;
        LimbAnimatorAccessor playerLimbAccessor = (LimbAnimatorAccessor)this.bindingPlayer.field_42108;
        class_8080 playerLimb = this.bindingPlayer.field_42108;
        entitylimbAnimatorAccessor.setSpeedOld(playerLimbAccessor.getSpeedOld());
        entitylimbAnimatorAccessor.setPosition(playerLimb.method_48569());
        entitylimbAnimatorAccessor.setSpeed(playerLimb.method_48566());
        class_2338 sleepPos = this.bindingPlayer.method_18398().orElse(null);
        if (sleepPos != null) {
            entity.method_18402(sleepPos);
        } else {
            entity.method_18399();
        }
        entity.method_33572(this.bindingPlayer.method_5809());
        class_1324 healthAttribute = entity.method_5996(class_5134.field_23716);
        if (healthAttribute != null) {
            healthAttribute.method_6192((double)this.bindingPlayer.method_6063());
        }
        entity.method_6033(this.bindingPlayer.method_6032());
        class_1324 scaleAttribute = entity.method_5996(class_5134.field_47760);
        if (scaleAttribute != null && scaleAttribute.method_6194() != this.bindingPlayer.method_45325(class_5134.field_47760)) {
            scaleAttribute.method_6192(this.bindingPlayer.method_45325(class_5134.field_47760));
        }
        if (entity.method_5864() != class_1299.field_62515) {
            entity.field_6252 = this.bindingPlayer.field_6252;
            entity.field_6251 = this.bindingPlayer.field_6251;
            entity.field_6229 = this.bindingPlayer.field_6229;
            entity.field_6279 = this.bindingPlayer.field_6279;
            entity.field_6266 = this.bindingPlayer.field_6266;
        }
        if (entity.method_5864() != class_1299.field_62515) {
            entity.method_5660(this.bindingPlayer.method_5715());
        }
        entity.field_6235 = this.bindingPlayer.field_6235;
        entity.field_6213 = this.bindingPlayer.field_6213;
        entity.method_5728(this.bindingPlayer.method_5624());
        entity.method_32317(this.bindingPlayer.method_32312());
        entity.method_18799(this.bindingPlayer.method_18798());
        entity.method_24830(this.bindingPlayer.method_24828());
        ((EntityAccessor)entity).setWasTouchingWater(this.bindingPlayer.method_5799());
        if (this.bindingPlayer.method_5851() != entity.method_5851()) {
            entity.method_5834(this.bindingPlayer.method_5851());
        }
        entity.method_18380(this.bindingPlayer.method_18376());
        entity.method_5796(this.bindingPlayer.method_5681());
        if (entity.method_6115() != this.bindingPlayer.method_6115()) {
            entity.method_6019(this.bindingPlayer.method_6058());
            ((LivingEntityAccessor)entity).callSetLivingEntityFlag(1, this.bindingPlayer.method_6115());
            ((LivingEntityAccessor)entity).callSetLivingEntityFlag(2, this.bindingPlayer.method_6058() == class_1268.field_5810);
        }
        if (this.bindingPlayer.method_5765() && entity.method_5854() != this.bindingPlayer) {
            if (entity instanceof IMorphClientEntity) {
                IMorphClientEntity asMorphClientEntity = (IMorphClientEntity)entity;
                asMorphClientEntity.featherMorph$overridePose(null);
            }
            entity.method_5804((class_1297)this.bindingPlayer);
        } else if (!this.bindingPlayer.method_5765() && entity.method_5765()) {
            entity.method_5848();
        }
        entity.method_6097(this.bindingPlayer.method_6022());
        if (entity instanceof MorphLocalPlayer) {
            MorphLocalPlayer player = (MorphLocalPlayer)entity;
            player.field_7513 = this.bindingPlayer.field_7513;
        }
        entity.method_5648(this.bindingPlayer.method_5767());
        this.markNotSyncing();
    }

    protected void disposeEntity(@NotNull class_1309 disguise) {
        class_1577 guardian;
        class_1309 class_13092;
        if (disguise instanceof class_1577 && (class_13092 = (guardian = (class_1577)disguise).method_7052()) instanceof IHasOverrideGlowing) {
            IHasOverrideGlowing overrideGlowing = (IHasOverrideGlowing)class_13092;
            overrideGlowing.morphclient$overrideClientGlowing(false);
        }
        if (RenderSystem.isOnRenderThread()) {
            disguise.method_31472();
        } else {
            this.addSchedule(() -> ((class_1309)disguise).method_31472());
        }
    }

    public final boolean disposed() {
        return this.disposed.get();
    }

    protected abstract void onDispose();

    public final void dispose() {
        if (this.disposed()) {
            return;
        }
        if (this.getEntityCache() != EntityCache.getGlobalCache()) {
            this.getEntityCache().dispose();
        }
        if (this.disguiseInstance != null) {
            this.disposeEntity(this.disguiseInstance);
        }
        try {
            this.onDispose();
        }
        catch (Throwable t) {
            this.logger.warn("Error calling onDispose() for DisguiseSyncer: %s".formatted(t.getMessage()));
            t.printStackTrace();
        }
        this.disguiseInstance = null;
        this.world = null;
        this.prevWorld = null;
        this.disposed.set(true);
        this.cachedProperties.clear();
        this.bindingPlayer.method_18382();
        try {
            this.postDispose();
        }
        catch (Throwable t) {
            this.logger.warn("Error calling postDispose() for DisguiseSyncer: %s".formatted(t.getMessage()));
            t.printStackTrace();
        }
    }

    protected void postDispose() {
    }

    private record PositionRecord(class_243 pos, float xRot, float yRot, class_243 oldPos, float xRotOld, float yRotOld, class_243 motion) {
        public static PositionRecord fromEntity(class_1309 entity) {
            return new PositionRecord(entity.method_73189(), entity.method_36455(), entity.method_36454(), entity.method_61411(), entity.field_6004, entity.field_5982, entity.method_18798());
        }

        public void applyToEntity(class_1309 entity) {
            entity.method_60949(this.pos, this.yRot, this.xRot);
            entity.method_63615(this.oldPos, this.yRotOld, this.xRotOld);
            entity.method_18799(this.motion);
        }
    }
}

