/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server.misc;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.server.disguise.providers.AbstractDisguiseProvider;
import xyz.nifeather.morph.server.misc.DisguiseTypes;

public class DisguiseMeta {
    @SerializedName(value="Type")
    @Expose(serialize=false)
    @Deprecated
    public class_1299<?> type;
    private final class_1299<?> entityType;
    @NotNull
    public final String rawIdentifier;
    @NotNull
    private final DisguiseTypes disguiseType;
    @Nullable
    private final AbstractDisguiseProvider provider;
    @Expose
    public String playerDisguiseTargetName;

    @ApiStatus.Internal
    public class_1299<?> getEntityType() {
        return this.entityType;
    }

    public String getIdentifier() {
        return this.rawIdentifier;
    }

    @Nullable
    public AbstractDisguiseProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public DisguiseTypes getDisguiseType() {
        return this.disguiseType;
    }

    public final boolean isPlayerDisguise() {
        return this.disguiseType == DisguiseTypes.PLAYER;
    }

    public DisguiseMeta(@NotNull String rawIdentifier, DisguiseTypes disguiseType, @Nullable AbstractDisguiseProvider matchingProvider) {
        this.rawIdentifier = rawIdentifier;
        this.disguiseType = disguiseType;
        this.provider = matchingProvider;
        switch (disguiseType) {
            case PLAYER: {
                this.entityType = class_1299.field_6097;
                this.playerDisguiseTargetName = disguiseType.toStrippedId(rawIdentifier);
                break;
            }
            case VANILLA: {
                this.entityType = (class_1299)class_1299.method_5898((String)rawIdentifier).orElseThrow();
                break;
            }
            default: {
                this.entityType = null;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof DisguiseMeta)) {
            return false;
        }
        DisguiseMeta di = (DisguiseMeta)other;
        return this.equals(di.rawIdentifier);
    }

    public boolean equals(class_1299<?> type) {
        if (!this.isValid()) {
            return false;
        }
        return this.entityType.equals(type);
    }

    public boolean equals(String rawString) {
        return this.rawIdentifier.equals(rawString);
    }

    public boolean isValid() {
        return this.disguiseType != DisguiseTypes.UNKNOWN && this.entityType != null;
    }

    public String getKey() {
        if (!this.isValid()) {
            return this.rawIdentifier;
        }
        return this.rawIdentifier;
    }

    public class_2561 asComponent() {
        return this.isValid() ? (this.provider == null ? class_2561.method_43470((String)this.rawIdentifier) : this.provider.getDisplayName(this.rawIdentifier)) : class_2561.method_43470((String)this.rawIdentifier);
    }

    public int objectHashCode() {
        return super.hashCode();
    }

    public int hashCode() {
        return this.rawIdentifier.hashCode();
    }

    public String toString() {
        return "DisguiseMeta[Type=" + String.valueOf(this.entityType) + ", DisguiseType=" + String.valueOf((Object)this.getDisguiseType()) + ", targetPlayerName=" + this.playerDisguiseTargetName + "]";
    }
}

