/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server.misc;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_2960;

public enum DisguiseTypes {
    VANILLA("minecraft"),
    PLAYER("player"),
    EXTERNAL("external"),
    UNKNOWN("unknown");

    private final String nameSpace;

    private DisguiseTypes(String namespace) {
        this.nameSpace = namespace;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public static DisguiseTypes fromNameSpace(String namespace) {
        DisguiseTypes[] types = DisguiseTypes.values();
        Optional<DisguiseTypes> optional = Arrays.stream(types).filter(t -> t.getNameSpace().equals(namespace)).findFirst();
        return optional.orElse(UNKNOWN);
    }

    public static DisguiseTypes fromId(String id) {
        if (id.equals("minecrcaft:player")) {
            return EXTERNAL;
        }
        String str = id + ":";
        String[] idSplited = str.split(":", 3);
        DisguiseTypes result = DisguiseTypes.fromNameSpace(idSplited[0]);
        if (result == UNKNOWN) {
            result = EXTERNAL;
        }
        return result;
    }

    public static DisguiseTypes fromId(class_2960 key) {
        return DisguiseTypes.fromId(key.toString());
    }

    public String toId(String id) {
        return this.getNameSpace() + ":" + id;
    }

    public class_2960 toIdentifier(String idWithoutNamespace) {
        return class_2960.method_60654((String)this.toId(idWithoutNamespace));
    }

    public String toStrippedId(String rawString) {
        return rawString.replace(this.getNameSpace() + ":", "");
    }
}

