/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server.morphs;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import xiamomc.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CSetCurrentCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CAddAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CRemoveAdminRevealCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRRegisterCommand;
import xyz.nifeather.morph.network.commands.S2C.clientrender.S2CCRUnregisterCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetAvailableAnimationsCommand;
import xyz.nifeather.morph.server.MorphServerLoader;
import xyz.nifeather.morph.server.ServerPluginObject;
import xyz.nifeather.morph.server.disguise.providers.AbstractDisguiseProvider;
import xyz.nifeather.morph.server.disguise.providers.FallbackDisguiseProvider;
import xyz.nifeather.morph.server.disguise.providers.PlayerDisguiseProvider;
import xyz.nifeather.morph.server.disguise.providers.VanillaDisguiseProvider;
import xyz.nifeather.morph.server.misc.DisguiseMeta;
import xyz.nifeather.morph.server.misc.DisguiseTypes;
import xyz.nifeather.morph.server.morphs.DisguiseSession;
import xyz.nifeather.morph.server.network.ClientHandler;
import xyz.nifeather.morph.server.storage.playerdata.paper.PlayerDataStoreNew;
import xyz.nifeather.morph.server.storage.playerdata.paper.PlayerMeta;
import xyz.nifeather.morph.shared.exceptions.AlreadyRegisteredException;

public class MorphManager
extends ServerPluginObject {
    private final Map<class_3222, DisguiseSession> disguiseSessionMap = new ConcurrentHashMap<class_3222, DisguiseSession>();
    @Resolved
    private ClientHandler clientHandler;
    private final Map<String, AbstractDisguiseProvider> disguiseProviders = new ConcurrentHashMap<String, AbstractDisguiseProvider>();
    private final FallbackDisguiseProvider fallbackProvider;
    private final Map<String, DisguiseMeta> disguiseMetaCache = new ConcurrentHashMap<String, DisguiseMeta>();
    private final PlayerDataStoreNew dataStore = new PlayerDataStoreNew();

    public MorphManager() {
        this.fallbackProvider = new FallbackDisguiseProvider();
        this.registerDisguiseProvider(new VanillaDisguiseProvider());
        this.registerDisguiseProvider(new PlayerDisguiseProvider());
        this.registerDisguiseProvider(this.fallbackProvider);
        this.addSchedule(this::update);
    }

    public boolean playerDisguised(class_3222 player) {
        return this.disguiseSessionMap.containsKey(player);
    }

    @Nullable
    public DisguiseSession getSessionFor(class_3222 player) {
        return this.disguiseSessionMap.getOrDefault(player, null);
    }

    public List<DisguiseSession> listAllSession() {
        return new ObjectArrayList(this.disguiseSessionMap.values());
    }

    public void registerDisguiseProvider(AbstractDisguiseProvider provider) throws AlreadyRegisteredException {
        if (this.disguiseProviders.containsKey(provider.namespace())) {
            throw new AlreadyRegisteredException("Already have a provider with the namespace '%s'".formatted(provider.namespace()));
        }
        this.disguiseProviders.put(provider.namespace(), provider);
    }

    public AbstractDisguiseProvider getProvider(String id) {
        if (id == null) {
            return this.fallbackProvider;
        }
        id = (String)id + ":";
        String[] splitedId = ((String)id).split(":", 2);
        return this.disguiseProviders.values().stream().filter(p -> p.namespace().equals(splitedId[0])).findFirst().orElse(this.fallbackProvider);
    }

    public List<AbstractDisguiseProvider> listProviders() {
        return new ObjectArrayList(this.disguiseProviders.values());
    }

    public DisguiseMeta getDisguiseMetaFrom(String identifier) {
        DisguiseMeta cached = this.disguiseMetaCache.getOrDefault(identifier, null);
        if (cached != null) {
            return cached;
        }
        AbstractDisguiseProvider provider = this.getProvider(identifier);
        DisguiseTypes type = DisguiseTypes.fromId(identifier);
        DisguiseMeta newInstance = new DisguiseMeta(identifier, type, provider);
        this.disguiseMetaCache.put(identifier, newInstance);
        return newInstance;
    }

    public List<String> getUnlockedDisguiseIds(class_1657 player) {
        PlayerMeta meta = this.dataStore.getPlayerMeta(player.method_5667());
        return meta.getUnlockedDisguiseIdentifiers();
    }

    public boolean grantDisguiseToPlayer(class_3222 player, String disguiseIdentifier) {
        boolean success = this.dataStore.grantMorphToPlayer(player, disguiseIdentifier);
        if (!success) {
            return false;
        }
        this.clientHandler.sendDiff(List.of(disguiseIdentifier), null, player);
        DisguiseMeta meta = this.getDisguiseMetaFrom(disguiseIdentifier);
        class_5250 message = class_2561.method_48322((String)"morph.disguise_unlocked", (String)"Unlocked disguise of %s!", (Object[])new Object[]{meta.asComponent()});
        player.method_64398((class_2561)message);
        return success;
    }

    public boolean revokeDisguiseFromPlayer(class_3222 player, String disguiseIdentifier) {
        boolean success = this.dataStore.revokeMorphFromPlayer(player, disguiseIdentifier);
        if (success) {
            this.clientHandler.sendDiff(null, List.of(disguiseIdentifier), player);
            DisguiseMeta meta = this.getDisguiseMetaFrom(disguiseIdentifier);
            class_5250 message = class_2561.method_48322((String)"morph.disguise_lost", (String)"Lost disguise of %s!", (Object[])new Object[]{meta.asComponent()});
            player.method_64398((class_2561)message);
            DisguiseSession disguiseState = this.getSessionFor(player);
            if (disguiseState != null && disguiseState.disguiseIdentifier().equalsIgnoreCase(disguiseIdentifier)) {
                this.unMorph(player);
            }
        }
        return success;
    }

    public boolean morph(class_3222 player, String identifier) {
        return this.morph(player, identifier, false);
    }

    public boolean morph(class_3222 player, String identifier, boolean bypassAvailableCheck) {
        String[] idSplit = identifier.split(":", 2);
        String idNamespace = idSplit.length == 2 ? idSplit[0] : "minecraft";
        AbstractDisguiseProvider provider = this.disguiseProviders.get(idNamespace);
        if (provider == null) {
            player.method_7353((class_2561)class_2561.method_48322((String)"morph.error.invalid_namespace", (String)"Error: Invalid namespace \"%s\"", (Object[])new Object[]{idNamespace}), false);
            return false;
        }
        if (!provider.isValid(identifier)) {
            player.method_7353((class_2561)class_2561.method_48322((String)"morph.error.invalid_id", (String)"Error: Identifier \"%s\" not valid for \"%s\"", (Object[])new Object[]{identifier, idNamespace}), false);
            return false;
        }
        List<String> available = this.getUnlockedDisguiseIds((class_1657)player);
        if (!bypassAvailableCheck && !available.contains(identifier)) {
            player.method_7353((class_2561)class_2561.method_48321((String)"morph.error.not_unlocked", (String)"Error: That disguise is not unlocked yet"), false);
            return false;
        }
        this.disguiseSessionMap.put(player, new DisguiseSession(player, identifier, provider));
        List<String> availableAnimations = provider.getAnimationProvider().getAnimationSetFor(identifier).getAvailableAnimationsForClient();
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetCurrentCommand(identifier));
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetAvailableAnimationsCommand(availableAnimations));
        S2CCRRegisterCommand cmd = new S2CCRRegisterCommand(Integer.valueOf(player.method_5628()), identifier);
        Object2ObjectOpenHashMap revealMap = new Object2ObjectOpenHashMap();
        revealMap.put(player.method_5628(), player.method_5477().getString());
        S2CAddAdminRevealCommand cmdReveal = new S2CAddAdminRevealCommand((Map)revealMap);
        for (class_3222 serverPlayerEntity : MorphServerLoader.mcserver.method_3760().method_14571()) {
            this.clientHandler.sendCommand(serverPlayerEntity, (AbstractS2CCommand<?>)cmd);
            this.clientHandler.sendCommand(serverPlayerEntity, (AbstractS2CCommand<?>)cmdReveal);
        }
        this.spawnParticle(player);
        player.method_51469().method_8396((class_1297)player, class_2338.method_49638((class_2374)player.method_73189()), class_3417.field_15096, class_3419.field_15248, 1.0f, 1.0f);
        player.method_64398((class_2561)class_2561.method_48322((String)"morph.disguising_as", (String)"Disguising as %s", (Object[])new Object[]{provider.getDisplayName(identifier)}));
        return true;
    }

    public void spawnParticle(class_3222 player) {
        if (player.field_13974.method_14257() == class_1934.field_9219) {
            return;
        }
        double collX = player.method_5829().method_17939();
        double collY = player.method_5829().method_17940();
        double collZ = player.method_5829().method_17941();
        class_243 location = player.method_73189().method_1031(0.0, collY / 2.0, 0.0);
        double particleScale = Math.max(1.0, collX * collY * collZ / 15.0);
        player.method_51469().method_14199((class_2394)class_2398.field_11204, false, false, location.field_1352, location.field_1351, location.field_1350, (int)(25.0 * particleScale), collX * 0.6, collY / 4.0, collZ * 0.6, particleScale >= 10.0 ? 0.2 : 0.05);
    }

    public void unMorph(class_3222 player) {
        if (!this.playerDisguised(player)) {
            return;
        }
        this.disguiseSessionMap.remove(player);
        if (player.method_14239()) {
            return;
        }
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetCurrentCommand(null));
        this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSetAvailableAnimationsCommand(List.of()));
        S2CCRUnregisterCommand cmd = new S2CCRUnregisterCommand(Integer.valueOf(player.method_5628()));
        S2CRemoveAdminRevealCommand cmdReveal = new S2CRemoveAdminRevealCommand(player.method_5628());
        for (class_3222 serverPlayerEntity : MorphServerLoader.mcserver.method_3760().method_14571()) {
            this.clientHandler.sendCommand(serverPlayerEntity, (AbstractS2CCommand<?>)cmd);
            this.clientHandler.sendCommand(serverPlayerEntity, (AbstractS2CCommand<?>)cmdReveal);
        }
        this.spawnParticle(player);
        player.method_64398((class_2561)class_2561.method_43470((String)"Undisguised"));
    }

    public void update() {
        this.addSchedule(this::update);
        this.disguiseSessionMap.forEach((player, session) -> {
            if (player.method_14239()) {
                this.unMorph((class_3222)player);
            } else {
                session.update();
            }
        });
    }

    public void dispose() {
        this.logger.info("Disposing FabricMorphManager");
    }
}

