/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server.storage.playerdata.paper;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_3222;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.server.MorphServerLoader;
import xyz.nifeather.morph.server.misc.DisguiseMeta;
import xyz.nifeather.morph.server.misc.DisguiseTypes;
import xyz.nifeather.morph.server.storage.DirectoryJsonBasedStorage;
import xyz.nifeather.morph.server.storage.IManagePlayerData;
import xyz.nifeather.morph.server.storage.playerdata.paper.PlayerMeta;
import xyz.nifeather.morph.server.utils.DisguiseUtils;

public class PlayerDataStoreNew
extends DirectoryJsonBasedStorage<PlayerMeta>
implements IManagePlayerData {
    private static final PlayerMeta defaultMeta = new PlayerMeta();
    private static final int TARGET_PACKAGE_VERSION = 1;
    private final Map<UUID, PlayerMeta> trackedPlayerMetaMap = new ConcurrentHashMap<UUID, PlayerMeta>();
    private final AtomicBoolean noLazyLoad = new AtomicBoolean(false);

    public PlayerDataStoreNew() {
        super("playerdata");
        int packageVersion = this.getPackageVersion();
        if (packageVersion < 1) {
            this.update(packageVersion);
        }
        PlayerDataStoreNew.defaultMeta.uniqueId = UUID.fromString("0-0-0-0-0");
        PlayerDataStoreNew.defaultMeta.playerName = "~RESERVED META, SHOULD NOT BE USED~";
    }

    private void update(int currentVersion) {
        if (currentVersion < 1) {
            // empty if block
        }
        this.setPackageVersion(1);
    }

    public void save(PlayerMeta playerMeta) {
        UUID uuid = playerMeta.uniqueId;
        if (uuid == null) {
            this.logger.warn("Found a PlayerMeta that doesn't have an UUID! Ignoring...");
            return;
        }
        String path = this.getPath(playerMeta.uniqueId.toString()) + ".json";
        File file = this.directoryStorage.getFile(path, true);
        if (file == null) {
            this.logger.warn("Cannot save disguise configuration for " + String.valueOf(uuid));
            return;
        }
        String json = this.gson.toJson((Object)playerMeta);
        try {
            FileUtils.writeStringToFile((File)file, (String)json, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            this.logger.error("Can't write content to file: " + t.getMessage());
        }
    }

    @Override
    protected PlayerMeta getDefault() {
        return defaultMeta;
    }

    @Override
    public List<DisguiseMeta> getAvaliableDisguisesFor(class_3222 player) {
        return this.getPlayerMeta(player.method_5667()).getUnlockedDisguises();
    }

    @Override
    public boolean grantMorphToPlayer(class_3222 player, String disguiseIdentifier) {
        PlayerMeta playerMeta = this.getPlayerMeta(player.method_5667());
        DisguiseMeta disguiseMeta = DisguiseUtils.getDisguiseMeta(disguiseIdentifier);
        if (disguiseMeta == null) {
            return false;
        }
        if (playerMeta.getUnlockedDisguiseIdentifiers().stream().anyMatch(str -> str.equalsIgnoreCase(disguiseIdentifier))) {
            return false;
        }
        playerMeta.addDisguise(disguiseMeta);
        this.save(playerMeta);
        return true;
    }

    @Override
    public boolean revokeMorphFromPlayer(class_3222 player, String disguiseIdentifier) {
        PlayerMeta playerMeta = this.getPlayerMeta(player.method_5667());
        DisguiseMeta match = playerMeta.getUnlockedDisguises().stream().filter(meta -> meta.equals(disguiseIdentifier)).findFirst().orElse(null);
        if (match == null) {
            return false;
        }
        playerMeta.removeDisguise(match);
        return true;
    }

    private boolean isDefaultMeta(@Nullable PlayerMeta meta) {
        return meta == null || meta == defaultMeta;
    }

    @Override
    public PlayerMeta getPlayerMeta(UUID uuid) {
        String playerName;
        PlayerMeta tracked = this.trackedPlayerMetaMap.getOrDefault(uuid, null);
        if (tracked != null) {
            return tracked;
        }
        PlayerMeta storedMeta = (PlayerMeta)this.get(uuid.toString());
        class_3222 matchingPlayer = MorphServerLoader.mcserver.method_3760().method_14602(uuid);
        String string = playerName = matchingPlayer == null ? uuid.toString() : matchingPlayer.method_7334().name();
        if (!this.isDefaultMeta(storedMeta)) {
            storedMeta.playerName = playerName;
            this.initializePlayerMeta(storedMeta, uuid);
            this.trackedPlayerMetaMap.put(uuid, storedMeta);
            return storedMeta;
        }
        PlayerMeta metaInstance = new PlayerMeta();
        metaInstance.uniqueId = uuid;
        metaInstance.playerName = playerName;
        this.initializePlayerMeta(metaInstance, uuid);
        this.trackedPlayerMetaMap.put(uuid, metaInstance);
        return metaInstance;
    }

    private void initializePlayerMeta(PlayerMeta meta, UUID matchingUUID) {
        meta.uniqueId = matchingUUID;
        this.logger.info("Doing init for " + String.valueOf(meta));
        ObjectArrayList list = new ObjectArrayList();
        List<String> unlockedDisguiseIdentifiers = meta.getUnlockedDisguiseIdentifiers();
        unlockedDisguiseIdentifiers.sort(null);
        unlockedDisguiseIdentifiers.forEach(disguiseId -> {
            DisguiseTypes type = DisguiseTypes.fromId(disguiseId);
            if (type != null) {
                list.add((Object)DisguiseUtils.getDisguiseMeta(disguiseId));
            } else {
                this.logger.warn("Unknown disguise identifier data '%s' owned by '%s'".formatted(disguiseId, matchingUUID));
            }
        });
        meta.setUnlockedDisguises((ObjectArrayList<DisguiseMeta>)list);
    }

    @Override
    public boolean reloadConfiguration() {
        this.clearCache();
        this.trackedPlayerMetaMap.clear();
        if (this.noLazyLoad.get()) {
            this.loadAll();
        }
        return true;
    }

    @Override
    public boolean saveConfiguration() {
        this.trackedPlayerMetaMap.forEach((uuid, meta) -> this.save((PlayerMeta)meta));
        return true;
    }

    public void shouldLoadAllData(boolean val) {
        this.noLazyLoad.set(val);
        if (val) {
            this.loadAll();
        }
    }

    public List<PlayerMeta> getAll() {
        return this.trackedPlayerMetaMap.values().stream().toList();
    }

    public void loadAll() {
        this.logger.info("Force loading all player data...");
        File[] files = this.directoryStorage.getFiles();
        int count = 0;
        for (File file : files) {
            PlayerMeta meta;
            if (file.isDirectory()) continue;
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            UUID uuid = null;
            try {
                uuid = UUID.fromString(fileName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (uuid == null || this.trackedPlayerMetaMap.containsKey(uuid) || this.isDefaultMeta(meta = (PlayerMeta)this.get(fileName))) continue;
            this.initializePlayerMeta(meta, uuid);
            this.trackedPlayerMetaMap.put(uuid, meta);
            ++count;
        }
        this.logger.info("Loaded %s player data".formatted(count));
    }

    public static class PackageVersions {
        public static final int INITIAL = 1;
    }
}

