/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.server.storage.playerdata.paper;

import com.google.gson.annotations.Expose;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.server.misc.DisguiseMeta;

public class PlayerMeta {
    @Expose(serialize=false)
    public UUID uniqueId;
    @Expose
    @Nullable
    public String playerName;
    @Expose(serialize=false)
    private final ObjectArrayList<DisguiseMeta> unlockedDisguises = new ObjectArrayList();
    @Expose
    private final ObjectArrayList<String> unlockedDisguiseIdentifiers = new ObjectArrayList();
    @Expose
    public boolean showDisguiseToSelf = false;
    @Expose
    public boolean shownDisplayToSelfHint = false;
    @Expose
    public boolean shownClientSkillHint;
    @Expose
    public boolean shownMorphHint;
    @Expose
    public boolean shownMorphClientHint;

    public @Unmodifiable List<DisguiseMeta> getUnlockedDisguises() {
        return new ObjectImmutableList(this.unlockedDisguises);
    }

    public void setUnlockedDisguises(ObjectArrayList<DisguiseMeta> newList) {
        this.unlockedDisguises.clear();
        this.unlockedDisguises.addAll(newList);
        this.unlockedDisguiseIdentifiers.clear();
        this.unlockedDisguises.forEach(info -> this.unlockedDisguiseIdentifiers.add((Object)info.getKey()));
    }

    public void addDisguise(DisguiseMeta info) {
        this.unlockedDisguiseIdentifiers.add((Object)info.getKey());
        this.unlockedDisguises.add((Object)info);
    }

    public void removeDisguise(DisguiseMeta info) {
        this.unlockedDisguiseIdentifiers.remove((Object)info.getKey());
        this.unlockedDisguises.remove((Object)info);
    }

    public List<String> getUnlockedDisguiseIdentifiers() {
        return new ObjectArrayList(this.unlockedDisguiseIdentifiers);
    }

    public String toString() {
        return "PlayerMeta{ UUID=%s, Name=%s }".formatted(this.uniqueId, this.playerName);
    }
}

