/*
 * Decompiled with CFR 0.152.
 */
package xiamomc.pluginbase.Bindables;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xiamomc.pluginbase.Bindables.IBindable;
import xiamomc.pluginbase.WeakReferenceList;

public class Bindable<T>
implements IBindable<T> {
    private T value;
    private final WeakReferenceList<Bindable<T>> binds = new WeakReferenceList();
    private int triggers;
    @Nullable
    private Bindable<T> bindTarget;
    private final WeakReference<Bindable<T>> weakRef = new WeakReference<Bindable>(this);
    private final List<BiConsumer<T, T>> valueChangeConsumers = new ObjectArrayList();

    public Bindable() {
    }

    public Bindable(T value) {
        this.value = value;
    }

    public void set(T val) {
        if (this.value == val) {
            return;
        }
        T oldVal = this.value;
        this.value = val;
        this.triggerValueChange(this, oldVal, val);
    }

    private void syncValue(Bindable<T> source, T newVal) {
        if (source == this || this.value == newVal) {
            return;
        }
        T oldVal = this.value;
        this.value = newVal;
        this.triggerValueChange(source, oldVal, newVal);
    }

    private void triggerValueChange(Bindable<T> source, T oldVal, T newVal) {
        ++this.triggers;
        if (this.triggers >= 3) {
            this.removeReleasedRefs();
            this.triggers = 0;
        }
        this.valueChangeConsumers.forEach(c -> c.accept(oldVal, newVal));
        this.binds.forEach(b -> {
            if (b == this || b == null) {
                return;
            }
            b.syncValue(source, newVal);
        });
    }

    public void triggerChange() {
        this.triggerValueChange(this, null, this.value);
    }

    @ApiStatus.Internal
    public void setInternal(Object val) {
        this.set(val);
    }

    @Override
    public T get() {
        return this.value;
    }

    private void removeReleasedRefs() {
        this.binds.removeNull();
    }

    public void dispose() {
        if (this.bindTarget != null) {
            this.bindTarget.binds.remove(this);
            this.bindTarget = null;
        }
        this.binds.forEach(ref -> ref.binds.remove(this));
    }

    @Override
    public void bindTo(Bindable<T> other) {
        if (other == null || other == this || this.binds.contains((Bindable<WeakReference<Bindable<T>>>)((Object)other.weakRef))) {
            return;
        }
        if (this.bindTarget != null) {
            this.binds.remove((Bindable<WeakReference<Bindable<T>>>)((Object)this.bindTarget.weakRef));
            this.bindTarget.binds.remove((Bindable<WeakReference<Bindable<T>>>)((Object)this.weakRef));
        }
        other.binds.add(this.weakRef);
        this.binds.add(other.weakRef);
        this.set(other.value);
        this.bindTarget = other;
    }

    public void unBindFromTarget() {
        if (this.bindTarget == null) {
            return;
        }
        this.bindTarget.binds.remove(this);
    }

    public void unBindBindings() {
        this.binds.forEach(b -> b.binds.remove(this));
        if (this.bindTarget != null) {
            this.bindTarget.binds.remove(this);
        }
    }

    @Override
    public void bindTo(IBindable<T> other) {
        if (!(other instanceof Bindable)) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7684\u76ee\u6807\u4e0d\u662fBindable\u5b9e\u4f8b");
        }
        Bindable bindable = (Bindable)other;
        this.bindTo(bindable);
    }

    public void onValueChanged(BiConsumer<T, T> consumer) {
        this.onValueChanged(consumer, false);
    }

    @Override
    public void onValueChanged(BiConsumer<T, T> consumer, boolean runOnce) {
        this.valueChangeConsumers.add(consumer);
        if (runOnce) {
            consumer.accept(null, this.value);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

