/*
 * Decompiled with CFR 0.152.
 */
package xiamomc.pluginbase.Bindables;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import xiamomc.pluginbase.Bindables.BindableListIterator;
import xiamomc.pluginbase.Bindables.IBindableList;
import xiamomc.pluginbase.Bindables.TriggerReason;
import xiamomc.pluginbase.WeakReferenceList;

public class BindableList<T>
implements IBindableList<T> {
    final List<T> list = new ObjectArrayList();
    private final List<BiConsumer<List<T>, TriggerReason>> consumers = new ObjectArrayList();
    private int triggers;
    private final List<T> nullTList;
    final WeakReferenceList<BindableList<T>> binds = new WeakReferenceList();
    private BindableList<T> bindTarget;
    private final WeakReference<BindableList<T>> weakRef = new WeakReference<BindableList>(this);

    private ListIterator<T> getBindableIterator() {
        return new BindableListIterator(this);
    }

    public BindableList() {
        this.nullTList = new ArrayList<T>();
        this.nullTList.add(null);
    }

    public BindableList(Collection<T> collection) {
        this();
        this.list.addAll(collection);
    }

    @Override
    public void onListChanged(BiConsumer<List<T>, TriggerReason> consumer) {
        this.onListChanged(consumer, false);
    }

    @Override
    public void onListChanged(BiConsumer<List<T>, TriggerReason> consumer, boolean runOnce) {
        this.consumers.add(consumer);
        if (runOnce) {
            consumer.accept((List<ObjectArrayList>)new ObjectArrayList(this.list), TriggerReason.ADD);
        }
    }

    private void removeReleasedRefs() {
        this.binds.removeNull();
    }

    private void triggerChange(BindableList<T> source, List<T> value, TriggerReason reason) {
        ++this.triggers;
        if (this.triggers >= 5) {
            this.removeReleasedRefs();
            this.triggers = 0;
        }
        this.binds.forEach(b -> {
            if (b == null) {
                return;
            }
            b.syncValue(source, value, reason);
        });
        this.consumers.forEach(c -> c.accept(value, reason));
    }

    private void triggerChange(BindableList<T> source, T value, TriggerReason reason) {
        this.triggerChange(source, (T)(value == null ? this.nullTList : List.of(value)), reason);
    }

    void triggerChange(T value, TriggerReason reason) {
        this.triggerChange(this, value, reason);
    }

    void triggerChange(List<T> value, TriggerReason reason) {
        this.triggerChange((BindableList<T>)this, (T)value, reason);
    }

    private void syncValue(BindableList<T> source, Collection<T> changes, TriggerReason operation) {
        if (source == this) {
            return;
        }
        if (operation == TriggerReason.ADD) {
            this.list.addAll(changes);
        } else {
            this.list.removeAll(changes);
        }
    }

    @Override
    public void bindTo(IBindableList<T> other) {
        if (!(other instanceof BindableList)) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7684\u76ee\u6807\u4e0d\u662fBindableList\u5b9e\u4f8b");
        }
        BindableList bindable = (BindableList)other;
        this.bindTo(bindable);
    }

    @Override
    public void bindTo(BindableList<T> other) {
        if (other == null || other == this || this.binds.contains((BindableList<WeakReference<BindableList<T>>>)((Object)other.weakRef))) {
            return;
        }
        if (this.bindTarget != null) {
            this.binds.remove((BindableList<WeakReference<BindableList<T>>>)((Object)this.bindTarget.weakRef));
            this.bindTarget.binds.remove((BindableList<WeakReference<BindableList<T>>>)((Object)this.weakRef));
        }
        this.clear();
        this.addAll((Collection<? extends T>)other.list);
        other.binds.add(this.weakRef);
        this.binds.add(other.weakRef);
        this.bindTarget = other;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] t1s) {
        return this.list.toArray(t1s);
    }

    @Override
    public boolean add(T t) {
        this.list.add(t);
        this.triggerChange(t, TriggerReason.ADD);
        return true;
    }

    @Override
    public T remove(int i) {
        T val = this.list.remove(i);
        if (val != null) {
            this.triggerChange(val, TriggerReason.REMOVE);
        }
        return val;
    }

    @Override
    public boolean remove(Object o) {
        boolean success = this.list.remove(o);
        if (success) {
            this.triggerChange(o, TriggerReason.REMOVE);
        }
        return success;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> collection) {
        boolean success = this.list.addAll(collection);
        if (success) {
            this.triggerChange((List)collection, TriggerReason.ADD);
        }
        return success;
    }

    @Override
    public boolean addAll(int i, @NotNull Collection<? extends T> collection) {
        boolean success = this.list.addAll(i, collection);
        if (success) {
            this.triggerChange((List)collection, TriggerReason.ADD);
        }
        return success;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        boolean success = this.list.removeAll(collection);
        if (success) {
            this.triggerChange(collection.stream().toList(), TriggerReason.REMOVE);
        }
        return success;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        ObjectArrayList changes = new ObjectArrayList(this.list);
        if (this.list.retainAll(collection)) {
            changes.removeIf(this.list::contains);
            this.triggerChange((List<T>)changes, TriggerReason.REMOVE);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public void clear() {
        ObjectArrayList values = new ObjectArrayList(this.list);
        this.list.clear();
        this.triggerChange((List<T>)values, TriggerReason.REMOVE);
    }

    @Override
    public T get(int i) {
        return this.list.get(i);
    }

    @Override
    public T set(int i, T t) {
        T val;
        if (i < this.list.size()) {
            T oldVal = this.list.get(i);
            this.triggerChange(oldVal, TriggerReason.REMOVE);
        }
        if ((val = this.list.set(i, t)) != null) {
            this.triggerChange(t, TriggerReason.ADD);
        }
        return val;
    }

    @Override
    public void add(int i, T t) {
        this.list.add(i, t);
        this.triggerChange(t, TriggerReason.ADD);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.getBindableIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.getBindableIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int i) {
        return this.getBindableIterator();
    }

    @Override
    @NotNull
    public List<T> subList(int i, int i1) {
        return this.list.subList(i, i1);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        ListIterator<T> it = this.list.listIterator();
        while (it.hasNext()) {
            T obj = it.next();
            builder.append(obj);
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        return "[" + String.valueOf(builder) + "]@" + Integer.toHexString(this.hashCode());
    }
}

